/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.locale;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.util.CMyFilenameFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

final class LocaleDefinitions {
    private static Logger logger = Logger.getLogger(LocaleDefinitions.class);
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String RESOURCE = "locale";
    private static final String BASENAME = "presentation";
    private static final char UNDERSCORE = '_';
    private static final char DOT = '.';
    private Map m_cachedLocales;

    Map caculateLocales() {
        if (this.m_cachedLocales == null) {
            List list = this.caculateLocaleDefinitions();
            this.m_cachedLocales = new HashMap(list.size());
            String string = null;
            for (int i = 0; i < list.size(); ++i) {
                string = (String)list.get(i);
                this.m_cachedLocales.put(string, this.createLocale(string));
            }
        }
        return this.m_cachedLocales;
    }

    private Locale createLocale(String string) {
        Locale locale = null;
        int n = BASENAME.length();
        if (n == string.length()) {
            locale = new Locale("", "");
        } else {
            String string2 = string.substring(n + 1);
            if ((n = string2.indexOf(95)) == -1) {
                locale = new Locale(string2, "", "");
                n = BASENAME.length();
            } else {
                String string3 = string2.substring(0, n);
                if ((n = (string2 = string2.substring(n + 1)).indexOf(95)) == -1) {
                    locale = new Locale(string3, string2, "");
                    n = BASENAME.length();
                } else {
                    String string4 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                    locale = new Locale(string3, string4, string2);
                }
            }
        }
        return locale;
    }

    public static File[] listFiles(String string, String string2) {
        File file = new File(string);
        if (string2.charAt(0) != '.') {
            string2 = "." + string2;
        }
        File[] fileArray = file.listFiles(new CMyFilenameFilter(string2));
        return fileArray;
    }

    private List caculateLocaleDefinitions() {
        String string = ConfigConstants.DIR_APPROOT + RESOURCE + File.separatorChar;
        File[] fileArray = LocaleDefinitions.listFiles(string, PROPERTIES_SUFFIX);
        if (fileArray == null) {
            logger.error((Object)(I18NMessage.get(LocaleDefinitions.class, "LocaleDefinitions.label1", "\u8bfb\u53d6\u591a\u8bed\u79cd\u8d44\u6e90\u6587\u4ef6\u65f6\u51fa\u9519\uff01[\u8bbf\u95ee\u76ee\u5f55\u4e3a<") + string + I18NMessage.get(LocaleDefinitions.class, "LocaleDefinitions.label2", ">\uff0c\u8981\u83b7\u53d6\u7684\u8d44\u6e90\u6587\u4ef6\u683c\u5f0f\u4e3a<*.") + PROPERTIES_SUFFIX + ">]"));
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
        String string2 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            string2 = fileArray[i].getName();
            string2 = string2.substring(0, string2.indexOf(46));
            arrayList.add(string2);
        }
        return arrayList;
    }
}

