/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.ids;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.StdHttpSessionBasedActor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.presentation.ids.ActorHelper;
import com.trs.presentation.util.LoginHelper;
import com.trs.presentation.util.LoginPasswordEncrypter;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class WCM52Actor
extends StdHttpSessionBasedActor {
    private static Logger logger = Logger.getLogger(WCM52Actor.class);
    private static final String LOGIN_FLAG = "WCM52.loginUser";
    private static final boolean ENABLE_FROM_IDS = true;

    public boolean checkLocalLogin(HttpSession httpSession) {
        if (httpSession == null) {
            return false;
        }
        return httpSession.getAttribute(LOGIN_FLAG) != null;
    }

    private Group getGroupFromIdsId(String string) {
        WCMFilter wCMFilter = new WCMFilter("", "nameinids='" + string + "'", "");
        try {
            Groups groups = Groups.openWCMObjs(User.getSystem(), wCMFilter);
            if (groups.size() > 0) {
                return (Group)groups.getAt(0);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("get group fail![nameinids = " + string), (Throwable)exception);
        }
        return null;
    }

    private User registerUser(SSOUser sSOUser) {
        if (sSOUser == null) {
            logger.error((Object)"[registerUser]\u65b9\u6cd5\u4e2d\u7684SSOUser\u5bf9\u8c61\u4e3anull\uff01");
            return null;
        }
        String string = this.dealWithName(sSOUser.getUserName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f00\u59cb\u6ce8\u518c\u7528\u6237[" + string + "]!"));
        }
        User user = User.getSystem();
        ContextHelper.initContext(user);
        try {
            User user2 = User.createNewInstance();
            user2.setName(string);
            user2.setNickName(sSOUser.getNickName());
            user2.setPassword(ConfigServer.getServer().getSysConfigValue("SYSUSERPWD", "trsadmin"));
            user2.setTrueName(sSOUser.getTrueName());
            user2.setAddress(sSOUser.getProperty("address"));
            user2.setTel(sSOUser.getProperty("tel"));
            user2.setMobile(sSOUser.getProperty("mobile"));
            user2.setEmail(sSOUser.getMail());
            user2.setReminderQuestion("CreateBy?");
            user2.setReminderAnswer("IDS");
            user2.setStatus(30);
            this.setIdsExtProps(sSOUser, user2);
            user2.save(user);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6ce8\u518c\u7528\u6237[" + string + "]\u5b8c\u6210!"));
            }
            logger.info((Object)("\u6ce8\u518c\u7528\u6237[" + string + "]\u6210\u529f!"));
            return user2;
        }
        catch (WCMException wCMException) {
            logger.error((Object)("\u6ce8\u518c\u7528\u6237[" + string + "]\u5931\u8d25\uff01"), (Throwable)wCMException);
            return null;
        }
    }

    public void loadLoginUser(HttpServletRequest httpServletRequest, SSOUser sSOUser) throws ActorException {
        String string = this.dealWithName(sSOUser.getUserName());
        User user = User.findByName(string);
        if (user == null) {
            user = this.registerUser(sSOUser);
            for (int i = 0; i < sSOUser.getSSOGroups().size(); ++i) {
                this.moveToGroup(sSOUser, (SSOGroup)sSOUser.getSSOGroups().get(i));
            }
        }
        if (user == null) {
            logger.error((Object)("\u7528\u6237[" + string + "]\u6ce8\u518c\u5931\u8d25\uff01"));
        }
        HttpSession httpSession = httpServletRequest.getSession();
        if (null != user) {
            LoginHelper loginHelper = new LoginHelper(httpServletRequest, httpSession.getServletContext());
            try {
                loginHelper.loginByIDS(user.getName());
            }
            catch (Throwable throwable) {
                logger.error((Object)(httpSession.getId() + "login fail, user[" + string + "]  fail to login!"), throwable);
            }
        } else {
            logger.error((Object)(httpSession.getId() + " login fail, user=null! UserName=" + string + ", req=" + httpServletRequest.getRequestURI() + ", ip=" + httpServletRequest.getRemoteAddr()));
        }
    }

    private String dealWithName(String string) {
        String string2 = string;
        String string3 = " - ";
        int n = string2.indexOf(string3);
        int n2 = string2.indexOf("@");
        if (n != -1) {
            string2 = n2 != -1 ? string2.substring(n + string3.length(), n2) : string2.substring(n + string3.length());
        } else if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    public void logout(HttpSession httpSession) throws ActorException {
        if (httpSession != null) {
            httpSession.invalidate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"logout succeed !");
            }
        }
    }

    public boolean addUser(SSOUser sSOUser, HttpServletRequest httpServletRequest) throws ActorException {
        ContextHelper.initContext(User.getSystem());
        String string = sSOUser.getUserName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f00\u59cb\u6dfb\u52a0\u7528\u6237 [" + string + "]"));
        }
        boolean bl = false;
        try {
            User user = User.findByName(string);
            if (user == null) {
                user = this.registerUser(sSOUser);
            } else if (user.getStatus() != 30) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("enable [" + user + "]"));
                }
                user.setStatus(30);
                user.save(User.getSystem());
            }
            for (int i = 0; i < sSOUser.getSSOGroups().size(); ++i) {
                this.moveToGroup(sSOUser, (SSOGroup)sSOUser.getSSOGroups().get(i));
            }
            bl = user != null;
        }
        catch (Exception exception) {
            logger.error((Object)("\u6dfb\u52a0\u7528\u6237[" + string + "]\u5931\u8d25\uff01"), (Throwable)exception);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u7528\u6237 [" + string + "]\u6dfb\u52a0\u6210\u529f\uff01"));
        }
        return bl;
    }

    public boolean disableUser(SSOUser sSOUser) throws ActorException {
        ContextHelper.initContext(User.getSystem());
        try {
            User user;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Begin to disable user [" + sSOUser.getUserName() + "]\uff01"));
            }
            if ((user = User.findByName(sSOUser.getUserName())) != null) {
                user.setStatus(20);
                user.save();
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Disable user [userName=" + sSOUser.getUserName() + "] fail\uff01"), (Throwable)exception);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Disable user [" + sSOUser.getUserName() + "] success\uff01"));
        }
        return true;
    }

    public boolean enableUser(SSOUser sSOUser) throws ActorException {
        ContextHelper.initContext(User.getSystem());
        try {
            User user = User.findByName(sSOUser.getUserName());
            if (user != null) {
                user.setStatus(30);
                user.save();
            }
        }
        catch (Exception exception) {
            logger.error((Object)("EnableUser user [userName=" + sSOUser.getUserName() + "] fail!"), (Throwable)exception);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("EnableUser user [" + sSOUser.getUserName() + "] success\uff01"));
        }
        return true;
    }

    public String extractUserName(HttpServletRequest httpServletRequest) throws ActorException {
        if (httpServletRequest == null) {
            return null;
        }
        String string = httpServletRequest.getParameter("UserName");
        if (string == null || "".equals(string)) {
            return "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UserName begin:::" + string + "\uff01"));
        }
        string = CMyString.getStr(string, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UserName end:::" + string + "\uff01"));
        }
        return string;
    }

    public String extractUserPwd(HttpServletRequest httpServletRequest) throws ActorException {
        if (httpServletRequest == null) {
            return null;
        }
        String string = httpServletRequest.getParameter("PassWord");
        if (string == null || "".equals(string)) {
            return "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Password begin:::" + string));
        }
        if (LoginPasswordEncrypter.isEncrypted(string)) {
            string = LoginPasswordEncrypter.deEncrypt(string);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Password  end:::" + string));
        }
        return string;
    }

    public boolean removeUser(SSOUser sSOUser, HttpServletRequest httpServletRequest) throws ActorException {
        ContextHelper.initContext(User.getSystem());
        try {
            User user = User.findByName(sSOUser.getUserName());
            if (user != null) {
                ActorHelper.getUserMgr().delete(user, true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RemoveUser user [" + sSOUser.getUserName() + "] success\uff01"));
            }
            return true;
        }
        catch (WCMException wCMException) {
            logger.error((Object)("fail to removeUser user: " + sSOUser.getUserName()), (Throwable)wCMException);
            return false;
        }
    }

    public boolean updateUser(SSOUser sSOUser, HttpServletRequest httpServletRequest) throws ActorException {
        ContextHelper.initContext(User.getSystem());
        String string = sSOUser.getUserName();
        try {
            User user = User.findByName(string);
            if (!user.canEdit(User.getSystem())) {
                throw new RuntimeException("update user fail,can't lock obj.");
            }
            user.setNickName(sSOUser.getNickName());
            user.setTrueName(sSOUser.getTrueName());
            user.setAddress(sSOUser.getProperty("address"));
            user.setTel(sSOUser.getProperty("tel"));
            user.setMobile(sSOUser.getProperty("mobile"));
            user.setEmail(sSOUser.getMail());
            user.setReminderQuestion("CreateBy?");
            user.setReminderAnswer("IDS");
            user.setStatus(30);
            this.setIdsExtProps(sSOUser, user);
            user.save(User.getSystem());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UpdateUser user [" + sSOUser.getUserName() + "] success\uff01"));
            }
            return true;
        }
        catch (WCMException wCMException) {
            wCMException.printStackTrace(System.out);
            logger.error((Object)("UpdateUser user fail: [UserName=" + sSOUser.getUserName() + "]!"), (Throwable)wCMException);
            return false;
        }
    }

    private void setIdsExtProps(SSOUser sSOUser, User user) throws WCMException {
        Set set = sSOUser.propertyNames();
        for (String string : set) {
            if (!string.startsWith("IDSEXT_")) continue;
            String string2 = string.substring(7);
            if (DBManager.getDBManager().getFieldInfo("WCMUSER", string2) == null) {
                user.setAttribute(string2, sSOUser.getProperty(string));
                continue;
            }
            user.setProperty(string2, sSOUser.getProperty(string));
        }
    }

    public boolean userExist(SSOUser sSOUser) throws ActorException {
        ContextHelper.initContext(User.getSystem());
        User user = User.findByName(sSOUser.getUserName());
        return user != null;
    }

    public boolean addGroup(SSOGroup sSOGroup, HttpServletRequest httpServletRequest) {
        ContextHelper.initContext(User.getSystem());
        String string = sSOGroup.getGroupFullPath();
        String[] stringArray = this.getGroupInfos(string)[1];
        String[] stringArray2 = this.getGroupInfos(string)[0];
        Group group = this.getGroupWithNameAndParentId(stringArray[0], 0);
        try {
            if (group == null) {
                group = this.saveParentGrp(group, stringArray[0], stringArray2[0], 0);
            }
            Group group2 = group;
            for (int i = 1; i < stringArray.length - 1; ++i) {
                Group group3 = this.getGroupWithNameAndParentId(stringArray[i], group2.getId());
                if (group3 == null) {
                    group3 = this.saveParentGrp(group3, stringArray[i], stringArray2[i], group2.getId());
                }
                group2 = group3;
            }
            Group group4 = this.getGroupWithNameAndParentId(sSOGroup.getGroupDisplayName(), group2.getId());
            this.saveGroup(sSOGroup, group4, group2.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add group [" + sSOGroup.getGroupDisplayName() + "] success\uff01"));
            }
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"Add group fail!", (Throwable)exception);
            return false;
        }
    }

    private Group saveParentGrp(Group group, String string, String string2, int n) throws WCMException {
        if (group == null) {
            group = Group.createNewInstance();
            ContextHelper.initContext(User.getSystem());
            User user = ContextHelper.getLoginUser();
            group.setName(string);
            group.setProperty("NAMEINIDS", string2);
            group.setParent(n);
            group.setCrUser(user);
            group.save(user);
        }
        return group;
    }

    public boolean updateGroup(SSOGroup sSOGroup, HttpServletRequest httpServletRequest) {
        ContextHelper.initContext(User.getSystem());
        Group group = null;
        try {
            group = this.getGroupFromIdsId(sSOGroup.getGroupId());
            this.saveGroup(sSOGroup, group, group.getParentId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Update group [" + sSOGroup.getGroupDisplayName() + "] success\uff01"));
            }
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)"update group fail ~ ", (Throwable)exception);
            return false;
        }
    }

    public boolean delGroup(SSOGroup sSOGroup, HttpServletRequest httpServletRequest) {
        ContextHelper.initContext(User.getSystem());
        Group group = this.getGroupFromIdsId(sSOGroup.getGroupId());
        if (group == null) {
            logger.error((Object)("path of the group is not exist![path=" + sSOGroup.getGroupFullPath() + "]"));
            return false;
        }
        try {
            GroupMgr groupMgr = new GroupMgr();
            groupMgr.delete(group);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delete group [" + sSOGroup.getGroupDisplayName() + "] success\uff01"));
            }
            return true;
        }
        catch (Exception exception) {
            logger.error((Object)("delete group fail,groupname=" + group.getName()), (Throwable)exception);
            return false;
        }
    }

    private String[][] getGroupInfos(String string) {
        if (string == null) {
            return new String[0][0];
        }
        String[] stringArray = string.split("/");
        String[][] stringArray2 = new String[2][stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[0][i] = stringArray[i].split("#")[0];
            stringArray2[1][i] = stringArray[i].split("#")[1];
        }
        return stringArray2;
    }

    private Group saveGroup(SSOGroup sSOGroup, Group group, int n) throws WCMException {
        ContextHelper.initContext(User.getSystem());
        if (group == null) {
            group = Group.createNewInstance();
            group.setParent(n);
            group.setCrUser(ContextHelper.getLoginUser());
        }
        group.setName(sSOGroup.getGroupDisplayName());
        group.setDesc(sSOGroup.getGroupDisplayName());
        group.setEmail(sSOGroup.getProperty("groupMail"));
        group.setProperty("NAMEINIDS", sSOGroup.getGroupId());
        Properties properties = sSOGroup.getGroupProperty();
        Set<Object> set = properties.keySet();
        for (String string : set) {
            if (!string.startsWith("IDSEXT_")) continue;
            String string2 = string.substring(7);
            if (DBManager.getDBManager().getFieldInfo("WCMGROUP", string2) == null) {
                group.setAttribute(string2, sSOGroup.getProperty(string));
                continue;
            }
            group.setProperty(string2, sSOGroup.getProperty(string));
        }
        ActorHelper.getGroupMgr().save(group);
        return group;
    }

    public Group getGroupByPath(String[] stringArray) {
        Group group = this.getGroupWithNameAndParentId(stringArray[0], 0);
        if (group == null) {
            return null;
        }
        Group group2 = group;
        for (int i = 1; i < stringArray.length; ++i) {
            Group group3 = this.getGroupWithNameAndParentId(stringArray[i], group2.getId());
            if (group3 == null) {
                return null;
            }
            group2 = group3;
        }
        return group2;
    }

    private Group getGroupWithNameAndParentId(String string, int n) {
        String string2 = "gname=? and parentid=?";
        try {
            WCMFilter wCMFilter = new WCMFilter("", string2, "");
            wCMFilter.addSearchValues(string);
            wCMFilter.addSearchValues(n);
            Groups groups = Groups.openWCMObjs(User.getSystem(), wCMFilter);
            if (groups.size() > 0) {
                return (Group)groups.getAt(0);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean moveToGroup(SSOUser sSOUser, SSOGroup sSOGroup) {
        ContextHelper.initContext(User.getSystem());
        if (sSOUser == null || sSOGroup == null) {
            logger.info((Object)"\u4f20\u5165 \u7684\u7528\u6237\u548c\u7ec4\u7ec7\u4e3a\u7a7a\uff01");
            return false;
        }
        User user = ActorHelper.getUserFromSSOUser(sSOUser);
        Group group = ActorHelper.getGroupFromSSOGroup(sSOGroup);
        if (user == null || group == null) {
            logger.error((Object)"\u6ca1\u6709\u627e\u5230\u7528\u6237\u6216\u8005\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
            return false;
        }
        try {
            ActorHelper.getGroupMgr().addUser(user, group);
        }
        catch (Exception exception) {
            logger.error((Object)("\u6dfb\u52a0\u7528\u6237\u5230\u7ec4\u7ec7\u5931\u8d25\uff01[UserName=" + user.getName() + ",GroupName=" + group.getName() + "]"), (Throwable)exception);
            return false;
        }
        return true;
    }

    public boolean removeFromGroup(SSOUser sSOUser, SSOGroup sSOGroup) {
        ContextHelper.initContext(User.getSystem());
        User user = ActorHelper.getUserFromSSOUser(sSOUser);
        Group group = ActorHelper.getGroupFromSSOGroup(sSOGroup);
        if (user == null || group == null) {
            logger.error((Object)"\u6ca1\u6709\u627e\u5230\u7528\u6237\u6216\u8005\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
            return false;
        }
        try {
            ActorHelper.getGroupMgr().removeUser(user, group);
            if (logger.isDebugEnabled()) {
                logger.error((Object)("\u5c06\u7528\u6237[" + user.getName() + "]\u4ece\u7ec4\u7ec7[" + group.getName() + "]\u5220\u9664\u6210\u529f\uff01"));
            }
        }
        catch (Exception exception) {
            logger.error((Object)("\u5c06\u7528\u6237\u4ece\u7ec4\u7ec7\u4e2d\u5220\u9664\u5931\u8d25\uff01[UserName=" + user.getName() + ",GroupName=" + group.getName() + "]"), (Throwable)exception);
            return false;
        }
        return true;
    }
}

