/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.ids;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class ActorHelper {
    private static Logger logger = Logger.getLogger(ActorHelper.class);

    public static UserMgr getUserMgr() {
        return (UserMgr)DreamFactory.createObjectById("UserMgr");
    }

    public static GroupMgr getGroupMgr() {
        return (GroupMgr)DreamFactory.createObjectById("GroupMgr");
    }

    public static String[][] getGroupInfos(String string) {
        if (string == null) {
            return new String[0][0];
        }
        String[] stringArray = string.split("/");
        String[][] stringArray2 = new String[2][stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[0][i] = stringArray[i].split("#")[0];
            stringArray2[1][i] = stringArray[i].split("#")[1];
        }
        return stringArray2;
    }

    public static Group saveGroup(SSOGroup sSOGroup, Group group, int n) throws WCMException {
        ContextHelper.initContext(User.getSystem());
        if (group == null) {
            group = Group.createNewInstance();
            group.setParent(n);
            group.setCrUser(ContextHelper.getLoginUser());
        }
        group.setName(sSOGroup.getGroupDisplayName());
        group.setDesc(sSOGroup.getGroupDisplayName());
        group.setGroupOrder(Integer.parseInt(sSOGroup.getProperty("displayOrder")));
        group.setProperty("IdsGroupId", sSOGroup.getGroupId());
        ActorHelper.getGroupMgr().save(group);
        return group;
    }

    public static Group getGroupFromSSOGroup(SSOGroup sSOGroup) {
        String string = sSOGroup.getGroupId();
        String string2 = "NAMEINIDS='" + string + "'";
        try {
            WCMFilter wCMFilter = new WCMFilter("", string2, "");
            Groups groups = Groups.openWCMObjs(User.getSystem(), wCMFilter);
            if (groups.size() > 0) {
                return (Group)groups.getAt(0);
            }
            return null;
        }
        catch (Exception exception) {
            logger.error((Object)"\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25\uff0c", (Throwable)exception);
            return null;
        }
    }

    public static User getUserFromSSOUser(SSOUser sSOUser) {
        return User.findByName(sSOUser.getUserName());
    }
}

