/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import com.trs.infra.util.upgrade.dbcompare.Table;
import java.util.ArrayList;
import java.util.List;

public class TableDiff {
    public static final int TYPE_COLNEW = 0;
    public static final int TYPE_COLUPD = 1;
    public static final int TYPE_COLDEL = 2;
    private String tableName;
    private List newcols;
    private List updcols;
    private List delcols;
    private boolean newtable;
    private Table table;

    public TableDiff(String string) {
        this.tableName = string.toUpperCase();
        this.newcols = new ArrayList();
        this.updcols = new ArrayList();
        this.delcols = new ArrayList(5);
    }

    public TableDiff(Table table) {
        this.table = table;
        this.tableName = table.getTableName();
        this.newtable = true;
    }

    public List getNewcols() {
        return this.newcols;
    }

    public void setNewcols(List list) {
        this.newcols = list;
    }

    public List getUpdcols() {
        return this.updcols;
    }

    public void setUpdcols(List list) {
        this.updcols = list;
    }

    public List getDelcols() {
        return this.delcols;
    }

    public void setDelcols(List list) {
        this.delcols = list;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addColumn(Column column, int n) {
        switch (n) {
            case 0: {
                this.newcols.add(column);
                break;
            }
            case 1: {
                this.updcols.add(column);
                break;
            }
            case 2: {
                this.delcols.add(column);
                break;
            }
        }
    }

    public boolean isNewtable() {
        return this.newtable;
    }

    public Table getTable() {
        return this.table;
    }

    public String toString() {
        int n;
        int n2;
        if (this.table != null) {
            return this.table.toString();
        }
        if (this.newcols.isEmpty() && this.updcols.isEmpty() && this.delcols.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.tableName);
        stringBuffer.append(':');
        if (!this.newcols.isEmpty()) {
            stringBuffer.append("\nadd(");
            stringBuffer.append(this.newcols.get(0));
            n2 = this.newcols.size();
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(',');
                stringBuffer.append(this.newcols.get(n));
            }
            stringBuffer.append(')');
        }
        if (!this.updcols.isEmpty()) {
            stringBuffer.append("\nupd(");
            stringBuffer.append(this.updcols.get(0));
            n2 = this.updcols.size();
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(',');
                stringBuffer.append(this.updcols.get(n));
            }
            stringBuffer.append(')');
        }
        if (!this.delcols.isEmpty()) {
            stringBuffer.append("\ndel(");
            stringBuffer.append(this.delcols.get(0));
            n2 = this.delcols.size();
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(',');
                stringBuffer.append(this.delcols.get(n));
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }
}

