/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;

public class Table {
    public static final char ESCAPE_CHAR = '\"';
    private String tableName;
    private String[] primaryKey;
    private Map columns;

    public Table(String string) {
        this(string, null);
    }

    public Table(String string, String[] stringArray) {
        this.tableName = string;
        this.primaryKey = stringArray;
        this.columns = new HashMap(20, 0.5f);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String[] stringArray) {
        this.primaryKey = stringArray;
    }

    public Map getColumns() {
        return this.columns;
    }

    public void setColumns(SortedMap sortedMap) {
        this.columns = sortedMap;
    }

    public void addColumn(Column column) {
        if (column != null) {
            this.columns.put(column.name, column);
        }
    }

    public void removeColumn(Column column) {
        if (column != null) {
            this.columns.remove(column.name);
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("create table ");
        stringBuffer.append('\"');
        stringBuffer.append(this.tableName);
        stringBuffer.append('\"');
        stringBuffer.append(" (\n");
        Object[] objectArray = this.columns.values().toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Column column = (Column)object;
                Column column2 = (Column)object2;
                return column.order - column2.order;
            }
        });
        stringBuffer.append('\t').append(objectArray[0]);
        int n2 = objectArray.length;
        for (n = 1; n < n2; ++n) {
            Column column = (Column)objectArray[n];
            stringBuffer.append(",\n");
            stringBuffer.append('\t').append(column);
        }
        if (this.primaryKey != null && this.primaryKey.length > 0) {
            stringBuffer.append(",\n\tprimary key(");
            n2 = this.primaryKey.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('\"');
                stringBuffer.append(this.primaryKey[n]);
                stringBuffer.append('\"');
            }
            stringBuffer.append(')');
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

