/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import com.trs.infra.util.upgrade.dbcompare.MetaDataLoader;
import com.trs.infra.util.upgrade.dbcompare.Table;
import com.trs.infra.util.upgrade.dbcompare.TableDiff;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SchemaCompare {
    private MetaDataLoader source;
    private MetaDataLoader dest;
    private List diff4Source;
    private List diff4Dest;

    public SchemaCompare(MetaDataLoader metaDataLoader, MetaDataLoader metaDataLoader2) {
        this.source = metaDataLoader;
        this.dest = metaDataLoader2;
    }

    public List getDiff4Source() throws SQLException {
        if (this.diff4Source == null) {
            List list = this.compare(false);
            this.diff4Source = new ArrayList(list.size());
            this.diff4Source.addAll(list);
            list.clear();
        }
        return this.diff4Source;
    }

    public List getDiff4Dest() throws SQLException {
        if (this.diff4Dest == null) {
            List list = this.compare(true);
            this.diff4Dest = new ArrayList(list.size());
            this.diff4Dest.addAll(list);
            list.clear();
        }
        return this.diff4Dest;
    }

    public List compare(boolean bl) throws SQLException {
        this.source.load();
        this.dest.load();
        Map map = this.source.getTables();
        Map map2 = this.dest.getTables();
        if (bl) {
            return this.compare0(map, map2);
        }
        return this.compare0(map2, map);
    }

    private List compare0(Map map, Map map2) {
        Iterator iterator = map.entrySet().iterator();
        ArrayList<TableDiff> arrayList = new ArrayList<TableDiff>(10);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Table table = (Table)entry.getValue();
            Table table2 = (Table)map2.get(entry.getKey());
            if (table2 == null) {
                arrayList.add(new TableDiff(table));
                continue;
            }
            arrayList.add(this.compareColumns(table, table2));
        }
        return arrayList;
    }

    private TableDiff compareColumns(Table table, Table table2) {
        TableDiff tableDiff = new TableDiff(table.getTableName());
        Map map = table.getColumns();
        Map map2 = table2.getColumns();
        Iterator iterator = map.entrySet().iterator();
        HashMap hashMap = new HashMap(map2);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Column column = (Column)entry.getValue();
            Column column2 = (Column)map2.get(entry.getKey());
            hashMap.remove(entry.getKey());
            if (column2 == null) {
                tableDiff.addColumn(column, 0);
                continue;
            }
            if (column.equals(column2)) continue;
            tableDiff.addColumn(column, 1);
        }
        if (hashMap.size() > 0) {
            tableDiff.setDelcols(Arrays.asList(hashMap.values().toArray()));
        }
        return tableDiff;
    }
}

