/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.uftp.FtpConfig;
import com.trs.infra.util.uftp.FtpConnection;
import org.apache.log4j.Logger;

public class FtpConnectionImpSSH
extends FtpConnection {
    private static Logger s_logger = Logger.getLogger(FtpConnectionImpSSH.class);
    private Session m_oSftpSession;
    private ChannelSftp m_oSftpChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String verifyConfig() {
        String string;
        block30: {
            Exception exception6222;
            ChannelSftp channelSftp;
            Session session;
            block28: {
                String string2;
                string = null;
                session = null;
                channelSftp = null;
                FtpConfig ftpConfig = this.getFtpConfig();
                try {
                    string2 = ftpConfig.getUserName();
                    String string3 = ftpConfig.getHost();
                    int n = ftpConfig.getPort();
                    session = new JSch().getSession(string2, string3, n);
                    session.setUserInfo((UserInfo)new MyUserInfo());
                    session.connect();
                }
                catch (Exception exception2) {
                    string = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label1", "\u8fde\u63a5\u5230\u670d\u52a1\u5668\u65f6,\u53d1\u751f\u9519\u8bef:") + exception2.getMessage() + ".";
                    s_logger.info((Object)string, (Throwable)exception2);
                }
                if (string == null) {
                    try {
                        channelSftp = (ChannelSftp)session.openChannel("sftp");
                        channelSftp.connect();
                    }
                    catch (Exception exception3) {
                        string = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label2", "\u6253\u5f00SFTP\u901a\u9053\u65f6,\u53d1\u751f\u9519\u8bef:") + exception3.getMessage() + ".";
                        s_logger.info((Object)string, (Throwable)exception3);
                    }
                }
                if (string == null) {
                    try {
                        channelSftp.cd(ftpConfig.getRootPath());
                    }
                    catch (Exception exception4) {
                        string = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label3", "\u65e0\u6548\u7684\u7684\u76ee\u6807\u8def\u5f84,\u6ca1\u6709\u6743\u9650\u6216\u8005\u8def\u5f84\u4e0d\u5b58\u5728.");
                        s_logger.info((Object)string, (Throwable)exception4);
                    }
                }
                if (string == null) {
                    try {
                        string2 = this.getTempFileName(null);
                        channelSftp.mkdir(string2);
                        channelSftp.rmdir(string2);
                    }
                    catch (Exception exception5) {
                        string = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label4", "SFTP\u7528\u6237\u53ef\u80fd\u5bf9\u76ee\u6807\u670d\u52a1\u5668\u6216\u76ee\u6807\u8def\u5f84\u6ca1\u6709\u4e0a\u4f20\u7684\u6743\u9650.");
                        s_logger.info((Object)string, (Throwable)exception5);
                    }
                }
                Object var9_13 = null;
                if (channelSftp == null) break block28;
                try {
                    channelSftp.disconnect();
                }
                catch (Exception exception6222) {
                    // empty catch block
                }
            }
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (Exception exception6222) {}
            }
            break block30;
            {
                catch (Exception exception7) {
                    Exception exception82222;
                    string = I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label5", "\u9a8c\u8bc1SFTP\u914d\u7f6e\u65f6,\u53d1\u751f\u9519\u8bef:") + exception7.getMessage() + ".";
                    s_logger.info((Object)string, (Throwable)exception7);
                    Object var9_14 = null;
                    if (channelSftp != null) {
                        try {
                            channelSftp.disconnect();
                        }
                        catch (Exception exception82222) {
                            // empty catch block
                        }
                    }
                    if (session != null) {
                        try {
                            session.disconnect();
                        }
                        catch (Exception exception82222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception92222;
                Object var9_15 = null;
                if (channelSftp != null) {
                    try {
                        channelSftp.disconnect();
                    }
                    catch (Exception exception92222) {
                        // empty catch block
                    }
                }
                if (session != null) {
                    try {
                        session.disconnect();
                    }
                    catch (Exception exception92222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return string;
    }

    protected void open() throws Exception {
        if (this.m_oSftpChannel != null && this.m_oSftpChannel.isConnected()) {
            return;
        }
        try {
            FtpConfig ftpConfig = this.getFtpConfig();
            String string = ftpConfig.getUserName();
            String string2 = ftpConfig.getHost();
            int n = ftpConfig.getPort();
            this.m_oSftpSession = new JSch().getSession(string, string2, n);
            this.m_oSftpSession.setUserInfo((UserInfo)new MyUserInfo());
            this.m_oSftpSession.connect();
            this.m_oSftpChannel = (ChannelSftp)this.m_oSftpSession.openChannel("sftp");
            this.m_oSftpChannel.connect();
            this.m_sHomePath = this.m_oSftpChannel.pwd();
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label6", "SFTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25"), exception);
        }
    }

    protected void close() {
        if (this.m_oSftpChannel == null || !this.m_oSftpChannel.isConnected()) {
            return;
        }
        try {
            this.m_oSftpChannel.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_oSftpSession.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_oSftpChannel = null;
        this.m_oSftpSession = null;
        this.m_sHomePath = null;
    }

    private void assertOpen() throws WCMException {
        if (this.m_oSftpChannel != null && this.m_oSftpChannel.isConnected()) {
            return;
        }
        throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label7", "SFTP\u8fde\u63a5\u610f\u5916\u5730\u5173\u95ed\uff01"));
    }

    public void onIdle() throws Exception {
        this.assertOpen();
        this.m_oSftpChannel.pwd();
    }

    public boolean isReadOnly() throws Exception {
        this.assertOpen();
        try {
            this.m_oSftpChannel.cd(this.getFtpConfig().getRootPath());
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label3", "\u65e0\u6548\u7684\u7684\u76ee\u6807\u8def\u5f84,\u6ca1\u6709\u6743\u9650\u6216\u8005\u8def\u5f84\u4e0d\u5b58\u5728:") + exception + ".");
        }
        String string = this.getTempFileName(null);
        try {
            this.m_oSftpChannel.mkdir(string);
            this.m_oSftpChannel.rmdir(string);
            return false;
        }
        catch (Exception exception) {
            s_logger.info((Object)I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label8", "SFTP\u670d\u52a1\u5668\u4e0a\u521b\u5efa\u4e34\u65f6\u76ee\u5f55\u5931\u8d25"), (Throwable)exception);
            return true;
        }
    }

    private void insureDirectory(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.changeDirectory(string)) {
            return;
        }
        int n = string.lastIndexOf(47, string.length() - 2);
        if (n != -1) {
            String string2 = string.substring(0, n + 1);
            this.insureDirectory(string2);
            String string3 = string.substring(n + 1, string.length() - 1);
            this.createDirectory(string3);
            this.m_oSftpChannel.cd(string3);
        }
    }

    private boolean changeDirectory(String string) throws Exception {
        try {
            this.m_oSftpChannel.cd(string);
            return true;
        }
        catch (Exception exception) {
            s_logger.debug((Object)("enter directory '" + string + "' failed"), (Throwable)exception);
            return false;
        }
    }

    private boolean createDirectory(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return false;
        }
        try {
            this.m_oSftpChannel.mkdir(string);
            return true;
        }
        catch (Exception exception) {
            s_logger.debug((Object)("create directory '" + string + "' failed"), (Throwable)exception);
            return false;
        }
    }

    public String toAbsolutePath(String string) throws Exception {
        this.assertOpen();
        try {
            this.m_oSftpChannel.cd(string);
            return this.m_oSftpChannel.pwd();
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label9", "SFTP\u670d\u52a1\u5668\u83b7\u53d6\u7edd\u5bf9\u8def\u5f84\u5931\u8d25:") + string + ".", exception);
        }
    }

    public boolean uploadFile(String string, String string2) throws Exception {
        this.assertOpen();
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(0, n + 1);
        String string4 = string2.substring(n + 1);
        try {
            this.insureDirectory(string3);
            this.m_oSftpChannel.put(string, string4);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label10", "SFTP\u670d\u52a1\u5668\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25:") + string2 + ".", exception);
        }
        return true;
    }

    public boolean hasTheFile(String string) throws Exception {
        this.assertOpen();
        try {
            if (this.m_oSftpChannel.stat(string) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean deleteFile(String string) throws Exception {
        this.assertOpen();
        try {
            this.m_oSftpChannel.rm(string);
            return true;
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label11", "SFTP\u670d\u52a1\u5668\u5220\u9664\u6587\u4ef6\u5931\u8d25") + string + ".", exception);
        }
    }

    public boolean deleteDirectory(String string) throws Exception {
        this.assertOpen();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            this.m_oSftpChannel.rmdir(string);
            return true;
        }
        catch (Exception exception) {
            s_logger.info((Object)("remove directory '" + string + "' failed"), (Throwable)exception);
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            String string4 = this.getTempFileName(string3);
            StringBuffer stringBuffer = new StringBuffer(1024);
            stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label12", "\u5220\u9664\u76ee\u5f55["));
            stringBuffer.append(string);
            stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label13", "]\u5931\u8d25,\u5c1d\u8bd5\u5c06["));
            stringBuffer.append(string3);
            stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label14", "]\u91cd\u547d\u540d\u4e3a["));
            stringBuffer.append(string2);
            stringBuffer.append(string4);
            stringBuffer.append("],");
            try {
                this.m_oSftpChannel.cd(string2);
            }
            catch (Exception exception2) {
                return false;
            }
            try {
                this.m_oSftpChannel.rename(string3, string4);
                return true;
            }
            catch (Exception exception3) {
                stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label16", "\u76ee\u5f55\u91cd\u547d\u540d\u4e3a["));
                stringBuffer.append(string4);
                stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label17", "]\u5931\u8d25"));
                throw new WCMException(stringBuffer.toString(), exception3);
            }
        }
    }

    public boolean renameFile(String string, String string2) throws Exception {
        this.assertOpen();
        int n = string.lastIndexOf(47);
        String string3 = string.substring(0, n + 1);
        String string4 = string.substring(n + 1);
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label18", "\u5c1d\u8bd5\u5c06[")).append(string).append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label14", "]\u91cd\u547d\u540d\u4e3a["));
        stringBuffer.append(string3).append(string2).append("],");
        try {
            this.m_oSftpChannel.cd(string3);
        }
        catch (Exception exception) {
            stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label19", "\u8fdb\u5165\u76ee\u5f55[")).append(string3).append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label15", "]\u5931\u8d25:"));
            stringBuffer.append(exception.getMessage() + ".");
            throw new WCMException(1013, stringBuffer.toString());
        }
        try {
            this.m_oSftpChannel.rename(string4, string2);
            return true;
        }
        catch (Exception exception) {
            stringBuffer.append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label20", "\u91cd\u547d\u540d\u4e3a[")).append(string2).append(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label15", "]\u5931\u8d25:"));
            stringBuffer.append(exception.getMessage() + ".");
            throw new WCMException(stringBuffer.toString(), exception);
        }
    }

    protected void toHomeDirectory() throws Exception {
        this.assertOpen();
        if (this.m_sHomePath == null) {
            return;
        }
        try {
            this.m_oSftpChannel.cd(this.m_sHomePath);
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label21", "\u6062\u590d\u521d\u59cb\u76ee\u5f55[") + this.m_sHomePath + I18NMessage.get(FtpConnectionImpSSH.class, "FtpConnectionImpSSH.label17", "]\u5931\u8d25"), exception);
        }
    }

    public static void main(String[] stringArray) {
        FtpConfig ftpConfig = new FtpConfig();
        ftpConfig.setProtocol("SFTP");
        ftpConfig.setHost("192.9.200.215");
        ftpConfig.setPort(22);
        ftpConfig.setUserName("martin");
        ftpConfig.setPassWord("trsadmin");
        ftpConfig.setRootPath("/opt/");
        ftpConfig.setPassive(false);
        ftpConfig.setMaxClient(10);
        FtpConnectionImpSSH ftpConnectionImpSSH = new FtpConnectionImpSSH();
        ftpConnectionImpSSH.setConfig(ftpConfig);
        System.out.println(ftpConnectionImpSSH.verifyConfig());
    }

    private class MyUserInfo
    implements UserInfo {
        public String getPassword() {
            return FtpConnectionImpSSH.this.getFtpConfig().getPassWord();
        }

        public boolean promptYesNo(String string) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public void showMessage(String string) {
            s_logger.info((Object)string);
        }
    }
}

