/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.uftp.ChainList;
import com.trs.infra.util.uftp.FtpConfig;
import com.trs.infra.util.uftp.FtpConnection;
import com.trs.infra.util.uftp.FtpConnectionImpFtp;
import com.trs.infra.util.uftp.FtpConnectionImpSSH;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class FtpConnectionCache
implements IClearable {
    private static Logger s_logger = Logger.getLogger(FtpConnectionCache.class);
    private static final int UPLOAD_RETRY_TIMES = 6;
    private boolean m_zRuning = false;
    private boolean m_zStoped = false;
    private Keeper m_oKeeper = null;
    private Object m_objectSync;
    private ChainList m_oQueueBusy;
    private ChainList m_oQueueIdle;
    private Vector m_oVectorAll;
    private FtpConfig m_oFtpConfig;
    private HashMap m_oUploading;

    public static final boolean verifyConfig(FtpConfig ftpConfig, String[] stringArray) {
        if (ftpConfig == null) {
            throw new IllegalArgumentException("Argument 'FtpConfig' is null.");
        }
        if (stringArray == null || stringArray.length < 1) {
            throw new IllegalArgumentException("Argument 'String[]' is null.");
        }
        try {
            FtpConnection ftpConnection = FtpConnectionCache.createConnection(ftpConfig.getProtocol());
            ftpConnection.setConfig(ftpConfig);
            stringArray[0] = ftpConnection.verifyConfig();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringArray[0] = I18NMessage.get(FtpConnectionCache.class, "FtpConnectionCache.label1", "\u4e0d\u652f\u6301\u7684\u7f51\u7edc\u534f\u8bae");
        }
        return stringArray[0] == null;
    }

    private static final FtpConnection createConnection(String string) {
        if ("FTP".equals(string)) {
            return new FtpConnectionImpFtp();
        }
        if ("FTPS".equals(string)) {
            // empty if block
        }
        if ("SFTP".equals(string)) {
            return new FtpConnectionImpSSH();
        }
        if ("GFTP".equals(string)) {
            // empty if block
        }
        throw new IllegalArgumentException("Not supported protocol:" + string);
    }

    public FtpConnectionCache(FtpConfig ftpConfig) {
        this.m_oFtpConfig = ftpConfig;
        this.m_objectSync = new Object();
        this.m_oQueueBusy = new ChainList();
        this.m_oQueueIdle = new ChainList();
        this.m_oVectorAll = new Vector();
        this.m_oUploading = new HashMap();
    }

    public FtpConfig getFtpConfig() {
        return this.m_oFtpConfig;
    }

    public void initialize() {
        if (this.m_oKeeper != null) {
            return;
        }
        this.m_oKeeper = new Keeper();
        this.m_oKeeper.start();
        this.m_zRuning = true;
    }

    public void clear() {
        if (this.m_oKeeper == null) {
            return;
        }
        this.m_oKeeper.terminate();
        this.m_oKeeper = null;
        this.m_zRuning = false;
        this.m_zStoped = true;
        for (int i = this.m_oVectorAll.size() - 1; i >= 0; --i) {
            try {
                this.destroyConnection((FtpConnection)this.m_oVectorAll.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_oUploading.clear();
    }

    private FtpConnection assignConnection() throws Exception {
        if (this.m_zStoped) {
            throw new IllegalStateException("FtpConnectionCache closed.");
        }
        FtpConnection ftpConnection = (FtpConnection)this.m_oQueueIdle.get();
        if (ftpConnection != null) {
            this.m_oQueueBusy.put(ftpConnection);
            return ftpConnection;
        }
        while (this.getTotalCount() < this.getLimitCount()) {
            this.createConnection();
            ftpConnection = (FtpConnection)this.m_oQueueIdle.get();
            if (ftpConnection == null) continue;
            this.m_oQueueBusy.put(ftpConnection);
            return ftpConnection;
        }
        for (int i = 0; i < 100; ++i) {
            ftpConnection = (FtpConnection)this.m_oQueueIdle.get();
            if (ftpConnection != null) {
                this.m_oQueueBusy.put(ftpConnection);
                return ftpConnection;
            }
            this.waitforConnection();
        }
        throw new IllegalStateException("Too bufy, no idle connection.");
    }

    private void recycleConnection(FtpConnection ftpConnection) {
        if (this.m_zRuning) {
            try {
                ftpConnection.toHomeDirectory();
                ftpConnection.cutFromList();
                ftpConnection.setIdleTimestamp();
                this.m_oQueueIdle.put(ftpConnection);
                this.notifyConnection();
                return;
            }
            catch (Exception exception) {
                s_logger.info((Object)"FtpConnectionCache.recycleConnection():toHomeDirectory():error", (Throwable)exception);
            }
        }
        this.destroyConnection(ftpConnection);
    }

    private void createConnection() throws Exception {
        FtpConnection ftpConnection = FtpConnectionCache.createConnection(this.m_oFtpConfig.getProtocol());
        ftpConnection.setConfig(this.m_oFtpConfig);
        ftpConnection.open();
        this.m_oVectorAll.addElement(ftpConnection);
        this.m_oQueueIdle.put(ftpConnection);
        this.notifyConnection();
    }

    private void destroyConnection(FtpConnection ftpConnection) {
        if (ftpConnection == null) {
            return;
        }
        try {
            ftpConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ftpConnection.setConfig(null);
        ftpConnection.cutFromList();
        this.m_oVectorAll.removeElement(ftpConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnection() {
        Object object = this.m_objectSync;
        synchronized (object) {
            try {
                this.m_objectSync.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitforConnection() {
        Object object = this.m_objectSync;
        synchronized (object) {
            try {
                this.m_objectSync.wait(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean verifyConnection(FtpConnection ftpConnection) {
        block6: {
            if (ftpConnection == null) {
                return false;
            }
            if (ftpConnection.getIdleTimemills() < this.m_oFtpConfig.getMaxIdleMills()) {
                try {
                    ftpConnection.onIdle();
                    return true;
                }
                catch (Exception exception) {
                    if (!s_logger.isDebugEnabled()) break block6;
                    try {
                        FtpConfig ftpConfig = ftpConnection.getFtpConfig();
                        s_logger.info((Object)"onIdle():error");
                        s_logger.info((Object)("FTPInfo:" + ftpConfig));
                        s_logger.info((Object)"exception:", (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        this.destroyConnection(ftpConnection);
        return false;
    }

    public FtpConnection getConnectionWrapper() {
        return new Wrapper();
    }

    public int getBusyCount() {
        return this.m_oQueueBusy.size();
    }

    public int getIdleCount() {
        return this.m_oQueueIdle.size();
    }

    public int getLimitCount() {
        return this.m_oFtpConfig.getMaxClient();
    }

    public int getTotalCount() {
        return this.m_oVectorAll.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("FtpConnectionCache ");
        stringBuffer.append('(');
        stringBuffer.append(this.m_oFtpConfig);
        stringBuffer.append(')');
        stringBuffer.append(", idle=");
        stringBuffer.append(this.m_oQueueIdle.size());
        stringBuffer.append(", busy=");
        stringBuffer.append(this.m_oQueueBusy.size());
        stringBuffer.append(", total=");
        stringBuffer.append(this.m_oVectorAll.size());
        stringBuffer.append(", max=");
        stringBuffer.append(this.m_oFtpConfig.getMaxClient());
        return stringBuffer.toString();
    }

    private synchronized boolean testAndRegister(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_oUploading.get(string) != null) {
            return false;
        }
        this.m_oUploading.put(string, string);
        return true;
    }

    private synchronized void unregister(String string) {
        if (string == null) {
            return;
        }
        this.m_oUploading.remove(string);
    }

    private class Wrapper
    extends FtpConnection {
        private Wrapper() {
        }

        protected String verifyConfig() {
            return null;
        }

        protected void open() throws Exception {
        }

        protected void close() {
        }

        protected void toHomeDirectory() throws Exception {
        }

        public void onIdle() throws Exception {
        }

        public FtpConfig getFtpConfig() {
            return FtpConnectionCache.this.m_oFtpConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isReadOnly() throws Exception {
            Exception exception;
            boolean bl;
            block7: {
                FtpConnection ftpConnection;
                block8: {
                    bl = false;
                    exception = null;
                    ftpConnection = null;
                    try {
                        try {
                            ftpConnection = FtpConnectionCache.this.assignConnection();
                            bl = ftpConnection.isReadOnly();
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            s_logger.error((Object)"FtpConnectionCache.Wrapper():isReadOnly():error", (Throwable)exception2);
                            Object var6_5 = null;
                            if (ftpConnection == null) break block7;
                            if (exception != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConnection);
                                break block7;
                            } else {
                                FtpConnectionCache.this.recycleConnection(ftpConnection);
                            }
                            break block7;
                        }
                        Object var6_4 = null;
                        if (ftpConnection == null) break block7;
                        if (exception == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (ftpConnection == null) throw throwable;
                        if (exception != null) {
                            FtpConnectionCache.this.destroyConnection(ftpConnection);
                            throw throwable;
                        }
                        FtpConnectionCache.this.recycleConnection(ftpConnection);
                        throw throwable;
                    }
                    FtpConnectionCache.this.destroyConnection(ftpConnection);
                    break block7;
                }
                FtpConnectionCache.this.recycleConnection(ftpConnection);
            }
            if (exception == null) return bl;
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean deleteDirectory(String string) throws Exception {
            Exception exception;
            boolean bl;
            block7: {
                FtpConnection ftpConnection;
                block8: {
                    bl = false;
                    exception = null;
                    ftpConnection = null;
                    try {
                        try {
                            ftpConnection = FtpConnectionCache.this.assignConnection();
                            bl = ftpConnection.deleteDirectory(string);
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            s_logger.error((Object)"FtpConnectionCache.Wrapper():deleteDirectory():error", (Throwable)exception2);
                            Object var7_6 = null;
                            if (ftpConnection == null) break block7;
                            if (exception != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConnection);
                                break block7;
                            } else {
                                FtpConnectionCache.this.recycleConnection(ftpConnection);
                            }
                            break block7;
                        }
                        Object var7_5 = null;
                        if (ftpConnection == null) break block7;
                        if (exception == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (ftpConnection == null) throw throwable;
                        if (exception != null) {
                            FtpConnectionCache.this.destroyConnection(ftpConnection);
                            throw throwable;
                        }
                        FtpConnectionCache.this.recycleConnection(ftpConnection);
                        throw throwable;
                    }
                    FtpConnectionCache.this.destroyConnection(ftpConnection);
                    break block7;
                }
                FtpConnectionCache.this.recycleConnection(ftpConnection);
            }
            if (exception == null) return bl;
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean deleteFile(String string) throws Exception {
            Exception exception;
            boolean bl;
            block7: {
                FtpConnection ftpConnection;
                block8: {
                    bl = false;
                    exception = null;
                    ftpConnection = null;
                    try {
                        try {
                            ftpConnection = FtpConnectionCache.this.assignConnection();
                            bl = ftpConnection.deleteFile(string);
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            s_logger.error((Object)"FtpConnectionCache.Wrapper():deleteFile():error", (Throwable)exception2);
                            Object var7_6 = null;
                            if (ftpConnection == null) break block7;
                            if (exception != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConnection);
                                break block7;
                            } else {
                                FtpConnectionCache.this.recycleConnection(ftpConnection);
                            }
                            break block7;
                        }
                        Object var7_5 = null;
                        if (ftpConnection == null) break block7;
                        if (exception == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (ftpConnection == null) throw throwable;
                        if (exception != null) {
                            FtpConnectionCache.this.destroyConnection(ftpConnection);
                            throw throwable;
                        }
                        FtpConnectionCache.this.recycleConnection(ftpConnection);
                        throw throwable;
                    }
                    FtpConnectionCache.this.destroyConnection(ftpConnection);
                    break block7;
                }
                FtpConnectionCache.this.recycleConnection(ftpConnection);
            }
            if (exception == null) return bl;
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean renameFile(String string, String string2) throws Exception {
            Exception exception;
            boolean bl;
            block7: {
                FtpConnection ftpConnection;
                block8: {
                    bl = false;
                    exception = null;
                    ftpConnection = null;
                    try {
                        try {
                            ftpConnection = FtpConnectionCache.this.assignConnection();
                            bl = ftpConnection.renameFile(string, string2);
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            s_logger.error((Object)"FtpConnectionCache.Wrapper():deleteFile():error", (Throwable)exception2);
                            Object var8_7 = null;
                            if (ftpConnection == null) break block7;
                            if (exception != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConnection);
                                break block7;
                            } else {
                                FtpConnectionCache.this.recycleConnection(ftpConnection);
                            }
                            break block7;
                        }
                        Object var8_6 = null;
                        if (ftpConnection == null) break block7;
                        if (exception == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (ftpConnection == null) throw throwable;
                        if (exception != null) {
                            FtpConnectionCache.this.destroyConnection(ftpConnection);
                            throw throwable;
                        }
                        FtpConnectionCache.this.recycleConnection(ftpConnection);
                        throw throwable;
                    }
                    FtpConnectionCache.this.destroyConnection(ftpConnection);
                    break block7;
                }
                FtpConnectionCache.this.recycleConnection(ftpConnection);
            }
            if (exception == null) return bl;
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toAbsolutePath(String string) throws Exception {
            Exception exception;
            String string2;
            block7: {
                FtpConnection ftpConnection;
                block8: {
                    string2 = null;
                    exception = null;
                    ftpConnection = null;
                    try {
                        try {
                            ftpConnection = FtpConnectionCache.this.assignConnection();
                            string2 = ftpConnection.toAbsolutePath(string);
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            s_logger.error((Object)"FtpConnectionCache.Wrapper():toAbsolutePath():error", (Throwable)exception2);
                            Object var7_6 = null;
                            if (ftpConnection == null) break block7;
                            if (exception != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConnection);
                                break block7;
                            } else {
                                FtpConnectionCache.this.recycleConnection(ftpConnection);
                            }
                            break block7;
                        }
                        Object var7_5 = null;
                        if (ftpConnection == null) break block7;
                        if (exception == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (ftpConnection == null) throw throwable;
                        if (exception != null) {
                            FtpConnectionCache.this.destroyConnection(ftpConnection);
                            throw throwable;
                        }
                        FtpConnectionCache.this.recycleConnection(ftpConnection);
                        throw throwable;
                    }
                    FtpConnectionCache.this.destroyConnection(ftpConnection);
                    break block7;
                }
                FtpConnectionCache.this.recycleConnection(ftpConnection);
            }
            if (exception == null) return string2;
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean uploadFile(String string, String string2) throws Exception {
            if (!FtpConnectionCache.this.testAndRegister(string2)) {
                return true;
            }
            boolean bl = false;
            Exception exception = null;
            FtpConnection ftpConnection = null;
            try {
                for (int i = 0; i <= 6; ++i) {
                    block14: {
                        Object var9_10;
                        if (i > 0) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        try {
                            block13: {
                                try {
                                    exception = null;
                                    ftpConnection = FtpConnectionCache.this.assignConnection();
                                    bl = ftpConnection.uploadFile(string, string2);
                                    if (!bl) break block13;
                                    i = 7;
                                }
                                catch (Exception exception3) {
                                    exception = exception3;
                                    s_logger.error((Object)"FtpConnectionCache.Wrapper():uploadFile():error", (Throwable)exception3);
                                    var9_10 = null;
                                    if (ftpConnection == null) continue;
                                    if (exception != null) {
                                        FtpConnectionCache.this.destroyConnection(ftpConnection);
                                        continue;
                                    }
                                    FtpConnectionCache.this.recycleConnection(ftpConnection);
                                    continue;
                                }
                            }
                            var9_10 = null;
                            if (ftpConnection == null) continue;
                            if (exception == null) break block14;
                        }
                        catch (Throwable throwable) {
                            var9_10 = null;
                            if (ftpConnection == null) throw throwable;
                            if (exception != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConnection);
                                throw throwable;
                            }
                            FtpConnectionCache.this.recycleConnection(ftpConnection);
                            throw throwable;
                        }
                        FtpConnectionCache.this.destroyConnection(ftpConnection);
                        continue;
                    }
                    FtpConnectionCache.this.recycleConnection(ftpConnection);
                }
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                FtpConnectionCache.this.unregister(string2);
                throw throwable;
            }
            FtpConnectionCache.this.unregister(string2);
            if (exception == null) return bl;
            throw exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean hasTheFile(String string) throws Exception {
            Exception exception;
            boolean bl;
            block7: {
                FtpConnection ftpConnection;
                block8: {
                    bl = false;
                    exception = null;
                    ftpConnection = null;
                    try {
                        try {
                            ftpConnection = FtpConnectionCache.this.assignConnection();
                            bl = ftpConnection.hasTheFile(string);
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            s_logger.error((Object)"FtpConnectionCache.Wrapper():hasTheFile():error", (Throwable)exception2);
                            Object var7_6 = null;
                            if (ftpConnection == null) break block7;
                            if (exception != null) {
                                FtpConnectionCache.this.destroyConnection(ftpConnection);
                                break block7;
                            } else {
                                FtpConnectionCache.this.recycleConnection(ftpConnection);
                            }
                            break block7;
                        }
                        Object var7_5 = null;
                        if (ftpConnection == null) break block7;
                        if (exception == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (ftpConnection == null) throw throwable;
                        if (exception != null) {
                            FtpConnectionCache.this.destroyConnection(ftpConnection);
                            throw throwable;
                        }
                        FtpConnectionCache.this.recycleConnection(ftpConnection);
                        throw throwable;
                    }
                    FtpConnectionCache.this.destroyConnection(ftpConnection);
                    break block7;
                }
                FtpConnectionCache.this.recycleConnection(ftpConnection);
            }
            if (exception == null) return bl;
            throw exception;
        }
    }

    private class Keeper
    extends Thread {
        private boolean m_zContinue;

        public Keeper() {
            super("FtpConnectionCache$Keeper");
            this.m_zContinue = true;
            this.setDaemon(true);
        }

        public void run() {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"FtpConnectionCache.Keeper():start");
            }
            while (this.m_zContinue) {
                FtpConnection ftpConnection;
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception exception) {
                    s_logger.error((Object)"FtpConnectionCache.Keeper():Thread.sleep():error", (Throwable)exception);
                }
                if (!this.m_zContinue) break;
                for (int i = FtpConnectionCache.this.m_oQueueIdle.size(); i > 0 && (ftpConnection = (FtpConnection)FtpConnectionCache.this.m_oQueueIdle.get()) != null && this.m_zContinue; --i) {
                    if (!FtpConnectionCache.this.verifyConnection(ftpConnection)) continue;
                    FtpConnectionCache.this.m_oQueueIdle.put(ftpConnection);
                }
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"FtpConnectionCache.Keeper():terminate");
            }
        }

        void terminate() {
            this.m_zContinue = false;
        }
    }
}

