/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

public class FtpConfig {
    private String m_sProtocol;
    private boolean m_zAnonymous;
    private String m_sUserName;
    private String m_sPassWord;
    private String m_sHost;
    private int m_iPort;
    private String m_sRootPath;
    private boolean m_zPassive;
    private int m_iMaxClient;
    private long m_lMaxIdleMills = 300000L;

    public String getProtocol() {
        return this.m_sProtocol;
    }

    public void setProtocol(String string) {
        this.m_sProtocol = string.toUpperCase();
        if (this.m_iPort <= 0) {
            if ("FTP".equals(string)) {
                this.m_iPort = 21;
            } else if ("FTPS".equals(string)) {
                this.m_iPort = 990;
            } else if ("SFTP".equals(string)) {
                this.m_iPort = 22;
            } else if ("GFTP".equals(string)) {
                this.m_iPort = 2021;
            }
        }
    }

    public boolean getAnonymous() {
        return this.m_zAnonymous;
    }

    public void setAnonymous(boolean bl) {
        this.m_zAnonymous = bl;
    }

    public String getUserName() {
        if (this.m_zAnonymous) {
            return "anonymous";
        }
        return this.m_sUserName;
    }

    public void setUserName(String string) {
        this.m_sUserName = string;
    }

    public String getPassWord() {
        if (this.m_zAnonymous) {
            return "anonymous@anonymous.com";
        }
        return this.m_sPassWord;
    }

    public void setPassWord(String string) {
        this.m_sPassWord = string;
    }

    public String getHost() {
        return this.m_sHost;
    }

    public void setHost(String string) {
        this.m_sHost = string;
    }

    public int getPort() {
        return this.m_iPort;
    }

    public void setPort(int n) {
        if (n > 0) {
            this.m_iPort = n;
        }
    }

    public String getRootPath() {
        return this.m_sRootPath;
    }

    public void setRootPath(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.m_sRootPath = string;
    }

    public boolean getPassive() {
        return this.m_zPassive;
    }

    public void setPassive(boolean bl) {
        this.m_zPassive = bl;
    }

    public int getMaxClient() {
        return this.m_iMaxClient;
    }

    public void setMaxClient(int n) {
        this.m_iMaxClient = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.m_sProtocol);
        stringBuffer.append("://");
        stringBuffer.append(this.m_sHost);
        stringBuffer.append(":");
        stringBuffer.append(this.m_iPort);
        if (this.m_sRootPath == null || this.m_sRootPath.length() <= 0) {
            stringBuffer.append('/');
        } else {
            if (this.m_sRootPath.charAt(0) != '/') {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.m_sRootPath);
        }
        return stringBuffer.toString();
    }

    public void setMaxIdleTime(int n) {
        this.m_lMaxIdleMills = (long)n * 1000L;
    }

    public long getMaxIdleMills() {
        return this.m_lMaxIdleMills;
    }
}

