/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.soap;

import com.trs.infra.I18NMessage;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;

public class CMySoapClient {
    private static Logger m_oLogger = Logger.getLogger(CMySoapClient.class);
    String m_sHost = "http://127.0.0.1:8000";
    String m_sUserName;
    String m_sPassword;
    String m_sURN = "urn:SoapExample";
    URL m_objURL = null;
    Service m_objService = null;
    boolean m_bKeepAlive = false;

    public CMySoapClient() {
        try {
            this.m_objService = new Service();
        }
        catch (Exception exception) {
            m_oLogger.error((Object)I18NMessage.get(CMySoapClient.class, "CMySoapClient.label1", "\u521b\u5efaService\u5931\u8d25\uff01"), (Throwable)exception);
        }
    }

    public void setServer(String string, String string2, String string3) {
        this.m_sHost = string;
        this.m_sUserName = string2;
        this.m_sPassword = string3;
        try {
            this.m_objURL = new URL(this.m_sHost);
        }
        catch (Exception exception) {
            m_oLogger.error((Object)I18NMessage.get(CMySoapClient.class, "CMySoapClient.label2", "\u521d\u59cb\u5316URL\u5931\u8d25\uff01"), (Throwable)exception);
        }
    }

    public void setKeepAlive(boolean bl) {
        this.m_bKeepAlive = bl;
    }

    public void setUrn(String string) {
        this.m_sURN = string;
    }

    public String getHost() {
        return this.m_objURL.getHost();
    }

    public int getPort() {
        return this.m_objURL.getPort();
    }

    public String getUserName() {
        return this.m_sUserName;
    }

    public String getPassWord() {
        return this.m_sPassword;
    }

    public String getUrn() {
        return this.m_sURN;
    }

    void setCommonCallProperty(Call call) {
        call.setTargetEndpointAddress(this.m_objURL);
        call.setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V11);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(HTTPConstants.HEADER_TRANSFER_ENCODING, HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED);
        if (this.m_bKeepAlive) {
            hashtable.put("Connection", HTTPConstants.HEADER_CONNECTION_KEEPALIVE);
        } else {
            hashtable.put("Connection", HTTPConstants.HEADER_CONNECTION_CLOSE);
        }
        call.setProperty("HTTP-Request-Headers", hashtable);
        call.setUsername(this.m_sUserName);
        call.setPassword(this.m_sPassword);
    }

    synchronized Object remoteCall(Call call, Object[] objectArray) throws RemoteException {
        Object object = null;
        object = call.invoke(objectArray);
        return object;
    }

    Call getCall() throws ServiceException {
        Call call = null;
        call = (Call)this.m_objService.createCall();
        this.setCommonCallProperty(call);
        return call;
    }
}

