/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.key;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MacAddressHelper {
    public static final boolean IS_DEBUG = false;

    public static boolean isValidMac(long l) {
        if (l == Long.parseLong("123456789012")) {
            return true;
        }
        int n = 10;
        for (int i = 0; i < n; ++i) {
            if (MacAddressHelper.getMyMacAsLong(i) != l) continue;
            return true;
        }
        return false;
    }

    public static long getMyMacAsLong(int n) {
        String string = MacAddressHelper.getMyMac(n);
        return MacAddressHelper.getMyMacAsLong(string);
    }

    public static long getMyMacAsLong() {
        return MacAddressHelper.getMyMacAsLong(0);
    }

    public static long getMyMacAsLong(String string) {
        if (string == null || string.length() <= 0) {
            return 0L;
        }
        String string2 = string;
        string2 = CMyString.replaceStr(string2, "-", "");
        long l = Long.parseLong(string2, 16);
        string2 = "" + l;
        if (string2.length() > 12) {
            string2 = string2.substring(0, 12);
            while (string2.charAt(0) == '0' && string2.length() > 0) {
                string2 = string2.substring(1, string2.length());
            }
            l = Long.parseLong(string2);
        }
        return l;
    }

    private static String getMacOnWindow(int n) {
        String string = "";
        try {
            String string2 = "ipconfig /all";
            Process process = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine();
            int n2 = 0;
            while (string3 != null) {
                String string4 = bufferedReader.readLine();
                if (string3.indexOf("Physical Address") != -1 || string3.indexOf(I18NMessage.get(MacAddressHelper.class, "MacAddressHelper.label1", "\u7269\u7406\u5730\u5740")) != -1) {
                    if (n2 == n) {
                        string = string3.split(":")[1].trim();
                        break;
                    }
                    ++n2;
                }
                string3 = string4;
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            string = "";
        }
        return string.trim();
    }

    private static String getMacOnLinux(int n) {
        String string = "";
        try {
            String string2 = "/sbin/ifconfig -a";
            Process process = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine().toUpperCase();
            int n2 = 0;
            while (string3 != null) {
                String string4 = bufferedReader.readLine();
                if (string3.indexOf("HWADDR") > 0) {
                    if (n2 == n) {
                        int n3 = string3.indexOf("HWADDR") + 7;
                        string = string3.substring(n3);
                        break;
                    }
                    ++n2;
                }
                string3 = string4.toUpperCase();
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            string = "";
        }
        return string.trim().replace(':', '-');
    }

    private static String getMacOnHP(int n) {
        String string = "";
        try {
            String string2 = "/usr/sbin/lanscan";
            Process process = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine().toUpperCase();
            int n2 = 0;
            while (string3 != null) {
                String string4 = bufferedReader.readLine();
                int n3 = string3.indexOf("0X");
                if (n3 > 0) {
                    if (n2 == n) {
                        int n4 = n3 + 2;
                        int n5 = string3.indexOf(" ", n4);
                        string = string3.substring(n4, n5);
                        break;
                    }
                    ++n2;
                }
                string3 = string4.toUpperCase();
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            string = "";
        }
        return string.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMacOnSolaris(int n) {
        String string = "";
        Process process = null;
        try {
            try {
                String string2 = "/usr/sbin/ifconfig -a";
                process = Runtime.getRuntime().exec(string2);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string3 = bufferedReader.readLine().toUpperCase();
                int n2 = 0;
                while (string3 != null) {
                    String string4 = bufferedReader.readLine().toUpperCase();
                    if (string3.indexOf("NEI0") > 0) {
                        int n3;
                        int n4 = string4.indexOf("INET") + 5;
                        if (n4 < 5 || (n3 = string4.indexOf(" ", n4)) <= n4) break;
                        if (n2 == n) {
                            string = string4.substring(n4, n3);
                            break;
                        }
                        ++n2;
                    }
                    string3 = string4;
                }
                bufferedReader.close();
                process.waitFor();
            }
            catch (Exception exception) {
                Object var11_12 = null;
                if (process != null) {
                    process.destroy();
                }
            }
            Object var11_11 = null;
            if (process != null) {
                process.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (process != null) {
                process.destroy();
            }
            throw throwable;
        }
        if (string == null || string.length() <= 8) {
            string = MacAddressHelper.getMacOnSolaris2(n);
        }
        if (string == null || string.length() < 8) {
            return MacAddressHelper.getMacOnSolaris3();
        }
        return CMyString.replaceStr(string, ".", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getMacOnSolaris3() {
        String string = "";
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec("netstat -pn");
                InputStream inputStream = process.getInputStream();
                final InputStream inputStream2 = process.getErrorStream();
                final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            int n = 0;
                            while ((n = inputStream2.read()) != -1) {
                                byteArrayOutputStream.write(n);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
                int n = 0;
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                thread.join();
                string = new String(byteArrayOutputStream.toByteArray());
                int n2 = string.indexOf("SP");
                if (n2 == -1) {
                    Object var10_11 = null;
                    if (process == null) return string;
                    process.destroy();
                    return string;
                }
                string = string.substring(n2 + 2);
                while (true) {
                    if (!string.startsWith(" ")) {
                        string = string.substring(0, 17);
                        String string2 = string.replaceAll(":", "");
                        Object var10_10 = null;
                        if (process == null) return string2;
                        process.destroy();
                        return string2;
                    }
                    string = string.substring(1);
                }
            }
            catch (Exception exception) {
                Object var10_12 = null;
                if (process == null) return string;
                process.destroy();
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (process == null) throw throwable;
            process.destroy();
            throw throwable;
        }
    }

    private static String getMacOnSolaris2(int n) {
        String string = "";
        try {
            String string2 = "/usr/sbin/ifconfig -a";
            Process process = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine().toUpperCase();
            int n2 = 0;
            while (string3 != null) {
                int n3 = (string3 = string3.toUpperCase()).indexOf("ETHER");
                if (n3 >= 0) {
                    if (n2 == n) {
                        int n4 = string3.indexOf(" ", n3 += 6);
                        if (n4 <= 0) {
                            n4 = string3.length();
                        }
                        string = string3.substring(n3, n4).trim();
                        break;
                    }
                    ++n2;
                }
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            System.out.println(I18NMessage.get(MacAddressHelper.class, "MacAddressHelper.label2", "\u83b7\u53d6Sun Solaris\u64cd\u4f5c\u7cfb\u7edf\u7684Mac\u5730\u5740\u5931\u8d25\uff01(getMacOnSolaris2)"));
            exception.printStackTrace();
        }
        string = CMyString.replaceStr(string, ".", "");
        string = CMyString.replaceStr(string, ":", "");
        return string;
    }

    private static String getMacOnAIX(int n) {
        String string = "";
        try {
            String string2;
            String string3 = "/usr/bin/uname -m";
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = string2 = bufferedReader.readLine().toUpperCase();
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            string = "";
        }
        return string.trim();
    }

    public static String getMyMac(int n) {
        String string = System.getProperty("os.name", "");
        if (CMyString.isEmpty(string)) {
            string = (String)System.getProperties().get("os.name");
        }
        if (CMyString.isEmpty(string)) {
            System.out.println("Can't obatain the os name at runtime!");
            System.out.println("So can't mark the machine.");
            return "";
        }
        if ((string = string.toUpperCase()).indexOf("WINDOWS") >= 0) {
            return MacAddressHelper.getMacOnWindow(n);
        }
        if (string.indexOf("HP") >= 0) {
            return MacAddressHelper.getMacOnHP(n);
        }
        if (string.indexOf("LINUX") >= 0) {
            return MacAddressHelper.getMacOnLinux(n);
        }
        if (string.indexOf("SOLARIS") >= 0 || string.indexOf("SUNOS") >= 0) {
            return MacAddressHelper.getMacOnSolaris(n);
        }
        if (string.indexOf("AIX") >= 0) {
            return MacAddressHelper.getMacOnAIX(n);
        }
        if (string.indexOf("FREEBSD") != -1) {
            return MacAddressHelper.getMacOnFreeBSD(n);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getMacOnFreeBSD(int n) {
        String string;
        block31: {
            Exception exception2222;
            BufferedReader bufferedReader;
            InputStreamReader inputStreamReader;
            InputStream inputStream;
            block27: {
                inputStream = null;
                inputStreamReader = null;
                bufferedReader = null;
                string = "";
                String string2 = "/sbin/ifconfig -a";
                Process process = Runtime.getRuntime().exec(string2);
                inputStream = process.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                int n2 = 0;
                while (string3 != null) {
                    if ((string3 = string3.toUpperCase()).indexOf("ETHER") != -1) {
                        if (n2 == n) {
                            string = string3.trim().split(" ")[1];
                            break;
                        }
                        ++n2;
                    }
                    string3 = bufferedReader.readLine();
                }
                process.waitFor();
                Object var10_10 = null;
                if (inputStream == null) break block27;
                try {
                    inputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2222) {}
            }
            break block31;
            {
                catch (Exception exception3) {
                    Exception exception42222;
                    Object var10_11 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception42222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var10_12 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return string.trim().replace(':', '-');
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(MacAddressHelper.getMyMacAsLong(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

