/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.CRC32;
import com.trs.infra.util.jazzlib.Deflater;
import com.trs.infra.util.jazzlib.DeflaterOutputStream;
import com.trs.infra.util.jazzlib.ZipConstants;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private Vector entries = new Vector();
    private CRC32 crc = new CRC32();
    private ZipEntry curEntry = null;
    private int curMethod;
    private int size;
    private int offset = 0;
    private byte[] zipComment = new byte[0];
    private int defaultMethod = 8;
    private String encoding = null;
    private static final int ZIP_STORED_VERSION = 10;
    private static final int ZIP_DEFLATED_VERSION = 20;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream, new Deflater(-1, true));
    }

    public void setComment(String string) {
        byte[] byArray;
        try {
            byArray = this.encoding == null ? string.getBytes() : string.getBytes(this.encoding);
        }
        catch (Exception exception) {
            throw new InternalError("failed to get bytes");
        }
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("Comment too long.");
        }
        this.zipComment = byArray;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("Method not supported.");
        }
        this.defaultMethod = n;
    }

    public void setLevel(int n) {
        this.def.setLevel(n);
    }

    private final void writeLeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    private final void writeLeInt(int n) throws IOException {
        this.writeLeShort(n);
        this.writeLeShort(n >> 16);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        byte[] byArray;
        if (this.entries == null) {
            throw new IllegalStateException("ZipOutputStream was finished");
        }
        int n = zipEntry.getMethod();
        int n2 = 0;
        if (n == -1) {
            n = this.defaultMethod;
        }
        if (n == 0) {
            if (zipEntry.getCompressedSize() >= 0L) {
                if (zipEntry.getSize() < 0L) {
                    zipEntry.setSize(zipEntry.getCompressedSize());
                } else if (zipEntry.getSize() != zipEntry.getCompressedSize()) {
                    throw new ZipException("Method STORED, but compressed size != size");
                }
            } else {
                zipEntry.setCompressedSize(zipEntry.getSize());
            }
            if (zipEntry.getSize() < 0L) {
                throw new ZipException("Method STORED, but size not set");
            }
            if (zipEntry.getCrc() < 0L) {
                throw new ZipException("Method STORED, but crc not set");
            }
        } else if (n == 8 && (zipEntry.getCompressedSize() < 0L || zipEntry.getSize() < 0L || zipEntry.getCrc() < 0L)) {
            n2 |= 8;
        }
        if (this.curEntry != null) {
            this.closeEntry();
        }
        if (zipEntry.getTime() < 0L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        zipEntry.flags = n2;
        zipEntry.offset = this.offset;
        zipEntry.setMethod(n);
        this.curMethod = n;
        this.writeLeInt(67324752);
        this.writeLeShort(n == 0 ? 10 : 20);
        this.writeLeShort(n2);
        this.writeLeShort(n);
        this.writeLeInt(zipEntry.getDOSTime());
        if ((n2 & 8) == 0) {
            this.writeLeInt((int)zipEntry.getCrc());
            this.writeLeInt((int)zipEntry.getCompressedSize());
            this.writeLeInt((int)zipEntry.getSize());
        } else {
            this.writeLeInt(0);
            this.writeLeInt(0);
            this.writeLeInt(0);
        }
        String string = zipEntry.getName();
        byte[] byArray2 = byArray = this.encoding == null ? string.getBytes() : string.getBytes(this.encoding);
        if (byArray.length > 65535) {
            throw new ZipException("Name too long.");
        }
        byte[] byArray3 = zipEntry.getExtra();
        if (byArray3 == null) {
            byArray3 = new byte[]{};
        }
        this.writeLeShort(byArray.length);
        this.writeLeShort(byArray3.length);
        this.out.write(byArray);
        this.out.write(byArray3);
        this.offset += 30 + byArray.length + byArray3.length;
        this.curEntry = zipEntry;
        this.crc.reset();
        if (n == 8) {
            this.def.reset();
        }
        this.size = 0;
    }

    public void closeEntry() throws IOException {
        int n;
        if (this.curEntry == null) {
            throw new IllegalStateException("No open entry");
        }
        if (this.curMethod == 8) {
            super.finish();
        }
        int n2 = n = this.curMethod == 8 ? this.def.getTotalOut() : this.size;
        if (this.curEntry.getSize() < 0L) {
            this.curEntry.setSize(this.size);
        } else if (this.curEntry.getSize() != (long)this.size) {
            throw new ZipException("size was " + this.size + ", but I expected " + this.curEntry.getSize());
        }
        if (this.curEntry.getCompressedSize() < 0L) {
            this.curEntry.setCompressedSize(n);
        } else if (this.curEntry.getCompressedSize() != (long)n) {
            throw new ZipException("compressed size was " + n + ", but I expected " + this.curEntry.getSize());
        }
        if (this.curEntry.getCrc() < 0L) {
            this.curEntry.setCrc(this.crc.getValue());
        } else if (this.curEntry.getCrc() != this.crc.getValue()) {
            throw new ZipException("crc was " + Long.toHexString(this.crc.getValue()) + ", but I expected " + Long.toHexString(this.curEntry.getCrc()));
        }
        this.offset += n;
        if (this.curMethod == 8 && (this.curEntry.flags & 8) != 0) {
            this.writeLeInt(134695760);
            this.writeLeInt((int)this.curEntry.getCrc());
            this.writeLeInt((int)this.curEntry.getCompressedSize());
            this.writeLeInt((int)this.curEntry.getSize());
            this.offset += 16;
        }
        this.entries.addElement(this.curEntry);
        this.curEntry = null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.curEntry == null) {
            throw new IllegalStateException("No open entry.");
        }
        switch (this.curMethod) {
            case 8: {
                super.write(byArray, n, n2);
                break;
            }
            case 0: {
                this.out.write(byArray, n, n2);
            }
        }
        this.crc.update(byArray, n, n2);
        this.size += n2;
    }

    public void finish() throws IOException {
        if (this.entries == null) {
            return;
        }
        if (this.curEntry != null) {
            this.closeEntry();
        }
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            byte[] byArray;
            byte[] byArray2;
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            int n3 = zipEntry.getMethod();
            this.writeLeInt(33639248);
            this.writeLeShort(n3 == 0 ? 10 : 20);
            this.writeLeShort(n3 == 0 ? 10 : 20);
            this.writeLeShort(zipEntry.flags);
            this.writeLeShort(n3);
            this.writeLeInt(zipEntry.getDOSTime());
            this.writeLeInt((int)zipEntry.getCrc());
            this.writeLeInt((int)zipEntry.getCompressedSize());
            this.writeLeInt((int)zipEntry.getSize());
            String string2 = zipEntry.getName();
            byte[] byArray3 = byArray2 = this.encoding == null ? string2.getBytes() : string2.getBytes(this.encoding);
            if (byArray2.length > 65535) {
                throw new ZipException("Name too long.");
            }
            byte[] byArray4 = zipEntry.getExtra();
            if (byArray4 == null) {
                byArray4 = new byte[]{};
            }
            if ((byArray = (string = zipEntry.getComment()) != null ? (this.encoding == null ? string.getBytes() : string.getBytes(this.encoding)) : new byte[]{}).length > 65535) {
                throw new ZipException("Comment too long.");
            }
            this.writeLeShort(byArray2.length);
            this.writeLeShort(byArray4.length);
            this.writeLeShort(byArray.length);
            this.writeLeShort(0);
            this.writeLeShort(0);
            this.writeLeInt(0);
            this.writeLeInt(zipEntry.offset);
            this.out.write(byArray2);
            this.out.write(byArray4);
            this.out.write(byArray);
            ++n;
            n2 += 46 + byArray2.length + byArray4.length + byArray.length;
        }
        this.writeLeInt(101010256);
        this.writeLeShort(0);
        this.writeLeShort(0);
        this.writeLeShort(n);
        this.writeLeShort(n);
        this.writeLeInt(n2);
        this.writeLeInt(this.offset);
        this.writeLeShort(this.zipComment.length);
        this.out.write(this.zipComment);
        this.out.flush();
        this.entries = null;
    }
}

