/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.DataFormatException;
import com.trs.infra.util.jazzlib.Inflater;
import com.trs.infra.util.jazzlib.ZipException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private byte[] onebytebuffer = new byte[1];

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater(), 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        this.inf = inflater;
        this.len = 0;
        if (n <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[n];
    }

    public int available() throws IOException {
        return this.inf.finished() ? 0 : 1;
    }

    public void close() throws IOException {
        this.in.close();
    }

    protected void fill() throws IOException {
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len < 0) {
            throw new ZipException("Deflated stream ends early.");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public int read() throws IOException {
        int n = this.read(this.onebytebuffer, 0, 1);
        if (n > 0) {
            return this.onebytebuffer[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        while (true) {
            int n3;
            try {
                n3 = this.inf.inflate(byArray, n, n2);
            }
            catch (DataFormatException dataFormatException) {
                throw new ZipException(dataFormatException.getMessage());
            }
            if (n3 > 0) {
                return n3;
            }
            if (this.inf.needsDictionary()) {
                throw new ZipException("Need a dictionary");
            }
            if (this.inf.finished()) {
                return -1;
            }
            if (!this.inf.needsInput()) break;
            this.fill();
        }
        throw new InternalError("Don't know what to do");
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        int n = 2048;
        if (l < (long)n) {
            n = (int)l;
        }
        byte[] byArray = new byte[n];
        return this.read(byArray);
    }
}

