/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.CRC32;
import com.trs.infra.util.jazzlib.GZIPConstants;
import com.trs.infra.util.jazzlib.Inflater;
import com.trs.infra.util.jazzlib.InflaterInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class GZIPInputStream
extends InflaterInputStream
implements GZIPConstants {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean readGZIPHeader;

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 4096);
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
    }

    public void close() throws IOException {
        super.close();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.readGZIPHeader) {
            this.readHeader();
        }
        if (this.eos) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.crc.update(byArray, n, n3);
        }
        if (this.inf.finished()) {
            this.readFooter();
        }
        return n3;
    }

    private void readHeader() throws IOException {
        int n;
        int n2;
        CRC32 cRC32 = new CRC32();
        int n3 = this.in.read();
        if (n3 < 0) {
            this.eos = true;
            return;
        }
        cRC32.update(n3);
        if (n3 != 31) {
            throw new IOException("Error in GZIP header, first byte doesn't match");
        }
        n3 = this.in.read();
        if (n3 != 139) {
            throw new IOException("Error in GZIP header,  second byte doesn't match");
        }
        cRC32.update(n3);
        int n4 = this.in.read();
        if (n4 != 8) {
            throw new IOException("Error in GZIP header, data not in deflate format");
        }
        cRC32.update(n4);
        int n5 = this.in.read();
        if (n5 < 0) {
            throw new EOFException("Early EOF in GZIP header");
        }
        cRC32.update(n5);
        if ((n5 & 0xD0) != 0) {
            throw new IOException("Reserved flag bits in GZIP header != 0");
        }
        for (n2 = 0; n2 < 6; ++n2) {
            n = this.in.read();
            if (n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            cRC32.update(n);
        }
        if ((n5 & 4) != 0) {
            for (n2 = 0; n2 < 2; ++n2) {
                n = this.in.read();
                if (n < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                cRC32.update(n);
            }
            if (this.in.read() < 0 || this.in.read() < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            n2 = this.in.read();
            n = this.in.read();
            if (n2 < 0 || n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            cRC32.update(n2);
            cRC32.update(n);
            int n6 = n2 << 8 | n;
            for (int i = 0; i < n6; ++i) {
                int n7 = this.in.read();
                if (n7 < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                cRC32.update(n7);
            }
        }
        if ((n5 & 8) != 0) {
            while ((n2 = this.in.read()) > 0) {
                cRC32.update(n2);
            }
            if (n2 < 0) {
                throw new EOFException("Early EOF in GZIP file name");
            }
            cRC32.update(n2);
        }
        if ((n5 & 0x10) != 0) {
            while ((n2 = this.in.read()) > 0) {
                cRC32.update(n2);
            }
            if (n2 < 0) {
                throw new EOFException("Early EOF in GZIP comment");
            }
            cRC32.update(n2);
        }
        if ((n5 & 2) != 0) {
            n = this.in.read();
            if (n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            n2 = this.in.read();
            if (n2 < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            if ((n = n << 8 | n2) != ((int)cRC32.getValue() & 0xFFFF)) {
                throw new IOException("Header CRC value mismatch");
            }
        }
        this.readGZIPHeader = true;
    }

    private void readFooter() throws IOException {
        int n;
        byte[] byArray = new byte[8];
        int n2 = this.inf.getRemaining();
        if (n2 > 8) {
            n2 = 8;
        }
        System.arraycopy(this.buf, this.len - this.inf.getRemaining(), byArray, 0, n2);
        for (int i = 8 - n2; i > 0; i -= n) {
            n = this.in.read(byArray, 8 - i, i);
            if (n > 0) continue;
            throw new EOFException("Early EOF in GZIP footer");
        }
        n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
        if (n != (int)this.crc.getValue()) {
            throw new IOException("GZIP crc sum mismatch, theirs \"" + Integer.toHexString(n) + "\" and ours \"" + Integer.toHexString((int)this.crc.getValue()));
        }
        int n3 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | byArray[7] << 24;
        if (n3 != this.inf.getTotalOut()) {
            throw new IOException("Number of bytes mismatch");
        }
        this.eos = true;
    }
}

