/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.Deflater;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected Deflater def;

    protected void deflate() throws IOException {
        int n;
        while (!this.def.needsInput() && (n = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, n);
        }
        if (!this.def.needsInput()) {
            throw new InternalError("Can't deflate all input?");
        }
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, new Deflater(), 512);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 512);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) {
        super(outputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("bufsize <= 0");
        }
        this.buf = new byte[n];
        this.def = deflater;
    }

    public void flush() throws IOException {
        this.def.flush();
        this.deflate();
        this.out.flush();
    }

    public void finish() throws IOException {
        int n;
        this.def.finish();
        while (!this.def.finished() && (n = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, n);
        }
        if (!this.def.finished()) {
            throw new InternalError("Can't deflate all input?");
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.def.setInput(byArray, n, n2);
        this.deflate();
    }
}

