/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.Adler32;
import com.trs.infra.util.jazzlib.DeflaterConstants;
import com.trs.infra.util.jazzlib.DeflaterHuffman;
import com.trs.infra.util.jazzlib.DeflaterPending;

class DeflaterEngine
implements DeflaterConstants {
    private static final int TOO_FAR = 4096;
    private int ins_h;
    private byte[] buffer;
    private short[] head;
    private short[] prev;
    private int matchStart;
    private int matchLen;
    private boolean prevAvailable;
    private int blockStart;
    private int strstart;
    private int lookahead;
    private byte[] window;
    private int strategy;
    private int max_chain;
    private int max_lazy;
    private int niceLength;
    private int goodLength;
    private int comprFunc;
    private byte[] inputBuf;
    private int totalIn;
    private int inputOff;
    private int inputEnd;
    private DeflaterPending pending;
    private DeflaterHuffman huffman;
    private Adler32 adler;

    DeflaterEngine(DeflaterPending deflaterPending) {
        this.pending = deflaterPending;
        this.huffman = new DeflaterHuffman(deflaterPending);
        this.adler = new Adler32();
        this.window = new byte[65536];
        this.head = new short[32768];
        this.prev = new short[32768];
        this.strstart = 1;
        this.blockStart = 1;
    }

    public void reset() {
        int n;
        this.huffman.reset();
        this.adler.reset();
        this.strstart = 1;
        this.blockStart = 1;
        this.lookahead = 0;
        this.totalIn = 0;
        this.prevAvailable = false;
        this.matchLen = 2;
        for (n = 0; n < 32768; ++n) {
            this.head[n] = 0;
        }
        for (n = 0; n < 32768; ++n) {
            this.prev[n] = 0;
        }
    }

    public final void resetAdler() {
        this.adler.reset();
    }

    public final int getAdler() {
        int n = (int)this.adler.getValue();
        return n;
    }

    public final int getTotalIn() {
        return this.totalIn;
    }

    public final void setStrategy(int n) {
        this.strategy = n;
    }

    public void setLevel(int n) {
        this.goodLength = DeflaterConstants.GOOD_LENGTH[n];
        this.max_lazy = DeflaterConstants.MAX_LAZY[n];
        this.niceLength = DeflaterConstants.NICE_LENGTH[n];
        this.max_chain = DeflaterConstants.MAX_CHAIN[n];
        if (DeflaterConstants.COMPR_FUNC[n] != this.comprFunc) {
            switch (this.comprFunc) {
                case 0: {
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushStoredBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.updateHash();
                    break;
                }
                case 1: {
                    if (this.strstart <= this.blockStart) break;
                    this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                    this.blockStart = this.strstart;
                    break;
                }
                case 2: {
                    if (this.prevAvailable) {
                        this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                    }
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.prevAvailable = false;
                    this.matchLen = 2;
                }
            }
            this.comprFunc = COMPR_FUNC[n];
        }
    }

    private final void updateHash() {
        this.ins_h = this.window[this.strstart] << 5 ^ this.window[this.strstart + 1];
    }

    private final int insertString() {
        short s;
        int n = (this.ins_h << 5 ^ this.window[this.strstart + 2]) & Short.MAX_VALUE;
        this.prev[this.strstart & Short.MAX_VALUE] = s = this.head[n];
        this.head[n] = (short)this.strstart;
        this.ins_h = n;
        return s & 0xFFFF;
    }

    public void fillWindow() {
        while (this.lookahead < 262 && this.inputOff < this.inputEnd) {
            int n = 65536 - this.lookahead - this.strstart;
            if (this.strstart >= 65274) {
                System.arraycopy(this.window, 32768, this.window, 0, 32768);
                this.matchStart -= 32768;
                this.strstart -= 32768;
                this.blockStart -= 32768;
                for (int i = 0; i < 32768; ++i) {
                    short s = this.head[i];
                    this.head[i] = s >= 32768 ? (short)(s - 32768) : (short)0;
                }
                n += 32768;
            }
            if (n > this.inputEnd - this.inputOff) {
                n = this.inputEnd - this.inputOff;
            }
            System.arraycopy(this.inputBuf, this.inputOff, this.window, this.strstart + this.lookahead, n);
            this.adler.update(this.inputBuf, this.inputOff, n);
            this.inputOff += n;
            this.totalIn += n;
            this.lookahead += n;
            if (this.lookahead < 3) continue;
            this.updateHash();
        }
    }

    private boolean findLongestMatch(int n) {
        int n2 = this.max_chain;
        int n3 = this.niceLength;
        short[] sArray = this.prev;
        int n4 = this.strstart;
        int n5 = this.strstart + this.matchLen;
        int n6 = Math.max(this.matchLen, 2);
        int n7 = Math.max(this.strstart - 32506, 0);
        int n8 = this.strstart + 258 - 1;
        byte by = this.window[n5 - 1];
        byte by2 = this.window[n5];
        if (n6 >= this.goodLength) {
            n2 >>= 2;
        }
        if (n3 > this.lookahead) {
            n3 = this.lookahead;
        }
        do {
            if (this.window[n + n6] != by2 || this.window[n + n6 - 1] != by || this.window[n] != this.window[n4] || this.window[n + 1] != this.window[n4 + 1]) continue;
            int n9 = n + 2;
            n4 += 2;
            while (this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && n4 < n8) {
            }
            if (n4 > n5) {
                this.matchStart = n;
                n5 = n4;
                n6 = n4 - this.strstart;
                if (n6 >= n3) break;
                by = this.window[n5 - 1];
                by2 = this.window[n5];
            }
            n4 = this.strstart;
        } while ((n = sArray[n & Short.MAX_VALUE] & 0xFFFF) > n7 && --n2 != 0);
        this.matchLen = Math.min(n6, this.lookahead);
        return this.matchLen >= 3;
    }

    void setDictionary(byte[] byArray, int n, int n2) {
        this.adler.update(byArray, n, n2);
        if (n2 < 3) {
            return;
        }
        if (n2 > 32506) {
            n += n2 - 32506;
            n2 = 32506;
        }
        System.arraycopy(byArray, n, this.window, this.strstart, n2);
        this.updateHash();
        --n2;
        while (--n2 > 0) {
            this.insertString();
            ++this.strstart;
        }
        this.strstart += 2;
        this.blockStart = this.strstart;
    }

    private boolean deflateStored(boolean bl, boolean bl2) {
        if (!bl && this.lookahead == 0) {
            return false;
        }
        this.strstart += this.lookahead;
        this.lookahead = 0;
        int n = this.strstart - this.blockStart;
        if (n >= DeflaterConstants.MAX_BLOCK_SIZE || this.blockStart < 32768 && n >= 32506 || bl) {
            boolean bl3 = bl2;
            if (n > DeflaterConstants.MAX_BLOCK_SIZE) {
                n = DeflaterConstants.MAX_BLOCK_SIZE;
                bl3 = false;
            }
            this.huffman.flushStoredBlock(this.window, this.blockStart, n, bl3);
            this.blockStart += n;
            return !bl3;
        }
        return true;
    }

    private boolean deflateFast(boolean bl, boolean bl2) {
        if (this.lookahead < 262 && !bl) {
            return false;
        }
        while (this.lookahead >= 262 || bl) {
            int n;
            if (this.lookahead == 0) {
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, bl2);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.lookahead >= 3 && (n = this.insertString()) != 0 && this.strategy != 2 && this.strstart - n <= 32506 && this.findLongestMatch(n)) {
                this.huffman.tallyDist(this.strstart - this.matchStart, this.matchLen);
                this.lookahead -= this.matchLen;
                if (this.matchLen <= this.max_lazy && this.lookahead >= 3) {
                    while (--this.matchLen > 0) {
                        ++this.strstart;
                        this.insertString();
                    }
                    ++this.strstart;
                } else {
                    this.strstart += this.matchLen;
                    if (this.lookahead >= 2) {
                        this.updateHash();
                    }
                }
                this.matchLen = 2;
                continue;
            }
            this.huffman.tallyLit(this.window[this.strstart] & 0xFF);
            ++this.strstart;
            --this.lookahead;
            if (!this.huffman.isFull()) continue;
            boolean bl3 = bl2 && this.lookahead == 0;
            this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, bl3);
            this.blockStart = this.strstart;
            return !bl3;
        }
        return true;
    }

    private boolean deflateSlow(boolean bl, boolean bl2) {
        if (this.lookahead < 262 && !bl) {
            return false;
        }
        while (this.lookahead >= 262 || bl) {
            int n;
            if (this.lookahead == 0) {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                }
                this.prevAvailable = false;
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, bl2);
                this.blockStart = this.strstart;
                return false;
            }
            int n2 = this.matchStart;
            int n3 = this.matchLen;
            if (this.lookahead >= 3) {
                n = this.insertString();
                if (this.strategy != 2 && n != 0 && this.strstart - n <= 32506 && this.findLongestMatch(n) && this.matchLen <= 5 && (this.strategy == 1 || this.matchLen == 3 && this.strstart - this.matchStart > 4096)) {
                    this.matchLen = 2;
                }
            }
            if (n3 >= 3 && this.matchLen <= n3) {
                this.huffman.tallyDist(this.strstart - 1 - n2, n3);
                n3 -= 2;
                do {
                    ++this.strstart;
                    --this.lookahead;
                    if (this.lookahead < 3) continue;
                    this.insertString();
                } while (--n3 > 0);
                ++this.strstart;
                --this.lookahead;
                this.prevAvailable = false;
                this.matchLen = 2;
            } else {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                }
                this.prevAvailable = true;
                ++this.strstart;
                --this.lookahead;
            }
            if (!this.huffman.isFull()) continue;
            n = this.strstart - this.blockStart;
            if (this.prevAvailable) {
                --n;
            }
            boolean bl3 = bl2 && this.lookahead == 0 && !this.prevAvailable;
            this.huffman.flushBlock(this.window, this.blockStart, n, bl3);
            this.blockStart += n;
            return !bl3;
        }
        return true;
    }

    public boolean deflate(boolean bl, boolean bl2) {
        boolean bl3;
        do {
            this.fillWindow();
            boolean bl4 = bl && this.inputOff == this.inputEnd;
            switch (this.comprFunc) {
                case 0: {
                    bl3 = this.deflateStored(bl4, bl2);
                    break;
                }
                case 1: {
                    bl3 = this.deflateFast(bl4, bl2);
                    break;
                }
                case 2: {
                    bl3 = this.deflateSlow(bl4, bl2);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } while (this.pending.isFlushed() && bl3);
        return bl3;
    }

    public void setInput(byte[] byArray, int n, int n2) {
        if (this.inputOff < this.inputEnd) {
            throw new IllegalStateException("Old input was not completely processed");
        }
        int n3 = n + n2;
        if (0 > n || n > n3 || n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inputBuf = byArray;
        this.inputOff = n;
        this.inputEnd = n3;
    }

    public final boolean needsInput() {
        return this.inputEnd == this.inputOff;
    }
}

