/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HTML;
import com.trs.infra.util.html.HtmlAttribute;
import com.trs.infra.util.html.HtmlComment;
import com.trs.infra.util.html.HtmlDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HtmlElement
implements Cloneable {
    public static final int CON_COMMENT = 1;
    public static final int CON_ELEMENT = 2;
    public static final int CON_TEXT = 3;
    public static final String TAGS_TOSKIP = "p,form,div,span";
    public static boolean ISDEBUG = false;
    protected static final int FORMAT_BLANKS = 2;
    protected static final int INITIAL_ARRAY_SIZE = 5;
    public static final String TAG_ALONE = " AREA BR HR INPUT LI IMG META PARAM UL ";
    public static final String TAG_SHORT = " BR LI ";
    public boolean ONLY_SEARCH_SELF = false;
    protected String name;
    protected Object parent = null;
    protected List attributes = null;
    protected List content = null;
    private boolean m_bEndSelf = false;

    public HtmlElement() {
    }

    public HtmlElement(String string) {
        this.name = string;
    }

    public static boolean isAloneTag(String string) {
        if (string == null) {
            return false;
        }
        return TAG_ALONE.indexOf(" " + string.toUpperCase() + " ") >= 0;
    }

    public static boolean checkTagIn(String string, String string2) {
        if (string2 == null || string == null || (string = string.trim()).length() == 0) {
            return false;
        }
        return (',' + string2.toLowerCase() + ',').indexOf(',' + string.toLowerCase() + ',') >= 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean nameIs(String string) {
        return this.name.compareToIgnoreCase(string) == 0;
    }

    public HtmlElement setName(String string) {
        this.name = string;
        return this;
    }

    public HTML.Tag getTag() {
        return HTML.getTag(this.name);
    }

    public HtmlDocument getDocument() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof HtmlDocument) {
            return (HtmlDocument)this.parent;
        }
        if (this.parent instanceof HtmlElement) {
            return ((HtmlElement)this.parent).getDocument();
        }
        return null;
    }

    public HtmlElement setDocument(HtmlDocument htmlDocument) {
        this.parent = htmlDocument;
        return this;
    }

    public HtmlElement getParent() {
        if (this.parent instanceof HtmlElement) {
            return (HtmlElement)this.parent;
        }
        return null;
    }

    public HtmlElement setParent(HtmlElement htmlElement) {
        this.parent = htmlElement;
        return this;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public List getContent() {
        return this.content;
    }

    public HtmlAttribute getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        for (HtmlAttribute htmlAttribute : this.attributes) {
            if (htmlAttribute.getName().compareToIgnoreCase(string) != 0) continue;
            return htmlAttribute;
        }
        return null;
    }

    public String getAttributeValue(String string) {
        HtmlAttribute htmlAttribute = this.getAttribute(string);
        return htmlAttribute == null ? null : htmlAttribute.getValue();
    }

    public HtmlElement setAttributes(List list) {
        if (list == null) {
            this.attributes = null;
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
        }
        for (HtmlAttribute htmlAttribute : list) {
            if (htmlAttribute == null) continue;
            if (htmlAttribute.getParent() != this) {
                htmlAttribute.setParent(this);
            }
            this.attributes.add(htmlAttribute);
        }
        return this;
    }

    public HtmlElement setAttribute(String string, String string2) {
        return this.setAttribute(new HtmlAttribute(string, string2));
    }

    public HtmlElement setAttribute(String string, String string2, char c) {
        return this.setAttribute(new HtmlAttribute(string, string2, c));
    }

    public HtmlElement setAttribute(HtmlAttribute htmlAttribute) {
        if (htmlAttribute == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
            this.attributes.add(htmlAttribute);
            return this;
        }
        for (HtmlAttribute htmlAttribute2 : this.attributes) {
            if (!htmlAttribute2.nameIs(htmlAttribute.getName())) continue;
            htmlAttribute2.setValue(htmlAttribute.getValue());
            return this;
        }
        this.attributes.add(htmlAttribute);
        if (htmlAttribute.getParent() != this) {
            htmlAttribute.setParent(this);
        }
        return this;
    }

    public boolean removeAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            HtmlAttribute htmlAttribute = (HtmlAttribute)iterator.next();
            if (!htmlAttribute.nameIs(string)) continue;
            iterator.remove();
            htmlAttribute.setParent(null);
            return true;
        }
        return false;
    }

    public HtmlElement addContent(String string) {
        Object e;
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        string = string.trim();
        int n = this.content.size();
        if (n > 0 && (e = this.content.get(n - 1)) instanceof String) {
            string = (String)e + string;
            this.content.remove(n - 1);
        }
        this.content.add(string);
        return this;
    }

    public HtmlElement addContent(HtmlElement htmlElement) throws CMyException {
        if (htmlElement == null) {
            return this;
        }
        if (htmlElement.getParent() != null) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label1", "\u5143\u7d20\u5df2\u5b58\u5728Parent\uff08HtmlElement.addContent\uff09"));
        }
        if (htmlElement == this) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label2", "\u5143\u7d20\u4e0d\u80fd\u6dfb\u52a0\u5230\u81ea\u8eab\uff08HtmlElement.addContent\uff09"));
        }
        if (htmlElement.isAncestorOf(this)) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label3", "\u8981\u6dfb\u52a0\u7684\u5143\u7d20\u662f\u5f53\u524d\u5143\u7d20\u7684\u7956\u5148\uff08HtmlElement.addContent\uff09"));
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        htmlElement.setParent(this);
        this.content.add(htmlElement);
        return this;
    }

    public HtmlElement addContent(HtmlComment htmlComment) throws CMyException {
        if (htmlComment.getParent() != null || htmlComment.getDocument() != null) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label1", "\u5143\u7d20\u5df2\u5b58\u5728Parent\uff08HtmlElement.addContent\uff09"));
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        htmlComment.setParent(this);
        this.content.add(htmlComment);
        return this;
    }

    public boolean removeContent(HtmlComment htmlComment) {
        if (htmlComment == null || this.content == null) {
            return false;
        }
        if (this.content.remove(htmlComment)) {
            htmlComment.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(HtmlElement htmlElement) {
        if (htmlElement == null || this.content == null) {
            return false;
        }
        if (this.content.remove(htmlElement)) {
            htmlElement.setParent(null);
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        if (this.content == null || this.content.size() == 0) {
            return false;
        }
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof HtmlElement)) continue;
            return true;
        }
        return false;
    }

    public List getChildren() {
        return this.getChildren(null);
    }

    public List getChildren(String string) {
        ArrayList arrayList = null;
        if (this.content == null) {
            arrayList = new ArrayList(1);
        } else {
            arrayList = new ArrayList(this.content.size());
            for (Object e : this.content) {
                if (!(e instanceof HtmlElement) || string != null && !((HtmlElement)e).nameIs(string)) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public HtmlElement getChild(String string) {
        if (this.content == null) {
            return null;
        }
        for (Object e : this.content) {
            HtmlElement htmlElement;
            if (!(e instanceof HtmlElement) || !(htmlElement = (HtmlElement)e).nameIs(string)) continue;
            return htmlElement;
        }
        return null;
    }

    public String getText() {
        if (this.content == null || this.content.size() < 1) {
            return "";
        }
        if (this.content.size() == 1 && this.content.get(0) instanceof String) {
            return (String)this.content.get(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (Object e : this.content) {
            String string;
            if (e instanceof String) {
                stringBuffer.append((String)e);
                bl = true;
                continue;
            }
            if (!(e instanceof HtmlElement) || (string = ((HtmlElement)e).getText()).length() <= 0) continue;
            stringBuffer.append(string);
            bl = true;
        }
        return bl ? stringBuffer.toString() : "";
    }

    public boolean isRootElement() {
        return this.parent instanceof HtmlDocument;
    }

    public int getLevel() {
        int n = 0;
        Object object = this.parent;
        while (object != null && object instanceof HtmlElement) {
            ++n;
            object = ((HtmlElement)object).getParent();
        }
        return n;
    }

    public boolean isAncestorOf(HtmlElement htmlElement) {
        if (htmlElement == null) {
            return false;
        }
        HtmlElement htmlElement2 = htmlElement.getParent();
        while (htmlElement2 instanceof HtmlElement) {
            if (htmlElement2 == this) {
                return true;
            }
            htmlElement2 = htmlElement2.getParent();
        }
        return false;
    }

    public List getElementsByName(String string) {
        ArrayList arrayList = null;
        if (this.content == null) {
            arrayList = new ArrayList(1);
        } else {
            arrayList = new ArrayList(5);
            string = string.trim();
            for (Object e : this.content) {
                if (e == null || !(e instanceof HtmlElement)) continue;
                List list = ((HtmlElement)e).getElementsByName(string);
                if (string == null || ((HtmlElement)e).nameIs(string)) {
                    arrayList.add(e);
                }
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(list.get(i));
                }
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2, String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        if (bl) {
            stringBuffer.append("<").append(this.name);
            if (this.attributes != null && this.attributes.size() >= 1) {
                object = this.attributes.iterator();
                while (object.hasNext()) {
                    Iterator iterator = object.next();
                    if (iterator == null || !(iterator instanceof HtmlAttribute)) continue;
                    stringBuffer.append(" ").append(((HtmlAttribute)((Object)iterator)).toString());
                }
            }
            if (this.m_bEndSelf || HtmlElement.isAloneTag(this.name)) {
                stringBuffer.append(" /");
            }
            stringBuffer.append(">");
        }
        if (this.content != null) {
            int n = this.content.size();
            if (n == 1 && this.content.get(0) instanceof String) {
                stringBuffer.append((String)this.content.get(0));
            } else if (n >= 1) {
                for (Object e : this.content) {
                    if (e == null) continue;
                    if (e instanceof String) {
                        stringBuffer.append((String)e);
                        continue;
                    }
                    if (e instanceof HtmlComment) {
                        stringBuffer.append(((HtmlComment)e).toString());
                        continue;
                    }
                    if (!(e instanceof HtmlElement)) continue;
                    HTML.Tag tag = ((HtmlElement)e).getTag();
                    if (tag != null && tag.breakBeforeBegin()) {
                        stringBuffer.append("\n");
                        if (bl2) {
                            if (string2 == null) {
                                string2 = CMyString.makeBlanks((this.getLevel() + 1) * 2);
                            }
                            stringBuffer.append(string2);
                        }
                    }
                    stringBuffer.append(((HtmlElement)e).toString(true, bl2, string));
                }
            }
        }
        if (!(!bl || HtmlElement.isAloneTag(this.name) || string != null && HtmlElement.checkTagIn(this.name, string))) {
            if (bl2 && (object = this.getTag()) != null && ((HTML.Tag)object).breakBeforeEnd()) {
                stringBuffer.append("\n");
                stringBuffer.append(CMyString.makeBlanks(this.getLevel() * 2));
            }
            if (!this.ONLY_SEARCH_SELF) {
                stringBuffer.append("</").append(this.name).append(">");
            }
        }
        return stringBuffer.toString();
    }

    public String toString(boolean bl, boolean bl2) {
        return this.toString(bl, bl2, null);
    }

    public int fromString(String string, String string2) throws CMyException {
        int n;
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.content != null) {
            this.content.clear();
        }
        if ((n = string.length()) < 1) {
            return 0;
        }
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        return this.fromString(cArray, 0, string2);
    }

    public int fromString(String string) throws CMyException {
        return this.fromString(string, null);
    }

    public int fromString(char[] cArray, int n, String string) throws CMyException {
        boolean bl;
        char c;
        int n2;
        if (n < 0) {
            return -1;
        }
        int n3 = cArray.length;
        StringBuffer stringBuffer = null;
        String string2 = null;
        for (n2 = n; n2 < n3 && cArray[n2] != '<'; ++n2) {
        }
        ++n2;
        stringBuffer = new StringBuffer();
        while (n2 < n3 && !Character.isWhitespace(c = cArray[n2]) && c != '>') {
            stringBuffer.append(c);
            ++n2;
        }
        this.name = stringBuffer.toString();
        if (ISDEBUG) {
            System.out.println("\n Analyze Element [" + this.name + "]");
        }
        if (this.ONLY_SEARCH_SELF) {
            return n2;
        }
        boolean bl2 = HtmlElement.isAloneTag(this.name) || HtmlElement.checkTagIn(this.name, string);
        HTML.Tag tag = this.getTag();
        if (!bl2 && tag != null && tag.isPreformatted()) {
            stringBuffer = new StringBuffer();
            bl = true;
            for (n2 = this.readAttributes(cArray, n2); n2 < n3; ++n2) {
                int n4;
                c = cArray[n2];
                if (c == '\"') {
                    bl = !bl;
                } else if (c == '<' && bl && (n4 = this.checkAtEndTag(cArray, n2)) > 0) {
                    n2 = n4;
                    break;
                }
                stringBuffer.append(c);
            }
            this.addContent(stringBuffer.toString());
            bl2 = true;
        }
        while (!bl2 && n2 < n3) {
            while (n2 < n3 && Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (n2 >= n3) break;
            if (cArray[n2] != '<') {
                stringBuffer = new StringBuffer();
                bl = true;
                while (n2 < n3) {
                    c = cArray[n2];
                    if (c == '\"') {
                        bl = !bl;
                    } else if (c == '<' && bl) break;
                    stringBuffer.append(c);
                    ++n2;
                }
                this.addContent(stringBuffer.toString());
                continue;
            }
            if (cArray[n2 + 1] == '!') {
                HtmlComment htmlComment = new HtmlComment();
                stringBuffer = new StringBuffer();
                while (n2 < n3) {
                    c = cArray[n2++];
                    stringBuffer.append(c);
                    if (c != '-' || cArray[n2] != '-' || cArray[n2 + 1] != '>') continue;
                    stringBuffer.append("->");
                    n2 += 2;
                    break;
                }
                if (ISDEBUG) {
                    System.out.println("\nGet comment:\n" + stringBuffer.toString());
                }
                if (!htmlComment.fromString(stringBuffer.toString())) continue;
                this.addContent(htmlComment);
                continue;
            }
            if (cArray[n2 + 1] == '/') {
                stringBuffer = new StringBuffer();
                n2 += 2;
                while (n2 < n3 && (c = cArray[n2++]) != '>') {
                    if (Character.isWhitespace(c)) continue;
                    stringBuffer.append(c);
                }
                string2 = stringBuffer.toString();
                if (string == null || this.nameIs(string2) || !HtmlElement.checkTagIn(string2, string)) {
                    bl2 = true;
                    continue;
                }
                this.addContent("</" + string2 + ">");
                continue;
            }
            HtmlElement htmlElement = new HtmlElement();
            int n5 = htmlElement.fromString(cArray, n2, string);
            String string3 = htmlElement.getName();
            if (ISDEBUG && this.name.compareToIgnoreCase("form") == 0) {
                System.out.println("\n Analyze Child Element [" + string3 + "]");
                System.out.println("\n ===cotent===== \n" + htmlElement.toString(true, false));
            }
            if (string3 != null) {
                this.addContent(htmlElement);
            }
            n2 = n5;
        }
        return n2;
    }

    public int fromString(char[] cArray, int n) throws CMyException {
        return this.fromString(cArray, n, null);
    }

    private int readAttributes(char[] cArray, int n) {
        int n2 = n;
        int n3 = cArray.length;
        StringBuffer stringBuffer = null;
        int n4 = 32;
        int n5 = 32;
        boolean bl = true;
        while (n2 < n3) {
            while (n2 < n3 && Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (n2 >= n3 || cArray[n2] == '>' && bl) break;
            HtmlAttribute htmlAttribute = new HtmlAttribute();
            stringBuffer = new StringBuffer();
            while (n2 < n3) {
                n4 = cArray[n2];
                if ((n4 == 34 || n4 == 39) && cArray[n2 - 1] != '\\') {
                    if (n5 == 32) {
                        n5 = n4;
                        bl = false;
                    } else if (n4 == n5) {
                        bl = !bl;
                        n5 = 32;
                    }
                }
                if (bl && (Character.isWhitespace((char)n4) || n4 == 62)) break;
                if (bl && n4 == 47 && cArray[n2 + 1] == '>') {
                    ++n2;
                    this.m_bEndSelf = true;
                    break;
                }
                stringBuffer.append((char)n4);
                ++n2;
            }
            if (!htmlAttribute.fromString(stringBuffer.toString())) continue;
            this.setAttribute(htmlAttribute);
        }
        return ++n2;
    }

    private static int checkAtEndTag(char[] cArray, int n, String string) {
        char[] cArray2 = ("</" + string + ">").toLowerCase().toCharArray();
        int n2 = n;
        for (int i = 0; i < cArray2.length && n2 < cArray.length; ++i) {
            if (Character.toLowerCase(cArray[n2++]) == cArray2[i]) continue;
            return -1;
        }
        return n2;
    }

    private int checkAtEndTag(char[] cArray, int n) {
        return HtmlElement.checkAtEndTag(cArray, n, this.name);
    }

    public static void main(String[] stringArray) {
        ISDEBUG = false;
        HtmlElement htmlElement = new HtmlElement();
        try {
            String string = CMyFile.readFile("d:\\test\\sina.htm");
            String string2 = TAGS_TOSKIP;
            htmlElement.fromString("<BODY>" + string + "</BODY>", string2);
            System.out.println(htmlElement.toString(false, true, string2));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

