/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlDocument;
import com.trs.infra.util.html.HtmlElement;

public class HtmlAttribute
implements Cloneable {
    protected HtmlElement parent = null;
    protected String name;
    protected char chrQuote = '\u0000';
    protected String value;

    protected HtmlAttribute() {
    }

    public HtmlAttribute(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
        this.chrQuote = (char)34;
    }

    public HtmlAttribute(String string, String string2, char c) {
        this.setName(string);
        this.setValue(string2);
        this.chrQuote = c;
    }

    public HtmlAttribute(String string) {
        this.fromString(string);
    }

    public HtmlElement getParent() {
        return this.parent;
    }

    public HtmlAttribute setParent(HtmlElement htmlElement) {
        this.parent = htmlElement;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public HtmlAttribute setName(String string) {
        this.name = string.trim();
        return this;
    }

    public boolean nameIs(String string) {
        return this.name.compareToIgnoreCase(string) == 0;
    }

    public String getValue() {
        return this.value;
    }

    public HtmlAttribute setValue(String string) {
        this.value = string;
        return this;
    }

    public int getIntValue() throws CMyException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label1", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684int\u503c\uff08HtmlAttribute.getIntValue\uff09"));
        }
    }

    public long getLongValue() throws CMyException {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label2", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684long\u503c\uff08HtmlAttribute.getLongValue\uff09"));
        }
    }

    public float getFloatValue() throws CMyException {
        try {
            return Float.valueOf(this.value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label3", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684float\u503c\uff08HtmlAttribute.getFloatValue\uff09"));
        }
    }

    public double getDoubleValue() throws CMyException {
        try {
            return Double.valueOf(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label4", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684double\u503c\uff08HtmlAttribute.getDoubleValue\uff09"));
        }
    }

    public boolean getBooleanValue() throws CMyException {
        if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("on") || this.value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (this.value.equalsIgnoreCase("false") || this.value.equalsIgnoreCase("off") || this.value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new CMyException(2, I18NMessage.get(HtmlAttribute.class, "HtmlAttribute.label5", "\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff1a\u65e0\u6548\u7684boolean\u503c\uff08HtmlAttribute.getBooleanValue\uff09"));
    }

    public HtmlDocument getDocument() {
        if (this.parent != null) {
            return this.parent.getDocument();
        }
        return null;
    }

    public Object clone() {
        HtmlAttribute htmlAttribute = new HtmlAttribute(this.name, this.value);
        htmlAttribute.setParent(null);
        return htmlAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.name);
            if (CMyString.isEmpty(this.value)) {
                String string = stringBuffer.toString();
                return string;
            }
            stringBuffer.append('=');
            if (this.chrQuote != '\u0000') {
                stringBuffer.append(this.chrQuote);
            }
            stringBuffer.append(this.value);
            if (this.chrQuote != '\u0000') {
                stringBuffer.append(this.chrQuote);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            stringBuffer.setLength(0);
        }
    }

    public boolean fromString(String string) {
        int n = (string = string.trim()).indexOf(61);
        if (n < 0) {
            this.name = string;
            this.value = "";
            return !CMyString.isEmpty(this.name);
        }
        this.name = string.substring(0, n).trim();
        int n2 = string.length();
        boolean bl = false;
        char c = string.charAt(n2 - 1);
        if (c == '\"' || c == '\'') {
            this.chrQuote = c;
            --n2;
            bl = true;
        } else {
            this.chrQuote = '\u0000';
        }
        this.value = string.substring(n + 1, n2).trim();
        if (bl && this.value.length() > 0 && this.value.charAt(0) == c) {
            this.value = this.value.substring(1);
        }
        return true;
    }

    public static void main(String[] stringArray) {
        String string = "  c='123' ";
        HtmlAttribute htmlAttribute = new HtmlAttribute(string);
        System.out.println(htmlAttribute.toString());
    }
}

