/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.ftp;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.ftp.CMyFtp;
import com.trs.infra.util.ftp.FtpConnectionPool;
import com.trs.infra.util.ftp.IFtpMgr;

public class FtpMgr
implements IFtpMgr {
    private FtpConnectionPool m_ftpConnectionPool;
    private String m_sServerHost;
    private boolean m_bCheckWriteAuth = false;

    public void init(String string, String string2, String string3, String string4, boolean bl, int n) throws CMyException {
        this.m_ftpConnectionPool = new FtpConnectionPool(string, string2, string3, string4, bl, n);
        if (this.isCheckWriteAuth()) {
            CMyFtp cMyFtp = this.m_ftpConnectionPool.getConnection();
            try {
                if (!cMyFtp.makeDirectory("_test_")) {
                    throw new CMyException(I18NMessage.get(FtpMgr.class, "FtpMgr.label1", "\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55\uff01"));
                }
                this.m_ftpConnectionPool.free(cMyFtp);
            }
            catch (Exception exception) {
                try {
                    this.m_ftpConnectionPool.clear();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        this.m_sServerHost = string;
    }

    public String getServerHost() {
        return this.m_sServerHost;
    }

    public void clear() {
        this.m_ftpConnectionPool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String string, String string2) throws CMyException {
        CMyFtp cMyFtp = this.m_ftpConnectionPool.getConnection();
        try {
            boolean bl = cMyFtp.uploadFile(string, string2);
            return bl;
        }
        finally {
            this.m_ftpConnectionPool.free(cMyFtp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePath(String string) throws Exception {
        CMyFtp cMyFtp = this.m_ftpConnectionPool.getConnection();
        try {
            boolean bl = cMyFtp.removeDirectory(string);
            return bl;
        }
        finally {
            this.m_ftpConnectionPool.free(cMyFtp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFile(String string) throws Exception {
        CMyFtp cMyFtp = this.m_ftpConnectionPool.getConnection();
        try {
            boolean bl = cMyFtp.removeFile(string, true);
            return bl;
        }
        finally {
            this.m_ftpConnectionPool.free(cMyFtp);
        }
    }

    public boolean isCheckWriteAuth() {
        return this.m_bCheckWriteAuth;
    }

    public void setCheckWriteAuth(boolean bl) {
        this.m_bCheckWriteAuth = bl;
    }
}

