/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.ftp;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.ftp.CMyFtp;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class FtpConnectionPool
implements Runnable,
IClearable {
    private static Logger s_logger = Logger.getLogger(FtpConnectionPool.class);
    private Vector availableConnections;
    private Vector busyConnections;
    private boolean m_bPending = false;
    private int m_nMaxConnections = 20;
    private String m_sLoginUser;
    private String m_sPassword;
    private String m_sRootPath;
    private String m_sServer;
    private boolean m_bPassiveMode = false;
    private boolean waitIfBusy = true;

    public FtpConnectionPool(String string, String string2, String string3, String string4, boolean bl, int n) throws CMyException {
        this.m_sServer = string;
        this.m_sPassword = string3;
        this.m_sLoginUser = string2;
        this.m_sRootPath = string4;
        this.m_bPassiveMode = bl;
        this.m_nMaxConnections = n;
        this.availableConnections = new Vector(this.m_nMaxConnections);
        this.busyConnections = new Vector();
        for (int i = 0; i < this.m_nMaxConnections; ++i) {
            this.availableConnections.addElement(this.makeNewConnection());
        }
    }

    public synchronized void clear() {
        this.closeConnections(this.availableConnections);
        this.availableConnections.clear();
        this.closeConnections(this.busyConnections);
        this.busyConnections.clear();
    }

    private void closeConnections(Vector vector) {
        try {
            for (int i = 0; i < vector.size(); ++i) {
                CMyFtp cMyFtp = (CMyFtp)vector.elementAt(i);
                if (!cMyFtp.isConnected()) {
                    cMyFtp.Disconnect();
                }
                cMyFtp.setStopNoop(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void free(CMyFtp cMyFtp) {
        this.busyConnections.removeElement(cMyFtp);
        this.availableConnections.addElement(cMyFtp);
        this.notifyAll();
    }

    public synchronized CMyFtp getConnection() throws CMyException {
        if (!this.availableConnections.isEmpty()) {
            CMyFtp cMyFtp = (CMyFtp)this.availableConnections.lastElement();
            int n = this.availableConnections.size() - 1;
            this.availableConnections.removeElementAt(n);
            if (!cMyFtp.isConnected()) {
                s_logger.info((Object)(I18NMessage.get(FtpConnectionPool.class, "FtpConnectionPool.label1", "\u518d\u6b21\u8fde\u63a5FTP\u670d\u52a1\u5668![") + cMyFtp + "]"));
                cMyFtp.Connect(this.m_bPassiveMode);
            }
            this.busyConnections.addElement(cMyFtp);
            return cMyFtp;
        }
        if (this.totalConnections() < this.m_nMaxConnections && !this.m_bPending) {
            this.makeBackgroundConnection();
        } else if (!this.waitIfBusy) {
            throw new CMyException(41, "Connection limit reached");
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getConnection();
    }

    private void makeBackgroundConnection() {
        this.m_bPending = true;
        try {
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    private CMyFtp makeNewConnection() throws CMyException {
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        CMyFtp cMyFtp = new CMyFtp();
        cMyFtp.setConnectionInfo(this.m_sServer, "21", this.m_sLoginUser, this.m_sPassword);
        cMyFtp.setRemotePath(this.m_sRootPath);
        if (!cMyFtp.Connect(this.m_bPassiveMode)) {
            throw new CMyException(1000, I18NMessage.get(FtpConnectionPool.class, "FtpConnectionPool.label2", "\u5efa\u7acb\uff26\uff34\uff30\u8fde\u63a5\u4e0d\u6210\u529f\u5bfc\u81f4\u53d1\u5e03\u7ec8\u6b62!"));
        }
        debugTimer.stop();
        s_logger.info((Object)(I18NMessage.get(FtpConnectionPool.class, "FtpConnectionPool.label3", "\u8fde\u63a5FTP\u6240\u7528\u65f6\u95f4\u4e3a[") + debugTimer.getTime() + I18NMessage.get(FtpConnectionPool.class, "FtpConnectionPool.label4", "]\u6beb\u79d2!")));
        return cMyFtp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            CMyFtp cMyFtp = this.makeNewConnection();
            FtpConnectionPool ftpConnectionPool = this;
            synchronized (ftpConnectionPool) {
                this.availableConnections.addElement(cMyFtp);
                this.m_bPending = false;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        String string = "FtpConnectionPool(" + this.m_sServer + "," + this.m_sLoginUser + "," + this.m_sPassword + "," + this.m_sRootPath + ")" + ", available=" + this.availableConnections.size() + ", busy=" + this.busyConnections.size() + ", max=" + this.m_nMaxConnections;
        return string;
    }

    public synchronized int totalConnections() {
        return this.availableConnections.size() + this.busyConnections.size();
    }
}

