/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.ftp;

import com.jscape.inet.ftp.Ftp;
import com.jscape.inet.ftp.FtpException;
import com.jscape.inet.ftp.FtpFile;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.DebugTimer;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CMyFtp
implements Runnable {
    private static Logger s_logger = Logger.getLogger(CMyFtp.class);
    private String sFTPServer = "127.0.0.1";
    private String sFTPPort = "21";
    private String sLogin = "anonymous";
    private String sPassword = "trs@trs.com.cn";
    private String sLocalPath = "D:\\\\WCMData\\pub";
    private String sLocalPubPath = "D:\\\\WCMData\\pub";
    private String sRemotePath = "/";
    private Ftp ftpClient = new Ftp();
    public final String ERR_NO_LOCAL_FILE = I18NMessage.get(CMyFtp.class, "CMyFtp.label1", "\u6ca1\u6709\u8bbe\u7f6e\u672c\u5730\u6587\u4ef6\u540d");
    public static int UPLOAD_RETRY_TIMES = 2;
    public static final int LIST_ALL = 0;
    public static final int LIST_FILES = 1;
    public static final int LIST_DIRS = 2;
    private boolean m_bUploading = false;
    private boolean m_bPassive = false;
    private boolean m_bStopNoop = false;

    public CMyFtp() {
        new Thread(this).start();
    }

    public boolean Connect() throws CMyException {
        return this.Connect(this.m_bPassive);
    }

    public boolean Connect(boolean bl) throws CMyException {
        try {
            this.ftpClient.setHostname(this.sFTPServer);
            int n = Integer.valueOf(this.sFTPPort);
            this.ftpClient.setPort(n);
            this.ftpClient.setUsername(this.sLogin);
            this.ftpClient.setPassword(this.sPassword);
            this.ftpClient.setPassive(bl);
            this.ftpClient.connect();
            this.ftpClient.setBinary();
            return this.ftpClient.isConnected();
        }
        catch (Exception exception) {
            throw new CMyException(1000, I18NMessage.get(CMyFtp.class, "CMyFtp.label2", "FTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25\uff01"), exception);
        }
    }

    public boolean Disconnect() throws Exception {
        this.ftpClient.disconnect();
        return true;
    }

    public boolean renameFile(String string, String string2) throws CMyException {
        if (string == null || string2 == null || !this.ftpClient.isConnected()) {
            return false;
        }
        if (string.trim().length() <= 0 || string2.trim().length() <= 0) {
            return false;
        }
        try {
            this.ftpClient.renameFile(string, string2);
        }
        catch (Exception exception) {
            throw new CMyException(1001, I18NMessage.get(CMyFtp.class, "CMyFtp.label3", "\u91cd\u547d\u540d\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label4", "]\u4e3a[") + string2 + I18NMessage.get(CMyFtp.class, "CMyFtp.label5", "]\u5931\u8d25\uff01"), exception);
        }
        return true;
    }

    public boolean makeDirectory(String string) throws CMyException {
        if (string == null || !this.ftpClient.isConnected()) {
            return false;
        }
        int n = 1;
        while ((n = string.indexOf(47, n + 1)) != -1) {
            try {
                this.ftpClient.setDir(string.substring(0, n));
            }
            catch (Exception exception) {
                try {
                    this.ftpClient.makeDir(string.substring(0, n));
                }
                catch (Exception exception2) {
                    throw new CMyException(1001, I18NMessage.get(CMyFtp.class, "CMyFtp.label6", "\u521b\u5efa\u76ee\u5f55:") + string.substring(0, n) + I18NMessage.get(CMyFtp.class, "CMyFtp.label7", "\u5931\u8d25\uff01"), exception);
                }
            }
        }
        try {
            this.ftpClient.makeDir(string);
            return true;
        }
        catch (Exception exception) {
            throw new CMyException(1002, I18NMessage.get(CMyFtp.class, "CMyFtp.label6", "\u521b\u5efa\u76ee\u5f55:") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label7", "\u5931\u8d25\uff01"), exception);
        }
    }

    public boolean removeDirectory(String string) throws CMyException {
        if (string == null || !this.ftpClient.isConnected()) {
            return false;
        }
        try {
            this.ftpClient.deleteDir(string);
            return true;
        }
        catch (Exception exception) {
            throw new CMyException(1003, I18NMessage.get(CMyFtp.class, "CMyFtp.label8", "\u5220\u9664\u6587\u4ef6\u5939") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label7", "\u5931\u8d25\uff01"), exception);
        }
    }

    public void setLocalPubPath(String string) {
        if (string != null && this.sLocalPubPath.length() > 0) {
            this.sLocalPubPath = string.charAt(string.length() - 1) == File.separatorChar ? string : string + File.separatorChar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String string, String string2) throws CMyException {
        if (string == null) {
            return false;
        }
        this.m_bUploading = true;
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        boolean bl = true;
        int n = 0;
        try {
            do {
                try {
                    string.replace('/', File.separatorChar);
                    int n2 = string.lastIndexOf(File.separatorChar);
                    String string3 = string.substring(0, n2);
                    String string4 = string.substring(n2 + 1);
                    this.ftpClient.setLocalDir(new File(string3));
                    int n3 = string2.lastIndexOf(47);
                    this.changeDirs(string2.substring(0, n3 + 1));
                    this.ftpClient.upload(string4, string2, false);
                    bl = true;
                }
                catch (Exception exception) {
                    throw new CMyException(1005, I18NMessage.get(CMyFtp.class, "CMyFtp.label9", "\u4e0a\u4f20\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label10", "]\u5230[") + string2 + I18NMessage.get(CMyFtp.class, "CMyFtp.label11", "]\u5931\u8d25!"), exception);
                }
            } while (!bl && ++n < UPLOAD_RETRY_TIMES);
        }
        finally {
            this.m_bUploading = false;
        }
        debugTimer.stop();
        s_logger.info((Object)(I18NMessage.get(CMyFtp.class, "CMyFtp.label9", "\u4e0a\u4f20\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label12", "]\u6240\u7528\u65f6\u95f4\u4e3a[") + debugTimer.getTime() + I18NMessage.get(CMyFtp.class, "CMyFtp.label13", "]\u6beb\u79d2!")));
        return bl;
    }

    public void changeDirs(String string) throws CMyException {
        int n = 1;
        while ((n = string.indexOf(47, n + 1)) != -1) {
            String string2 = string.substring(0, n);
            try {
                this.ftpClient.setDir(string2);
            }
            catch (Exception exception) {
                try {
                    this.ftpClient.makeDir(string2);
                    this.ftpClient.setDir(string2);
                }
                catch (FtpException ftpException) {
                    throw new CMyException(1006, I18NMessage.get(CMyFtp.class, "CMyFtp.label14", "\u66f4\u6539FTP\u7684\u76ee\u5f55[") + string2 + I18NMessage.get(CMyFtp.class, "CMyFtp.label5", "]\u5931\u8d25\uff01"), ftpException);
                }
            }
        }
    }

    public void uploadDirectory(String string, String string2) throws CMyException {
        this.m_bUploading = true;
        try {
            if (string != null) {
                this.ftpClient.setLocalDir(new File(string));
            }
            if (string2 != null) {
                this.changeDirs(string2);
            }
            this.ftpClient.upload(new File(string), false);
        }
        catch (Exception exception) {
            throw new CMyException(1007, I18NMessage.get(CMyFtp.class, "CMyFtp.label15", "\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label16", "]\u6ca1\u6709\u4e0a\u4f20\u5230[") + string2 + "]", exception);
        }
        finally {
            this.m_bUploading = false;
        }
    }

    public boolean changeDir(String string, boolean bl) throws Exception {
        if (!this.ftpClient.isConnected()) {
            return false;
        }
        try {
            if (bl) {
                this.ftpClient.setDir(string);
            } else {
                this.ftpClient.setLocalDir(new File(string));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setConnectionInfo(String string, String string2, String string3, String string4) {
        this.setConnectionInfo(string, string2, string3, string4, false);
    }

    public void setConnectionInfo(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        if (string != null && string.length() > 0) {
            this.sFTPServer = string;
        }
        this.sFTPServer = this.sFTPServer.trim();
        if (this.sFTPServer.toUpperCase().indexOf("FTP://") == 0) {
            this.sFTPServer = this.sFTPServer.substring(6);
        }
        if ((n = this.sFTPServer.indexOf(":")) != -1 && n + 1 < this.sFTPServer.length()) {
            this.sFTPPort = this.sFTPServer.substring(n + 1, this.sFTPServer.length());
            this.sFTPServer = this.sFTPServer.substring(0, n);
        }
        if (this.sFTPPort.length() <= 0 && string2 != null && string2.length() > 0) {
            this.sFTPPort = string2;
        }
        if (string4 != null && string4.length() > 0) {
            this.sPassword = string4;
        }
        if (string3 != null && string3.length() > 0) {
            this.sLogin = string3;
        }
        this.m_bPassive = bl;
    }

    public void setRemotePath(String string) {
        if (string != null && string.length() > 0) {
            string.replace('\\', '/');
            this.sRemotePath = string.charAt(0) != '/' ? "/" : "";
            this.sRemotePath = this.sRemotePath + (string.charAt(string.length() - 1) == '/' ? string : string + "/");
        }
    }

    public void setLocalPath(String string) {
        if (string != null && string.length() > 0) {
            string.replace('/', File.separatorChar);
            this.sLocalPath = string.charAt(0) != File.separatorChar ? File.separator : "";
            this.sLocalPath = this.sLocalPath + (string.charAt(string.length() - 1) == File.separatorChar ? string : string + File.pathSeparator);
        }
    }

    /*
     * Loose catch block
     */
    public boolean downloadFile(String string, String string2) throws Exception {
        block5: {
            if (this.ftpClient != null && this.ftpClient.isConnected()) break block5;
            return false;
            {
                catch (Exception exception) {
                    throw new CMyException(1010, I18NMessage.get(CMyFtp.class, "CMyFtp.label17", "\u4e0b\u8f7d\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label10", "]\u5230[") + string2 + I18NMessage.get(CMyFtp.class, "CMyFtp.label11", "]\u5931\u8d25!"), exception);
                }
            }
        }
        try {
            this.ftpClient.download(string2, string);
            return true;
        }
        catch (Exception exception) {
            throw new CMyException(1009, I18NMessage.get(CMyFtp.class, "CMyFtp.label17", "\u4e0b\u8f7d\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label10", "]\u5230[") + string2 + I18NMessage.get(CMyFtp.class, "CMyFtp.label11", "]\u5931\u8d25!"), exception);
        }
    }

    public String getDateTime(String string, boolean bl) throws Exception {
        if (bl && !this.ftpClient.isConnected()) {
            return "";
        }
        try {
            if (bl) {
                Enumeration enumeration = this.ftpClient.getDirListing();
                while (enumeration.hasMoreElements()) {
                    FtpFile ftpFile = (FtpFile)enumeration.nextElement();
                    if (ftpFile.getFilename() != string) continue;
                    return ftpFile.getDate() + " " + ftpFile.getTime();
                }
            } else {
                Enumeration enumeration = this.ftpClient.getLocalDirListing();
                while (enumeration.hasMoreElements()) {
                    File file = (File)enumeration.nextElement();
                    if (file.getName() != string) continue;
                    Date date = new Date(file.lastModified());
                    StringTokenizer stringTokenizer = new StringTokenizer(date.toString());
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken() + "-" + stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    string2 = string2 + "-" + stringTokenizer.nextToken();
                    return string2 + string3;
                }
            }
        }
        catch (Exception exception) {
            throw new CMyException(1011, I18NMessage.get(CMyFtp.class, "CMyFtp.label18", "FTP\u63d0\u53d6\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label19", "]\u65f6\u95f4\u9519\u8bef!"), exception);
        }
        return "";
    }

    public int getFileSize(String string, boolean bl) throws Exception {
        if (bl && !this.ftpClient.isConnected()) {
            return 0;
        }
        try {
            if (bl) {
                Enumeration enumeration = this.ftpClient.getDirListing();
                while (enumeration.hasMoreElements()) {
                    FtpFile ftpFile = (FtpFile)enumeration.nextElement();
                    if (ftpFile.getFilename() != string) continue;
                    return (int)ftpFile.getFilesize();
                }
            } else {
                Enumeration enumeration = this.ftpClient.getLocalDirListing();
                while (enumeration.hasMoreElements()) {
                    File file = (File)enumeration.nextElement();
                    if (file.getName() != string) continue;
                    return (int)file.length();
                }
            }
        }
        catch (Exception exception) {
            throw new CMyException(1012, I18NMessage.get(CMyFtp.class, "CMyFtp.label20", "\u63d0\u53d6\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label21", "]\u5927\u5c0f\u4e0d\u6210\u529f!"), exception);
        }
        return 0;
    }

    public boolean removeFile(String string, boolean bl) throws Exception {
        if (bl && !this.ftpClient.isConnected()) {
            return false;
        }
        try {
            if (bl) {
                this.ftpClient.deleteFile(string);
            } else {
                File file = new File(string);
                file.delete();
            }
            return true;
        }
        catch (Exception exception) {
            throw new CMyException(1013, I18NMessage.get(CMyFtp.class, "CMyFtp.label22", "\u5220\u9664\u6587\u4ef6[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label23", "]\u9519\u8bef!"), exception);
        }
    }

    public boolean testFtpServer(String string, String string2, String string3) throws Exception {
        return this.testFtpServer(string, string2, string3, "/", false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testFtpServer(String string, String string2, String string3, String string4, boolean bl) throws Exception {
        boolean bl2 = false;
        this.setConnectionInfo(string, "21", string2, string3);
        this.setRemotePath(string4);
        if (!this.Connect()) throw new Exception(I18NMessage.get(CMyFtp.class, "CMyFtp.label26", "FTP\u670d\u52a1\u5668\u8fde\u63a5\u4e0d\u6210\u529f(FTP\u7684\u8bbe\u7f6e\u53ef\u80fd\u4e0d\u6b63\u786e)!"));
        if (!this.changeDir(string4, true)) throw new Exception(I18NMessage.get(CMyFtp.class, "CMyFtp.label25", "FTP\u670d\u52a1\u5668\u8def\u5f84\u68c0\u6d4b\u4e0d\u6210\u529f(\u8def\u5f84\u53ef\u80fd\u4e0d\u5b58\u5728)!"));
        bl2 = true;
        if (!bl) return this.Disconnect();
        bl2 = this.makeDirectory("__test__");
        this.removeDirectory("__test__");
        if (bl2) return this.Disconnect();
        throw new Exception(I18NMessage.get(CMyFtp.class, "CMyFtp.label24", "FTP\u670d\u52a1\u5668\u5199\u5165\u68c0\u6d4b\u4e0d\u6210\u529f(\u8bbe\u7f6e\u7684\u76ee\u5f55\u53ef\u80fd\u4e0d\u5177\u6709\u5199\u5165\u6743\u9650)!"));
    }

    public boolean isConnected() throws CMyException {
        if (this.ftpClient == null) {
            return false;
        }
        try {
            boolean bl = this.ftpClient.isConnected();
            return bl;
        }
        catch (Exception exception) {
            throw new CMyException(1014, I18NMessage.get(CMyFtp.class, "CMyFtp.label27", "\u68c0\u6d4bFTP\u662f\u5426\u8fde\u63a5\u9519\u8bef\uff01"), exception);
        }
    }

    public String listDirs(String string) throws Exception {
        return this.listDirectory(string, 2);
    }

    public String listDirectory(String string, int n) throws Exception {
        if (string == null || !this.isConnected()) {
            return "";
        }
        String string2 = "";
        try {
            if (!this.changeDir(string, true)) {
                return "";
            }
            Enumeration enumeration = this.ftpClient.getDirListing();
            block6: while (enumeration.hasMoreElements()) {
                FtpFile ftpFile = (FtpFile)enumeration.nextElement();
                switch (n) {
                    case 2: {
                        if (!ftpFile.isDirectory()) continue block6;
                        string2 = string2 + ftpFile.getFilename() + ",";
                        continue block6;
                    }
                    case 1: {
                        if (ftpFile.isDirectory()) continue block6;
                        string2 = string2 + ftpFile.getFilename() + ",";
                        continue block6;
                    }
                }
                string2 = string2 + ftpFile.getFilename() + ",";
            }
            return string2;
        }
        catch (Exception exception) {
            throw new CMyException(1015, I18NMessage.get(CMyFtp.class, "CMyFtp.label28", "\u63d0\u53d6\u76ee\u5f55[") + string + I18NMessage.get(CMyFtp.class, "CMyFtp.label23", "]\u9519\u8bef!"), exception);
        }
    }

    public String listAll(String string) throws Exception {
        return this.listDirectory(string, 0);
    }

    public String listFiles(String string) throws Exception {
        return this.listDirectory(string, 1);
    }

    public static CMyFtp getFtpConnection() throws Exception {
        CMyFtp cMyFtp = new CMyFtp();
        cMyFtp.setConnectionInfo("192.168.12.9", "21", "administrator", "my0743");
        cMyFtp.setLocalPath("ce");
        cMyFtp.setRemotePath("/ce/");
        String string = "0";
        boolean bl = string.equals("1");
        try {
            if (!cMyFtp.Connect(bl)) {
                throw new CMyException(1000, I18NMessage.get(CMyFtp.class, "CMyFtp.label34", "\u5efa\u7acb\uff26\uff34\uff30\u8fde\u63a5\u4e0d\u6210\u529f!"));
            }
        }
        catch (Exception exception) {
            throw new CMyException(1000, I18NMessage.get(CMyFtp.class, "CMyFtp.label35", "\u5efa\u7acb\uff26\uff34\uff30\u8fde\u63a5\u4e0d\u6210\u529f\u5bfc\u81f4!"));
        }
        return cMyFtp;
    }

    public static void main(String[] stringArray) {
        CMyFtp cMyFtp = new CMyFtp();
        cMyFtp.setConnectionInfo("127.0.0.1", "21", "caohui", "caohui");
        try {
            cMyFtp.Connect(false);
            Thread.sleep(2000000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CMyFtp cMyFtp2 = new CMyFtp();
        cMyFtp2.setConnectionInfo("192.9.200.230", "21", "anonymous", "trs");
        cMyFtp2.setLocalPath("D:\\Temp");
        cMyFtp2.setRemotePath("/");
        try {
            if (!cMyFtp2.Connect(false)) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            cMyFtp2 = null;
        }
        if (cMyFtp2 == null) {
            return;
        }
        String string = "/" + System.currentTimeMillis() + "_2.htm";
        try {
            long l = System.currentTimeMillis();
            System.out.println("Upload First....");
            cMyFtp2.uploadFile("D:\\Temp\\2.htm", string);
            cMyFtp2.removeFile("/2.htm", true);
            cMyFtp2.renameFile(string, "/2.htm");
            System.out.println("Upload First OK!");
            System.out.println("Eplased Time:" + (System.currentTimeMillis() - l));
            System.out.println("Upload Second....");
            cMyFtp2.uploadFile("D:\\Temp\\2.htm", string);
            cMyFtp2.removeFile("/2.htm", true);
            cMyFtp2.renameFile(string, "/2.htm");
            System.out.println("Upload Second OK!");
            System.out.println("Eplased Time:" + (System.currentTimeMillis() - l));
        }
        catch (CMyException cMyException) {
            System.err.println("CMyException Dump:");
            cMyException.printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("Exception Dump:");
            exception.printStackTrace();
        }
    }

    public void run() {
        if (this.ftpClient == null) {
            return;
        }
        while (!this.m_bStopNoop) {
            try {
                Thread.sleep(120000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_bUploading) continue;
            try {
                this.ftpClient.noop();
            }
            catch (Exception exception) {
                s_logger.error((Object)"ftp noop error!", (Throwable)exception);
                if (this.ftpClient.isConnected()) continue;
                try {
                    this.ftpClient.connect();
                }
                catch (Exception exception2) {
                    s_logger.error((Object)I18NMessage.get(CMyFtp.class, "CMyFtp.label36", "\u518d\u6b21\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff01"), (Throwable)exception2);
                }
            }
        }
    }

    public void setStopNoop(boolean bl) {
        this.m_bStopNoop = bl;
    }
}

