/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.email;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.util.email.SMTPServerConfig;
import com.trs.infra.util.email.SMTPServerConfigs;
import java.util.HashMap;
import java.util.Map;

public class SMTPServerConfigMapper {
    private Map m_hmSMTPServerConfig = new HashMap(2);
    private String m_sDefaultSMTPServer;
    private boolean m_bLoaded;

    public static SMTPServerConfigMapper getInstance() {
        return (SMTPServerConfigMapper)DreamFactory.createObjectById("SMTPServerConfigMapper");
    }

    private synchronized void load() {
        if (this.m_bLoaded) {
            return;
        }
        SMTPServerConfigs sMTPServerConfigs = (SMTPServerConfigs)XMLConfigServer.getInstance().getConfigObjects(SMTPServerConfigs.class).get(0);
        for (int i = 0; i < sMTPServerConfigs.size(); ++i) {
            this.m_hmSMTPServerConfig.put(sMTPServerConfigs.get(i).getName(), sMTPServerConfigs.get(i));
        }
        this.m_sDefaultSMTPServer = sMTPServerConfigs.getDefaultSMTPServer();
        if (!this.m_hmSMTPServerConfig.containsKey(this.m_sDefaultSMTPServer)) {
            throw new RuntimeException(I18NMessage.get(SMTPServerConfigMapper.class, "SMTPServerConfigMapper.label1", "\u9ed8\u8ba4\u7684SMTP\u670d\u52a1\u5668\u5c5e\u6027[") + this.m_sDefaultSMTPServer + I18NMessage.get(SMTPServerConfigMapper.class, "SMTPServerConfigMapper.label2", "]\u5e76\u6ca1\u6709\u8bbe\u7f6e!"));
        }
        this.m_bLoaded = true;
    }

    public SMTPServerConfig getSMTPServerConfigByName(String string) {
        if (!this.m_bLoaded) {
            this.load();
        }
        return (SMTPServerConfig)this.m_hmSMTPServerConfig.get(string);
    }

    public SMTPServerConfig getDefaultSMTPServerConfig() {
        if (!this.m_bLoaded) {
            this.load();
        }
        return (SMTPServerConfig)this.m_hmSMTPServerConfig.get(this.m_sDefaultSMTPServer);
    }

    public void clear() {
        if (this.m_hmSMTPServerConfig != null) {
            this.m_hmSMTPServerConfig.clear();
        }
        this.m_bLoaded = false;
    }
}

