/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.email;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.BASE64EncoderStream;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.email.CMyMailException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CMyEmail {
    private static Logger s_logger = Logger.getLogger(CMyEmail.class);
    public static final int FORMAT_HTML = 1;
    public static final int FORMAT_TEXT = 0;
    public static final String MAIL_SEPARATOR = "----TRS_Email_Maker";
    public static final String MAIL_HTML_SEPARATOR = "----TRS_Email_Maker";
    private static final String LR = "\r\n";
    private String m_sCharset = "GBK";
    private String m_sFrom;
    private String m_sReplyTo;
    private String m_sTo;
    private String m_sCc;
    private String m_sBcc;
    private String m_sSubject;
    private String m_sBody;
    private String m_sAttachFilename;
    private HashMap m_hAttachFileList;
    private int m_nMailFormat = 0;
    private boolean m_bMimeMail;
    private String m_sFromUser;

    public CMyEmail() {
        this.setMimeMail(true);
    }

    public void setFrom(String string) {
        this.m_sFrom = string;
    }

    public String getFrom() {
        return this.m_sFrom;
    }

    public void setFromUser(String string) {
        this.m_sFromUser = string;
    }

    public String getFromUser() {
        if (CMyString.isEmpty(this.m_sFromUser)) {
            return this.m_sFrom;
        }
        return this.m_sFromUser;
    }

    public void setReplyTo(String string) {
        this.m_sReplyTo = string;
    }

    public String getReplyTo() {
        return this.m_sReplyTo;
    }

    public void setTo(String string) {
        this.m_sTo = string;
    }

    public String getTo() {
        return this.m_sTo;
    }

    public void setCc(String string) {
        this.m_sCc = string;
    }

    public String getCc() {
        return this.m_sCc;
    }

    public void setBcc(String string) {
        this.m_sBcc = string;
    }

    public String getBcc() {
        return this.m_sBcc;
    }

    public void setSubject(String string) {
        this.m_sSubject = string;
    }

    public String getSubject() {
        return this.m_sSubject;
    }

    public void setBody(String string) {
        this.m_sBody = string;
    }

    public String getBody() {
        return this.m_sBody;
    }

    public void setAttachedFile(String string) {
        this.setAttachedFile(string, null);
    }

    public void setAttachedFile(String string, String string2) {
        if (string != null && string.length() > 0) {
            File file = new File(string);
            if (file.exists()) {
                this.m_sAttachFilename = file.getPath();
                this.addAttachedFile(this.m_sAttachFilename, string2);
            } else {
                s_logger.error((Object)(I18NMessage.get(CMyEmail.class, "CMyEmail.label1", "\u9644\u4ef6\u6587\u4ef6[") + string + I18NMessage.get(CMyEmail.class, "CMyEmail.label2", "]\u4e0d\u5b58\u5728")));
            }
        } else {
            this.m_sAttachFilename = "";
        }
    }

    public String getAttachedFile() {
        return this.m_sAttachFilename;
    }

    public void addAttachedFile(String string) {
        this.addAttachedFile(string, null);
    }

    public void addAttachedFile(String string, String string2) {
        if (CMyString.isEmpty(string) || !CMyFile.fileExists(string)) {
            return;
        }
        if (this.m_hAttachFileList == null) {
            this.m_hAttachFileList = new HashMap(3);
        }
        String string3 = CMyString.isEmpty(string2) ? CMyFile.extractFileName(string) : string2;
        this.m_hAttachFileList.put(string3, string);
    }

    public HashMap getAttatchedFileList() {
        return this.m_hAttachFileList;
    }

    public void setMailFormat(int n) {
        this.m_nMailFormat = n;
    }

    public int getMailFormat() {
        return this.m_nMailFormat;
    }

    public void setMimeMail(boolean bl) {
        this.m_bMimeMail = bl;
    }

    public boolean getMimeMail() {
        return this.m_bMimeMail;
    }

    public String composeMail() {
        return this.makeMailData();
    }

    public String makeMailData() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string = this.getFromUser();
        if (CMyString.isEmpty(string)) {
            string = this.getFrom();
        }
        stringBuffer.append("From: ");
        stringBuffer.append("=?");
        stringBuffer.append(this.m_sCharset);
        stringBuffer.append("?B?");
        try {
            stringBuffer.append(new String(BASE64EncoderStream.encode(string.getBytes(this.m_sCharset))));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuffer.append("?=");
        stringBuffer.append(" <").append(this.getFrom()).append('>');
        stringBuffer.append(LR);
        string = this.getTo();
        stringBuffer.append("To: ").append(string).append(LR);
        string = this.getCc();
        if (!CMyString.isEmpty(string)) {
            stringBuffer.append("Cc: ").append(string).append(LR);
        }
        string = this.getReplyTo();
        stringBuffer.append("Reply-To: ");
        if (CMyString.isEmpty(string)) {
            string = this.getFrom();
        }
        stringBuffer.append(string).append(LR);
        string = this.getSubject();
        stringBuffer.append("Subject: ");
        if (!CMyString.isEmpty(string)) {
            stringBuffer.append("=?");
            stringBuffer.append(this.m_sCharset);
            stringBuffer.append("?B?");
            try {
                stringBuffer.append(new String(BASE64EncoderStream.encode(string.getBytes(this.m_sCharset))));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append("?=").append(LR);
        }
        stringBuffer.append("Date: ").append(this.getCurrentDate()).append(LR);
        stringBuffer.append("MIME-Version: 1.0").append(LR);
        if (this.m_hAttachFileList != null && !this.m_hAttachFileList.isEmpty()) {
            stringBuffer.append("Content-Type: multipart/mixed; ").append(LR);
            stringBuffer.append("\tboundary=\"");
            stringBuffer.append("----TRS_Email_Maker");
            stringBuffer.append("\"").append(LR);
            stringBuffer.append("X-Mailer: TRS Mailer Ver 1.2").append(LR);
            stringBuffer.append(LR);
            stringBuffer.append("--").append("----TRS_Email_Maker").append(LR);
            if (this.m_nMailFormat == 0) {
                stringBuffer.append("Content-Type: text/plain; ").append(LR);
            } else {
                stringBuffer.append("Content-Type: text/html; ").append(LR);
            }
            stringBuffer.append("\tcharset=\"").append(this.m_sCharset);
            stringBuffer.append("\"").append(LR);
            stringBuffer.append("Content-Transfer-Encoding: base64").append(LR);
        } else if (this.m_nMailFormat == 1) {
            stringBuffer.append("Content-Type: text/html; ").append(LR);
            stringBuffer.append("\tcharset=\"").append(this.m_sCharset);
            stringBuffer.append("\"").append(LR);
            stringBuffer.append("Content-Transfer-Encoding: base64").append(LR);
        } else {
            stringBuffer.append("Content-Type: text/plain; ").append(LR);
            stringBuffer.append("\tcharset=\"").append(this.m_sCharset);
            stringBuffer.append("\"").append(LR);
            stringBuffer.append("Content-Transfer-Encoding: base64").append(LR);
        }
        stringBuffer.append(LR);
        string = this.getBody();
        stringBuffer.append(this.encode(string)).append(LR);
        stringBuffer.append(LR);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String encode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream);
        bASE64EncoderStream.write(string.getBytes(this.m_sCharset));
        bASE64EncoderStream.flush();
        String string2 = byteArrayOutputStream.toString();
        Object var7_6 = null;
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bASE64EncoderStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
        catch (Exception exception) {
            String string3;
            try {
                string3 = new String(BASE64EncoderStream.encode("System Error!".getBytes()));
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    bASE64EncoderStream.close();
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                bASE64EncoderStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return string3;
        }
    }

    private String getCurrentDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
        return simpleDateFormat.format(new Date(System.currentTimeMillis()));
    }

    static String getMailEnd() {
        return "------TRS_Email_Maker--\r\n\r\n";
    }

    public void validate() throws CMyMailException {
        if (this.getTo() == null || this.getTo().trim().length() == 0) {
            throw new CMyMailException(I18NMessage.get(CMyEmail.class, "CMyEmail.label3", "\u90ae\u4ef6\u63a5\u6536\u8005\u4e3a\u7a7a\uff01 "));
        }
    }
}

