/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.SQLServerDB;
import java.sql.ResultSet;
import java.sql.SQLException;

public class XuguDB
extends SQLServerDB {
    private static final int TYPES_NVARCHAR = -9;
    public static final DataType INT = new DataType("INT", 4, 4);
    public static final DataType INTEGER = new DataType("INTEGER", 4, 4);
    public static final DataType CLOB = new DataType("CLOB", -1, 16);
    static final DataType[] m_allDataTypes = new DataType[]{BIGINT, CHAR, DATETIME, FLOAT, INT, INTEGER, NUMERIC, REAL, SMALLINT, TINYINT, VARCHAR, CLOB, NVARCHAR};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, TINYINT, INT, VARCHAR, CLOB, DATETIME, FLOAT, INTEGER, NVARCHAR};

    public XuguDB() {
        this("XuguDB", "com.xugu.jdbc.Driver");
    }

    public XuguDB(String string, String string2) {
        super(string, string2);
    }

    protected void registerDBInfo() {
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2005, "clob");
    }

    public String getClob(ResultSet resultSet, boolean bl, int n) throws CMyException {
        try {
            return resultSet.getString(n);
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, "\u8bfb\u53d6CLOB\u5185\u5bb9\u5931\u8d25", sQLException);
        }
    }

    public String getClob(ResultSet resultSet, boolean bl, String string) throws CMyException {
        try {
            return resultSet.getString(string);
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, "\u8bfb\u53d6CLOB\u5185\u5bb9\u5931\u8d25", sQLException);
        }
    }

    public String sqlGetSysDate() {
        return "sysdate()";
    }

    public String sqlGetNextId() {
        return null;
    }

    public String sqlQueryTableInfos(String string) {
        return null;
    }

    public String sqlQueryTableInfo(String string, String string2) {
        return null;
    }

    public String sqlConcatStr(String string, String string2, String string3) {
        return this.sqlConcatStr(new String[]{string, string2, string3});
    }

    public String sqlConcatStr(String string, String string2) {
        return this.sqlConcatStr(new String[]{string, string2});
    }

    public String sqlConcatStr(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(stringArray[0]);
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.append("||").append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public String sqlDate(String string) {
        return this.sqlDateTime(string, "YYYY-MM-DD HH24:MI:SS");
    }

    public String sqlDateField(String string) {
        return string;
    }

    public String sqlDateTime(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("TO_DATE('");
        stringBuffer.append(string);
        stringBuffer.append("','");
        stringBuffer.append(string2);
        stringBuffer.append("')");
        return stringBuffer.toString();
    }

    public String sqlFilterForClob(String string, String string2) {
        return "";
    }

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        DataType dataType = this.getDataType(string3);
        if (dataType == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table ");
        stringBuffer.append(string.toUpperCase());
        stringBuffer.append(" add ").append(string2.toUpperCase());
        int n3 = n;
        switch (dataType.getType()) {
            case 2: 
            case 4: {
                stringBuffer.append(" integer ");
                n3 = dataType.getMaxLength();
                break;
            }
            case 6: {
                stringBuffer.append(" float ");
                n3 = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                stringBuffer.append(" datetime ");
                break;
            }
            case -9: 
            case 12: {
                stringBuffer.append(" varchar ");
                break;
            }
        }
        if (dataType.isLengthDefinedByUser()) {
            stringBuffer.append('(').append(n3);
            if (n2 > 0) {
                stringBuffer.append(',').append(n2);
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String sqlRenameField(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table ");
        stringBuffer.append(string.toUpperCase());
        stringBuffer.append(" rename ");
        stringBuffer.append(string2.toUpperCase());
        stringBuffer.append(" to ");
        stringBuffer.append(string3.toUpperCase());
        return stringBuffer.toString();
    }

    public String sqlRenameTable(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table ");
        stringBuffer.append(string.toUpperCase());
        stringBuffer.append(" rename to");
        stringBuffer.append(string2.toUpperCase());
        return stringBuffer.toString();
    }

    public String sqlModifyField(String string, String string2, int n, int n2, boolean bl, int n3) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table ");
        stringBuffer.append(string);
        stringBuffer.append(" alter column ");
        stringBuffer.append(string2);
        stringBuffer.append(this.getTypeName(n, n2, n2, n3));
        return stringBuffer.toString();
    }

    public String sqlFilterOneDay(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("extract_day(");
        stringBuffer.append(string);
        stringBuffer.append("-'");
        stringBuffer.append(string2);
        stringBuffer.append("')=0");
        return stringBuffer.toString();
    }

    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }
}

