/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DBTypes;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.database.TableInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableInfos {
    private Hashtable hTableInfos = new Hashtable();

    protected void finalize() {
        this.clear();
    }

    public void clear() {
        this.hTableInfos.clear();
    }

    public int getTableCount() {
        return this.hTableInfos.size();
    }

    public Enumeration getTableNames() {
        return this.hTableInfos.keys();
    }

    public TableInfo getTableInfo(String string) {
        if (string == null) {
            return null;
        }
        return (TableInfo)this.hTableInfos.get(string.trim().toUpperCase());
    }

    public FieldInfo getFieldInfo(String string, String string2) {
        TableInfo tableInfo = this.getTableInfo(string);
        if (tableInfo == null) {
            return null;
        }
        return tableInfo.getFieldInfo(string2);
    }

    public boolean isField(String string, String string2) {
        return null != this.getFieldInfo(string, string2);
    }

    public void load(Connection connection, DBType dBType, String string) throws CMyException {
        this.load(connection, dBType, string, null);
    }

    public void load(Connection connection, DBType dBType, String string, String string2) throws CMyException {
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            this.hTableInfos.clear();
        }
        try {
            String string3;
            Statement statement = connection.createStatement();
            String string4 = string3 = string2 == null ? dBType.sqlQueryTableInfos(string) : dBType.sqlQueryTableInfo(string, string2);
            if (CMyString.isEmpty(string3)) {
                this.loadDbMetaData(connection, dBType, string2);
                return;
            }
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(string3);
            }
            catch (SQLException sQLException) {
                this.loadDbMetaData(connection, dBType, string2);
                return;
            }
            TableInfo tableInfo = null;
            while (resultSet.next()) {
                String string5 = resultSet.getString("TABLE_NAME").toUpperCase();
                int n = resultSet.getInt("COLUMN_ID");
                String string6 = resultSet.getString("COLUMN_NAME").toUpperCase();
                String string7 = resultSet.getString("DATA_TYPE");
                int n2 = resultSet.getInt("DATA_LENGTH");
                String string8 = resultSet.getString("NULLABLE");
                boolean bl = false;
                if (string8 == null || string8.compareToIgnoreCase("Y") == 0) {
                    bl = true;
                }
                String string9 = resultSet.getString("DATA_DEFAULT");
                int n3 = resultSet.getInt("DATA_SCALE");
                FieldInfo fieldInfo = new FieldInfo(dBType, string7, n2, bl, n, string9, n3);
                if (tableInfo == null || tableInfo.getTableName().compareTo(string5) != 0) {
                    tableInfo = new TableInfo();
                    tableInfo.setTableName(string5);
                    this.hTableInfos.put(string5, tableInfo);
                }
                tableInfo.putFieldInfo(string6, fieldInfo);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), sQLException);
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), exception);
        }
    }

    private void loadDbMetaData(Connection connection, DBType dBType, String string) throws CMyException {
        try {
            String string2 = null;
            if (!CMyString.isEmpty(string)) {
                string2 = "%" + string + "%";
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, string2, new String[]{"TABLE"});
            TableInfo tableInfo = null;
            ResultSet resultSet2 = null;
            String string3 = null;
            while (resultSet.next()) {
                string3 = resultSet.getString(3).toUpperCase();
                tableInfo = new TableInfo();
                tableInfo.setTableName(resultSet.getString(3));
                FieldInfo fieldInfo = null;
                String string4 = null;
                int n = 0;
                boolean bl = false;
                int n2 = 0;
                String string5 = "";
                int n3 = 0;
                String string6 = null;
                resultSet2 = databaseMetaData.getColumns(null, null, string3, null);
                while (resultSet2.next()) {
                    string4 = resultSet2.getString("COLUMN_NAME").toUpperCase();
                    n = resultSet2.getInt("COLUMN_SIZE");
                    bl = 1 == resultSet2.getInt("NULLABLE");
                    n2 = resultSet2.getInt("ORDINAL_POSITION");
                    string5 = resultSet2.getString("COLUMN_DEF");
                    n3 = resultSet2.getInt("DECIMAL_DIGITS");
                    string6 = resultSet2.getString("TYPE_NAME");
                    fieldInfo = new FieldInfo(dBType, string6, n, bl, n2, string5, n3);
                    tableInfo.putFieldInfo(string4, fieldInfo);
                }
                resultSet2.close();
                this.hTableInfos.put(string3, tableInfo);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new CMyException(I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), exception);
        }
    }

    public void toHtml(Connection connection, int n, String string) throws CMyException {
        try {
            String string2 = null;
            if (n == 1) {
                string2 = "SELECT TABLE_NAME,COLUMN_ID,COLUMN_NAME,DATA_TYPE,DATA_LENGTH,NULLABLE,DATA_DEFAULT FROM ALL_TAB_COLUMNS WHERE OWNER='TRSWCM' ORDER BY TABLE_NAME,COLUMN_ID";
            } else if (n == 2) {
                string2 = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
            } else if (n == 7) {
                string2 = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
            } else if (n == 3) {
                string2 = "SELECT c.tbname AS TABLE_NAME,c.colno AS COLUMN_ID,c.name AS COLUMN_NAME,c.typename AS DATA_TYPE,c.longlength AS DATA_LENGTH, c.nulls AS NULLABLE,c.default AS DATA_DEFAULT,c.scale AS DATA_SCALE FROM sysibm.syscolumns c where c.tbcreator='TRSWCM' ORDER BY TABLE_NAME, COLUMN_ID";
            } else if (n == 4) {
                string2 = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
            } else {
                throw new CMyException(1, I18NMessage.get(TableInfos.class, "TableInfos.label2", "\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6570\u636e\u5e93\uff01"));
            }
            DBType dBType = DBTypes.getDBType(n);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            String string3 = null;
            String string4 = "<html><body>";
            string4 = string4 + "\n<head>\n    <link rel=\"stylesheet\" href=\"../style.css\">\n</head>";
            while (resultSet.next()) {
                String string5 = resultSet.getString("TABLE_NAME").toUpperCase();
                int n2 = resultSet.getInt("COLUMN_ID");
                String string6 = resultSet.getString("COLUMN_NAME").toUpperCase();
                String string7 = resultSet.getString("DATA_TYPE");
                int n3 = resultSet.getInt("DATA_LENGTH");
                boolean bl = resultSet.getString("NULLABLE").compareToIgnoreCase("Y") == 0;
                String string8 = resultSet.getString("DATA_DEFAULT");
                int n4 = resultSet.getInt("DATA_SCALE");
                if (string3 == null || string3.compareTo(string5) != 0) {
                    string3 = string5;
                    if (string3 != null) {
                        string4 = string4 + "\n<table/>\n</p><br>";
                    }
                    string4 = string4 + "\n<p><img border=\"0\" src=\"../images/BlueDot.gif\" align=\"absmiddle\"><b>" + string5 + "</b>";
                    string4 = string4 + "\n<table border='0' cellspacing='2' cellpadding='2'>";
                    string4 = string4 + "\n<tr bgcolor=\"#dddddd\">";
                    string4 = string4 + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label3", " nowrap>\u5c5e\u6027\u540d\u79f0</td>");
                    string4 = string4 + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label4", " nowrap>\u5b57\u6bb5\u540d\u79f0</td>");
                    string4 = string4 + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label5", " nowrap>\u5217\u6807\u53f7</td>");
                    string4 = string4 + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label6", " nowrap>\u6570\u636e\u7c7b\u578b</td>");
                    string4 = string4 + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label7", " nowrap>\u957f\u5ea6</td>");
                    string4 = string4 + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label8", " nowrap>\u5141\u8bb8\u4e3a\u7a7a</td>");
                    string4 = string4 + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label9", " nowrap>\u9ed8\u8ba4\u503c</td>");
                    string4 = string4 + "\n</tr>";
                }
                FieldInfo fieldInfo = new FieldInfo(dBType, string7, n3, bl, n2, string8, n4);
                string4 = string4 + "\n<tr bgcolor=\"#eeeeee\">";
                string4 = string4 + "\n    <td nowrap>" + string6 + "</td>";
                string4 = string4 + "\n    <td nowrap>" + string6 + "</td>";
                string4 = string4 + "\n    <td nowrap>" + fieldInfo.getColumnID() + "</td>";
                string4 = string4 + "\n    <td nowrap>" + fieldInfo.getDataTypeName() + "</td>";
                string4 = string4 + "\n    <td nowrap>" + fieldInfo.getDataLength() + "</td>";
                string4 = fieldInfo.isNullable() ? string4 + "\n    <td nowrap><font color=#0000ff>Yes</font></td>" : string4 + "\n    <td nowrap><font color=#ff0000>No</font></td>";
                string4 = string4 + "\n    <td nowrap>" + fieldInfo.getDataDefault() + "</td>";
                string4 = string4 + "\n</tr>";
            }
            resultSet.close();
            statement.close();
            string4 = string4 + "\n<table/>\n</p><br>";
            string4 = string4 + "\n</body>\n</html>";
            CMyFile.writeFile(string, string4);
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(TableInfos.class, "TableInfos.label10", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.toHtml\uff09"), sQLException);
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(TableInfos.class, "TableInfos.label10", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.toHtml\uff09"), exception);
        }
    }

    public synchronized void notifyAddTable(Connection connection, DBType dBType, String string, String string2) throws CMyException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            String string3 = dBType.sqlQueryTableInfos(string);
            if (CMyString.isEmpty(string3)) {
                this.loadDbMetaData(connection, dBType, string2);
                return;
            }
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(string3);
            }
            catch (SQLException sQLException) {
                this.loadDbMetaData(connection, dBType, string2);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return;
            }
            TableInfo tableInfo = null;
            while (resultSet.next()) {
                String string4 = resultSet.getString("TABLE_NAME").toUpperCase();
                int n = resultSet.getInt("COLUMN_ID");
                String string5 = resultSet.getString("COLUMN_NAME").toUpperCase();
                String string6 = resultSet.getString("DATA_TYPE");
                int n2 = resultSet.getInt("DATA_LENGTH");
                String string7 = resultSet.getString("NULLABLE");
                boolean bl = false;
                if (string7 == null || string7.compareToIgnoreCase("Y") == 0) {
                    bl = true;
                }
                String string8 = resultSet.getString("DATA_DEFAULT");
                int n3 = resultSet.getInt("DATA_SCALE");
                FieldInfo fieldInfo = new FieldInfo(dBType, string6, n2, bl, n, string8, n3);
                if (tableInfo == null || tableInfo.getTableName().compareTo(string4) != 0) {
                    tableInfo = new TableInfo();
                    tableInfo.setTableName(string4);
                    this.hTableInfos.put(string4, tableInfo);
                }
                tableInfo.putFieldInfo(string5, fieldInfo);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), sQLException);
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public synchronized void notifyRemoveTable(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        this.hTableInfos.remove(string.toUpperCase());
    }

    public static void main(String[] stringArray) {
        try {
            DBType dBType = DBTypes.getDBType(7);
            Class.forName("com.mysql.jdbc.Driver");
            Connection connection = DriverManager.getConnection("jdbc:mysql://192.9.200.9/poll_mysql", "root", "trsadmin");
            TableInfos tableInfos = new TableInfos();
            tableInfos.load(connection, dBType, "wcm");
            TableInfo tableInfo = null;
            Enumeration enumeration = null;
            Enumeration enumeration2 = tableInfos.getTableNames();
            while (enumeration2.hasMoreElements()) {
                String string = enumeration2.nextElement().toString();
                System.out.println(I18NMessage.get(TableInfos.class, "TableInfos.label11", "\u8868\u540d\u4e3a\uff1a") + string);
                tableInfo = tableInfos.getTableInfo(string);
                enumeration = tableInfo.getFieldNames();
                while (enumeration.hasMoreElements()) {
                    FieldInfo fieldInfo = tableInfo.getFieldInfo(enumeration.nextElement().toString());
                    System.out.println(I18NMessage.get(TableInfos.class, "TableInfos.label12", "\u5b57\u6bb5\u5143\u6570\u636e\u4e3a\uff1a") + fieldInfo.toString());
                }
            }
            connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeTableInfo(String string) throws WCMException {
        this.removeTableInfo(string, true);
    }

    public void removeTableInfo(String string, boolean bl) throws WCMException {
        String string2 = string.toUpperCase();
        TableInfo tableInfo = this.getTableInfo(string);
        if (tableInfo == null) {
            return;
        }
        this.hTableInfos.remove(string2);
        tableInfo.clear();
        if (!bl) {
            return;
        }
        try {
            IClusterMsgCenter iClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            iClusterMsgCenter.send("REMOVE.TABLE", new String[]{string});
        }
        catch (Exception exception) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u5220\u9664\u8868\u4fe1\u606f\u5931\u8d25\uff01", exception);
        }
    }
}

