/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CSQLText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.sql.Connection;
import java.sql.ResultSet;

public class SQLServerDB
extends DBType {
    public static String WRITE_STR_ENCODING = "ISO-8859-1";
    public static final DataType BIT = new DataType("BIT", -7, 1);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INT = new DataType("INT", 4, 4);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, 9);
    public static final DataType REAL = new DataType("REAL", 7, 4);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType MONEY = new DataType("MONEY", 3, 8);
    public static final DataType SMALLMONEY = new DataType("SMALLMONEY", 3, 4);
    public static final DataType BINARY = new DataType("BINARY", -2);
    public static final DataType VARBINARY = new DataType("VARBINARY", -3);
    public static final DataType IMAGE = new DataType("IMAGE", -4, 16);
    public static final DataType CHAR = new DataType("CHAR", 1, -8000);
    public static final DataType NCHAR = new DataType("NCHAR", 1, -4000);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -8000);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType TEXT = new DataType("TEXT", -1, 16);
    public static final DataType NTEXT = new DataType("NTEXT", -1, 16);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType DATETIME = new DataType("DATETIME", 93, 8);
    public static final DataType SMALLDATETIME = new DataType("SMALLDATETIME", 93, 4);
    public static final DataType UNIQUEIDENTIFIER = new DataType("UNIQUEIDENTIFIER", -5, 16);
    public static final DataType SQL_VARIRANT = new DataType("SQL_VARIRANT", -3);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 12, -4000);
    public static final DataType NUMBER = new DataType("NUMBER", 4, 4);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    static final DataType[] m_allDataTypes = new DataType[]{BIGINT, BINARY, BIT, CHAR, DATETIME, DECIMAL, FLOAT, IMAGE, INT, MONEY, NCHAR, NTEXT, NUMERIC, NVARCHAR, REAL, SMALLDATETIME, SMALLINT, SMALLMONEY, SQL_VARIRANT, TEXT, TIMESTAMP, TINYINT, UNIQUEIDENTIFIER, VARBINARY, VARCHAR, VARCHAR2, NUMBER, DATE};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, TINYINT, INT, NVARCHAR, NTEXT, DATETIME, FLOAT};

    public SQLServerDB() {
        super("SQLServer", "net.sourceforge.jtds.jdbc.Driver", true);
    }

    public SQLServerDB(String string, String string2) {
        super(string, string2, true);
    }

    protected void registerDBInfo() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "nvarchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
        this.registerColumnType(-3, "image");
        this.registerColumnType(-3, 8000, "varbinary($l)");
    }

    public String encodeStrToWrite(String string) {
        return string;
    }

    public boolean canWriteTextDirectly() {
        return true;
    }

    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    public String sqlConcatStr(String string, String string2) {
        return string + "+" + string2;
    }

    public String sqlConcatStr(String string, String string2, String string3) {
        return string + "+" + string2 + "+" + string3;
    }

    public String sqlConcatStr(String[] stringArray) {
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + "+" + stringArray[i];
        }
        return string;
    }

    public String sqlFilterForClob(String string, String string2) {
        String string3 = string2.equals("?") ? "?" : "'%" + CMyString.filterForSQL(string2) + "%'";
        return " patindex(" + string3 + "," + string + ")>0 ";
    }

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        DataType dataType = this.getDataType(string3);
        if (dataType == null) {
            return null;
        }
        String string5 = string3;
        int n3 = n;
        switch (dataType.getType()) {
            case 2: 
            case 4: {
                string5 = "INT";
                n3 = dataType.getMaxLength();
                break;
            }
            case 6: {
                string5 = "FLOAT";
                n3 = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                string5 = "DATETIME";
                break;
            }
            case 12: {
                string5 = "NVARCHAR";
            }
        }
        String string6 = "ALTER TABLE " + string + " ADD " + string2 + " " + string5;
        if (dataType.isLengthDefinedByUser()) {
            string6 = n2 > 0 ? string6 + "(" + n3 + ", " + n2 + ")" : string6 + "(" + n3 + ")";
        }
        string6 = string6 + " NULL";
        return string6;
    }

    public String sqlGetSysDate() {
        return "GETDATE()";
    }

    public String sqlFilterOneDay(String string, String string2, String string3) {
        return "DateDiff(day," + string + ",'" + string2 + "')=0";
    }

    public String sqlDateTime(String string, String string2) {
        return "'" + string + "'";
    }

    public String sqlDate(String string) {
        return "'" + string + "'";
    }

    public String sqlDateField(String string) {
        return string;
    }

    public String initQuerySQL(String string, int n, int n2) {
        return string;
    }

    public String sqlQueryTableInfos(String string) {
        String string2 = "SELECT *, NUMERIC_SCALE AS DATA_SCALE FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
        return string2;
    }

    public String getClob(ResultSet resultSet, boolean bl, int n) throws CMyException {
        return CSQLText.getText(resultSet, n);
    }

    public String getClob(ResultSet resultSet, boolean bl, String string) throws CMyException {
        return CSQLText.getText(resultSet, string);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String string4, String string5) throws CMyException {
        throw new CMyException(2, I18NMessage.get(SQLServerDB.class, "SQLServerDB.label1", "SQL Server\u4e0d\u9700\u8981\u8bbe\u7f6e\u5927\u5b57\u6bb5\uff01"));
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String[] stringArray) throws CMyException {
        throw new CMyException(2, I18NMessage.get(SQLServerDB.class, "SQLServerDB.label1", "SQL Server\u4e0d\u9700\u8981\u8bbe\u7f6e\u5927\u5b57\u6bb5\uff01"));
    }

    public String sqlGetNextId() {
        return "exec sp_getNextId ?,?,?";
    }

    public int getType() {
        return 2;
    }

    public String sqlQueryTableInfo(String string, String string2) {
        String string3 = "SELECT *, NUMERIC_SCALE AS DATA_SCALE FROM WCM_ViewCOLUMNS WHERE TABLE_NAME='" + CMyString.filterForSQL(string2) + "'  ORDER BY TABLE_NAME, COLUMN_ID";
        return string3;
    }

    public boolean canDropField() {
        return true;
    }

    public String sqlRenameTable(String string, String string2) {
        return "exec sp_rename '" + CMyString.filterForSQL(string) + "','" + CMyString.filterForSQL(string2) + "';";
    }

    public String sqlRenameField(String string, String string2, String string3) {
        return "exec sp_rename '" + string + "." + CMyString.filterForSQL(string2) + "','" + CMyString.filterForSQL(string3) + "', 'COLUMN';";
    }

    protected String keywordsModifyField() {
        return "alter column";
    }
}

