/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.COracleCLOB;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.CLOB;

public class OracleDB
extends DBType {
    public static final DataType CHAR = new DataType("CHAR", 1, -4000);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 12, -4000);
    public static final DataType NUMBER = new DataType("NUMBER", 2, -38);
    public static final DataType INT = new DataType("INT", 4, -9);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, -2);
    public static final DataType FLOAT = new DataType("FLOAT", 6, -38);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType LONG = new DataType("LONG", -1);
    public static final DataType ROWID = new DataType("ROWID", -2);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    public static final DataType DATETIME = new DataType("DATETIME", 93);
    public static final DataType RAW = new DataType("RAW", -3);
    public static final DataType LONGRAW = new DataType("LONGRAW", -4);
    public static final DataType CLOB = new DataType("CLOB", 2005);
    public static final DataType BLOB = new DataType("BLOB", 2004);
    public static final DataType NCLOB = new DataType("NCLOB", 2005);
    public static final DataType BFILE = new DataType("BFILE", -4);
    private static final DataType[] m_allDataTypes = new DataType[]{CHAR, VARCHAR2, NUMBER, LONG, ROWID, DATE, RAW, LONGRAW, CLOB, BLOB, NCLOB, BFILE, INT, FLOAT, DATETIME, NVARCHAR, SMALLINT};
    static final DataType[] m_supportedDataTypes = new DataType[]{NUMBER, VARCHAR2, CLOB, DATE};

    public OracleDB() {
        super("Oracle", "oracle.jdbc.driver.OracleDriver", true);
    }

    public OracleDB(String string, String string2) {
        super(string, string2, true);
    }

    protected void registerDBInfo() {
        this.registerColumnType(93, "date");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 4000, "varchar2($l)");
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(1, "char(1 char)");
        this.registerColumnType(12, 4000, "varchar2($l char)");
        this.registerColumnType(12, "long");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "date");
        this.registerColumnType(-3, 2000, "raw($l)");
        this.registerColumnType(-3, "long raw");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
    }

    public String encodeStrToWrite(String string) {
        return string;
    }

    public boolean canWriteTextDirectly() {
        return false;
    }

    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    public String sqlConcatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    public String sqlConcatStr(String string, String string2, String string3) {
        return "CONCAT(CONCAT(" + string + "," + string2 + ")," + string3 + ")";
    }

    public String sqlConcatStr(String[] stringArray) {
        String string = "CONCAT(" + stringArray[0] + "," + stringArray[1] + ")";
        for (int i = 2; i < stringArray.length; ++i) {
            string = "CONCAT(" + string + "," + stringArray[i] + ")";
        }
        return string;
    }

    public String sqlFilterForClob(String string, String string2) {
        String string3 = string2.equals("?") ? "?" : "'" + CMyString.filterForSQL(string2) + "'";
        return " dbms_lob.instr(" + string + "," + string3 + ", 1, 1)>0 ";
    }

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        DataType dataType = this.getDataType(string3);
        if (dataType == null) {
            return null;
        }
        String string5 = string3;
        int n3 = n;
        boolean bl2 = false;
        switch (dataType.getType()) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string5 = "NUMBER";
                n3 = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                string5 = "DATE";
                break;
            }
            case 12: {
                string5 = "VARCHAR2";
                bl2 = true;
                break;
            }
        }
        String string6 = "ALTER TABLE " + string + " ADD( " + string2 + " " + string5;
        if (dataType.isLengthDefinedByUser()) {
            if (bl2 && (n3 *= 2) > 4000) {
                n3 = 4000;
            }
            string6 = n2 > 0 ? string6 + "(" + n3 + ", " + n2 + ")" : string6 + "(" + n3 + ")";
        }
        string6 = string6 + " NULL";
        return string6 + ")";
    }

    public String sqlRenameTable(String string, String string2) {
        return "ALTER TABLE " + CMyString.filterForSQL(string) + " rename to " + CMyString.filterForSQL(string2);
    }

    public String sqlRenameField(String string, String string2, String string3) {
        return "ALTER TABLE " + CMyString.filterForSQL(string) + " rename column " + string2 + " to " + string3;
    }

    protected String keywordsModifyField() {
        return "modify";
    }

    public String sqlGetSysDate() {
        return "SYSDATE";
    }

    public String sqlFilterOneDay(String string, String string2, String string3) {
        return string + " like to_date('" + string2 + "','" + string3 + "')";
    }

    public String sqlDateTime(String string, String string2) {
        return "to_date('" + string + "','" + string2 + "')";
    }

    public String sqlDate(String string) {
        return this.sqlDateTime(string, "yyyy-MM-dd HH24:MI:SS");
    }

    public String sqlDateField(String string) {
        return string;
    }

    public String initQuerySQL(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 != 9999) {
            stringBuffer.append("select * from (select my_table.*,rownum as my_rownum from(").append(string).append(") my_table where rownum<").append(n + n2).append(") where my_rownum>=").append(n);
        } else {
            stringBuffer.append("select * from (select my_table.*,rownum as my_rownum from(").append(string).append(") my_table ").append(") where my_rownum>=").append(n);
        }
        return stringBuffer.toString();
    }

    public String sqlQueryTableInfos(String string) {
        String string2 = "SELECT * FROM ALL_TAB_COLUMNS WHERE OWNER='" + string.toUpperCase() + "' ORDER BY TABLE_NAME,COLUMN_ID";
        return string2;
    }

    public String sqlQueryTableInfo(String string, String string2) {
        String string3 = "SELECT * FROM ALL_TAB_COLUMNS WHERE OWNER='" + string.toUpperCase() + "' AND TABLE_NAME='" + string2.toUpperCase() + "' ORDER BY TABLE_NAME,COLUMN_ID";
        return string3;
    }

    public String getClob(ResultSet resultSet, boolean bl, int n) throws CMyException {
        return COracleCLOB.getClob(resultSet, bl, n);
    }

    public String getClob(ResultSet resultSet, boolean bl, String string) throws CMyException {
        return COracleCLOB.getClob(resultSet, bl, string);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String string4, String string5) throws CMyException {
        return COracleCLOB.setClob(connection, string, string2, string3, string4, string5);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String[] stringArray) throws CMyException {
        return COracleCLOB.setClob(connection, string, string2, string3, stringArray);
    }

    public String sqlGetNextId() {
        return "{call sp_getNextId(?,?,?)}";
    }

    public int getType() {
        return 1;
    }

    public void setStringFieldValue(PreparedStatement preparedStatement, int n, String string) throws Exception {
        if (string == null || string.length() <= 300) {
            preparedStatement.setString(n, string);
            return;
        }
        StringReader stringReader = new StringReader(string);
        preparedStatement.setCharacterStream(n, (Reader)stringReader, string.length());
    }

    public boolean canDropField() {
        return true;
    }

    public boolean setClob(Connection connection, String string, String string2, int n, String string3, String string4) throws CMyException {
        if (string4 == null) {
            return true;
        }
        return this.setClob(connection, string, string2, n, new String[]{string3, string4});
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean setClob(Connection connection, String string, String string2, int n, String[] stringArray) throws CMyException {
        Exception exception2;
        boolean bl;
        OracleResultSet oracleResultSet;
        PreparedStatement preparedStatement;
        block22: {
            int n2 = stringArray.length;
            if ((n2 & 1) != 0) {
                throw new CMyException(10, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label6", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(COracleCLOB.setClob)"));
            }
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("select ").append(string2.toUpperCase());
            for (int i = 0; i < n2; i += 2) {
                stringBuffer.append(',').append(stringArray[i].toUpperCase());
            }
            stringBuffer.append(" from ").append(string.toUpperCase());
            stringBuffer.append(" where ").append(string2).append("=? for update");
            preparedStatement = null;
            oracleResultSet = null;
            boolean bl2 = false;
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, n);
            oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
            bl2 = oracleResultSet.next();
            if (bl2) {
                bl = 2 != 0;
                int n3 = 1;
                while (n3 < n2) {
                    String string3 = stringArray[n3];
                    if (string3 != null) {
                        CLOB cLOB = oracleResultSet.getCLOB(bl ? 1 : 0);
                        Writer writer = cLOB.getCharacterOutputStream();
                        writer.write(string3);
                        writer.close();
                    }
                    n3 += 2;
                    bl += 1;
                }
            }
            oracleResultSet.close();
            oracleResultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            connection.commit();
            bl = bl2;
            Object var17_19 = null;
            if (oracleResultSet == null) break block22;
            try {
                oracleResultSet.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        try {
            connection.setAutoCommit(true);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        {
            return bl;
            catch (SQLException sQLException) {
                throw new CMyException(40, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), sQLException);
            }
            catch (Exception exception3) {
                throw new CMyException(0, I18NMessage.get(COracleCLOB.class, "COracleCLOB.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), exception3);
            }
        }
        catch (Throwable throwable) {
            Exception exception42;
            Object var17_20 = null;
            if (oracleResultSet != null) {
                try {
                    oracleResultSet.close();
                }
                catch (Exception exception42) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception42) {
                    // empty catch block
                }
            }
            try {
                connection.setAutoCommit(true);
            }
            catch (Exception exception42) {}
            throw throwable;
        }
    }
}

