/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.TypeNames;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;

public abstract class DBType {
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_PRECISION = 19;
    public static final int DEFAULT_SCALE = 2;
    private String sName;
    private String sDriverClass;
    private boolean bSupportStoredProc;
    private Hashtable hDataTypes;
    private final TypeNames typeNames = new TypeNames();
    public static final int MAX_PAGE_SIZE = 9999;
    public static final DataType OTHER = new DataType("", 1111);

    public DBType(String string, String string2, boolean bl) {
        this.sName = string;
        this.sDriverClass = string2;
        this.bSupportStoredProc = bl;
        DataType[] dataTypeArray = this.getAllDataTypes();
        this.hDataTypes = new Hashtable(dataTypeArray.length);
        for (int i = 0; i < dataTypeArray.length; ++i) {
            this.hDataTypes.put(dataTypeArray[i].getName(), dataTypeArray[i]);
        }
        this.registerDBInfo();
    }

    protected void registerDBInfo() {
    }

    public String getName() {
        return this.sName;
    }

    public String getDriverClass() {
        return this.sDriverClass;
    }

    public DBType setDriverClass(String string) {
        this.sDriverClass = string;
        return this;
    }

    public boolean isSupportStoredProc() {
        return this.bSupportStoredProc;
    }

    public abstract String encodeStrToWrite(String var1);

    public abstract boolean canWriteTextDirectly();

    public abstract DataType[] getAllDataTypes();

    public abstract DataType[] getSupportedDataTypes();

    public DataType getDataType(String string) {
        if (string == null) {
            return null;
        }
        DataType dataType = (DataType)this.hDataTypes.get(string.toUpperCase());
        return dataType == null ? OTHER : dataType;
    }

    protected void registerColumnType(int n, int n2, String string) {
        this.typeNames.put(n, n2, string);
    }

    protected void registerColumnType(int n, String string) {
        this.typeNames.put(n, string);
    }

    public String getTypeName(int n) throws WCMException {
        String string = this.typeNames.get(n);
        if (string == null) {
            throw new WCMException("No default type mapping for (java.sql.Types) " + n);
        }
        return string;
    }

    public String getTypeName(int n, int n2, int n3, int n4) throws WCMException {
        String string = this.typeNames.get(n, n2, n3, n4);
        if (string == null) {
            throw new WCMException("No type mapping for java.sql.Types code: " + n + ", length: " + n2);
        }
        return string;
    }

    public String getCastTypeName(int n) throws WCMException {
        return this.getTypeName(n, 255, 19, 2);
    }

    public String sqlCreateTable() {
        return "create table";
    }

    public abstract String sqlConcatStr(String var1, String var2);

    public abstract String sqlConcatStr(String var1, String var2, String var3);

    public abstract String sqlConcatStr(String[] var1);

    public String sqlEscapeString(String string) {
        if (string == null) {
            return "NULL";
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        stringBuffer.append('\'');
        while ((n2 = string.indexOf(39, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2 + 1)).append('\'');
            n = n2 + 1;
        }
        stringBuffer.append(string.substring(n)).append('\'');
        return stringBuffer.toString();
    }

    public abstract String sqlFilterForClob(String var1, String var2);

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl) {
        return this.sqlAddField(string, string2, string3, n, bl, null, 0);
    }

    public abstract String sqlAddField(String var1, String var2, String var3, int var4, boolean var5, String var6, int var7);

    public String sqlAddField(String string, String string2, int n, int n2, boolean bl, String string3, int n3) throws WCMException {
        String string4 = "ALTER TABLE " + string + " ADD " + string2 + " " + this.getTypeName(n, n2, n2, n3);
        string4 = string4 + " NULL";
        return string4;
    }

    public String sqlModifyField(String string, String string2, int n, int n2, boolean bl, int n3) throws WCMException {
        String string3 = "ALTER TABLE " + string + " " + this.keywordsModifyField() + " " + string2 + " " + this.getTypeName(n, n2, n2, n3);
        return string3;
    }

    protected String keywordsModifyField() throws WCMException {
        throw new WCMException(this.getClass().getName() + I18NMessage.get(DBType.class, "DBType.label1", "\u4e0d\u652f\u6301\u5217\u5c5e\u6027\u7684\u4fee\u6539!"));
    }

    public String sqlCreateTableWithPrimary(String string, String string2) throws WCMException {
        return this.sqlCreateTable() + " " + string + "(\n" + "     " + string2 + " " + this.getTypeName(4) + " Primary Key\n" + ")";
    }

    public String sqlRenameTable(String string, String string2) throws WCMException {
        throw new WCMException(I18NMessage.get(DBType.class, "DBType.label2", "\u5c06\u8868[") + string + I18NMessage.get(DBType.class, "DBType.label3", "]\u91cd\u547d\u540d\u4e3a[") + string2 + I18NMessage.get(DBType.class, "DBType.label4", "]\u5931\u8d25\uff01\n\u56e0\u4e3a") + this.getClass().getName() + I18NMessage.get(DBType.class, "DBType.label5", "\u6ca1\u6709\u5b9e\u73b0\u8868\u7684\u91cd\u547d\u540d\uff01"));
    }

    public String sqlRenameField(String string, String string2, String string3) throws WCMException {
        throw new WCMException(I18NMessage.get(DBType.class, "DBType.label2", "\u5c06\u8868[") + string + I18NMessage.get(DBType.class, "DBType.label6", "]\u7684\u5b57\u6bb5[") + string2 + I18NMessage.get(DBType.class, "DBType.label3", "]\u91cd\u547d\u540d\u4e3a[") + string3 + I18NMessage.get(DBType.class, "DBType.label4", "]\u5931\u8d25\uff01\n\u56e0\u4e3a") + this.getClass().getName() + I18NMessage.get(DBType.class, "DBType.label7", "\u6ca1\u6709\u5b9e\u73b0\u5b57\u6bb5\u7684\u91cd\u547d\u540d\uff01"));
    }

    public String sqlDropField(String string, String string2) throws Exception {
        return "ALTER TABLE " + string + " DROP COLUMN " + string2;
    }

    public String sqlDropTable(String string) throws Exception {
        return "Drop TABLE " + string;
    }

    public abstract String sqlGetSysDate();

    public abstract String sqlFilterOneDay(String var1, String var2, String var3);

    public abstract String sqlDateTime(String var1, String var2);

    public abstract String sqlDate(String var1);

    public abstract String sqlDateField(String var1);

    public abstract String initQuerySQL(String var1, int var2, int var3);

    public abstract String sqlQueryTableInfos(String var1);

    public abstract String sqlQueryTableInfo(String var1, String var2);

    public abstract String sqlGetNextId();

    public abstract String getClob(ResultSet var1, boolean var2, int var3) throws CMyException;

    public abstract String getClob(ResultSet var1, boolean var2, String var3) throws CMyException;

    public abstract boolean setClob(Connection var1, String var2, String var3, String var4, String var5, String var6) throws CMyException;

    public abstract boolean setClob(Connection var1, String var2, String var3, String var4, String[] var5) throws CMyException;

    public abstract int getType();

    public void setStringFieldValue(PreparedStatement preparedStatement, int n, String string) throws Exception {
        preparedStatement.setString(n, string);
    }

    public void setStringFieldValue(PreparedStatement preparedStatement, int n, String string, boolean bl) throws Exception {
        this.setStringFieldValue(preparedStatement, n, string);
    }

    public abstract boolean canDropField();

    public boolean setClob(Connection connection, String string, String string2, int n, String string3, String string4) throws CMyException {
        return this.setClob(connection, string, string2 + "=" + n, string2, string3, string4);
    }

    public boolean setClob(Connection connection, String string, String string2, int n, String[] stringArray) throws CMyException {
        return this.setClob(connection, string, string2 + "=" + n, string2, stringArray);
    }
}

