/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.ClusterDBIdManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBIdManager {
    private static Logger logger = Logger.getLogger(DBIdManager.class);
    public static boolean ISDEBUG = false;
    private Hashtable hBuffer = new Hashtable(50);
    private String sqlGetNextId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DBIdManager load(Connection connection, String string) throws WCMException {
        String string2 = "select TABLENAME,IDFIELDNAME from WCMID where NEXTID=0";
        Statement statement = null;
        ResultSet resultSet = null;
        Statement statement2 = null;
        try {
            statement = connection.createStatement();
            this.removeInvalidData(statement);
            resultSet = statement.executeQuery(string2);
            HashMap<String, String> hashMap = new HashMap<String, String>(20, 1.0f);
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(1), resultSet.getString(2));
            }
            resultSet.close();
            if (hashMap.isEmpty()) {
                DBIdManager dBIdManager = this;
                return dBIdManager;
            }
            string2 = "update WCMID set NEXTID=? where TABLENAME=? and NEXTID=0";
            statement2 = connection.prepareStatement(string2);
            Iterator iterator = hashMap.entrySet().iterator();
            StringBuffer stringBuffer = new StringBuffer(256);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                stringBuffer.setLength(0);
                stringBuffer.append("select max(");
                stringBuffer.append(CMyString.filterForSQL2((String)entry.getValue()));
                stringBuffer.append(")+1 from ");
                stringBuffer.append(CMyString.filterForSQL2(string3));
                int n = 0;
                try {
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    if (n == 0) {
                        n = 1;
                    }
                }
                catch (SQLException sQLException) {
                    if (logger.isDebugEnabled()) {
                        logger.fatal((Object)"warn:", (Throwable)sQLException);
                    } else {
                        logger.fatal((Object)("warn: execute sql failed." + stringBuffer));
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                statement2.setInt(1, n);
                statement2.setString(2, string3);
                statement2.executeUpdate();
            }
            hashMap.clear();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(DBIdManager.class, "DBIdManager.label1", "\u83b7\u53d6\u6570\u636e\u8868ID\u503c\u4fe1\u606f\u5931\u8d25\uff08DBIdManager.load\uff09"), exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement2 != null) {
                try {
                    statement2.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    private void removeInvalidData(Statement statement) throws SQLException {
        String string = "delete from WCMID where tablename='WCMID' or IDFIELDNAME is null";
        statement.executeUpdate(string);
    }

    private int refreshIdSeqFromDB(IdSeq idSeq, Connection connection, String string, String string2) throws WCMException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            string3 = "select MAX(" + string2 + ") from " + string;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            int n = resultSet.next() ? resultSet.getInt(1) + 1 : 1;
            resultSet.close();
            resultSet = null;
            if (idSeq == null) {
                idSeq = new IdSeq();
                idSeq.setNextId(n);
                this.hBuffer.put(string, idSeq);
                string3 = "insert into WCMID(TABLENAME,NEXTID,CACHESIZE) values('" + string + "'," + (idSeq.getMaxId() + 1) + "," + idSeq.getCacheSize() + ")";
            } else {
                idSeq.setNextId(n);
                string3 = "update WCMID set NEXTID=" + (idSeq.getMaxId() + 1) + " where TABLENAME='" + string + "'";
            }
            statement.executeUpdate(string3);
            int n2 = idSeq.getNextId();
            return n2;
        }
        catch (Exception exception) {
            logger.error((Object)"==============strSQL============");
            logger.error(string3);
            logger.error((Object)"==============hBuffer============");
            logger.error((Object)this.hBuffer);
            throw new WCMException(1100, I18NMessage.get(DBIdManager.class, "DBIdManager.label2", "\u4e3a\u6570\u636e\u8868") + string + I18NMessage.get(DBIdManager.class, "DBIdManager.label3", "\u66f4\u65b0ID\u4fe1\u606f\u8bb0\u5f55\u65f6\u5931\u8d25\uff08DBIdManager.refreshIdSeqFromDB\uff09"), exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private int getNextIdFromDB(IdSeq idSeq, Connection connection, String string) throws WCMException {
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        try {
            int n;
            if (this.sqlGetNextId != null) {
                statement = connection.prepareCall(this.sqlGetNextId);
                statement.setString(1, string);
                statement.setInt(2, idSeq.getCacheSize());
                statement.registerOutParameter(3, 4);
                statement.executeUpdate();
                n = statement.getInt(3);
            } else {
                String string2 = "select NEXTID from WCMID where TABLENAME='" + string + "'";
                statement2 = connection.createStatement();
                resultSet = statement2.executeQuery(string2);
                resultSet.next();
                n = resultSet.getInt(1);
                resultSet.close();
                resultSet = null;
                string2 = "update WCMID set NEXTID=NEXTID+" + idSeq.getCacheSize() + " where TABLENAME='" + string + "'";
                statement2.executeUpdate(string2);
            }
            idSeq.setNextId(n);
            int n2 = idSeq.getNextId();
            return n2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(DBIdManager.class, "DBIdManager.label4", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u8868") + string + I18NMessage.get(DBIdManager.class, "DBIdManager.label5", "\u7684\u4e0b\u4e00\u4e2aID\u503c\u65f6\u5931\u8d25\uff08DBIdManager.getNextIdFromDB\uff09"), exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (statement2 != null) {
                try {
                    statement2.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public synchronized int getNextId(BaseObj baseObj, Connection connection, boolean bl) throws WCMException {
        if (baseObj == null) {
            throw new WCMException(10, I18NMessage.get(DBIdManager.class, "DBIdManager.label6", "\u65e0\u6548\u53c2\u6570:WCMObj\u5bf9\u8c61\u4e3a\u7a7a\uff08DBIdManager.getNextId\uff09"));
        }
        String string = baseObj.getDbTableName();
        return this.getNextId(string, baseObj.getIdFieldName(), connection, bl);
    }

    public int getNextId(String string, String string2, Connection connection, boolean bl) throws WCMException {
        return ClusterDBIdManager.getNextId(string, string2);
    }

    public class IdSeq {
        public static final int CACHESIZE_DEFAULT = 5;
        private int nextId;
        private int maxId = 0;
        private int cacheSize = 5;

        public IdSeq() {
            this(0, 0);
        }

        public IdSeq(int n) {
            this(n, 0);
        }

        public IdSeq(int n, int n2) {
            this.setCacheSize(n2);
            this.nextId = n;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public IdSeq setCacheSize(int n) {
            this.cacheSize = n < 1 ? 1 : n;
            return this;
        }

        public int getMaxId() {
            return this.maxId;
        }

        public synchronized int getNextId() {
            if (ISDEBUG) {
                System.out.print("\n NextId=" + this.nextId + " MaxId=" + this.maxId);
            }
            if (this.nextId < 1) {
                return 0;
            }
            if (this.nextId <= this.maxId) {
                return this.nextId++;
            }
            return -1;
        }

        public synchronized IdSeq setNextId(int n) {
            if (this.nextId >= this.maxId && n > this.maxId) {
                this.nextId = n;
                this.maxId = this.nextId + this.cacheSize - 1;
            }
            return this;
        }
    }
}

