/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDB2DBCLOB;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.sql.Connection;
import java.sql.ResultSet;

public class DB2UDB
extends DBType {
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INT = new DataType("INTEGER", 4, 4);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType REAL = new DataType("REAL", 7, 4);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType CHAR = new DataType("CHAR", 1, -254);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -32672);
    public static final DataType CLOB = new DataType("CLOB", -1, 16);
    public static final DataType DBCLOB = new DataType("DBCLOB", -1, 16);
    public static final DataType BLOB = new DataType("BLOB", -4, 16);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    public static final DataType TIME = new DataType("TIME", 93, 8);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType UNIQUEIDENTIFIER = new DataType("UNIQUEIDENTIFIER", -5, 16);
    public static final DataType SQL_VARIRANT = new DataType("SQL_VARIRANT", -3);
    static final DataType[] m_allDataTypes = new DataType[]{SMALLINT, INT, BIGINT, DECIMAL, REAL, FLOAT, CHAR, VARCHAR, CLOB, DBCLOB, BLOB, DATE, TIME, TIMESTAMP};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, INT, DECIMAL, VARCHAR, CLOB, TIMESTAMP};

    public DB2UDB() {
        super("DB2 Universal Database", "COM.ibm.db2.jdbc.app.DB2Driver", false);
    }

    public DB2UDB(String string, String string2, boolean bl) {
        super(string, string2, false);
    }

    protected void registerDBInfo() {
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "clob($l)");
    }

    public String sqlFilterForClob(String string, String string2) {
        return "";
    }

    public String sqlConcatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    public String sqlAddField(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        String string5 = "ALTER TABLE " + string + " ADD " + string2 + " " + string3;
        DataType dataType = this.getDataType(string3);
        if (dataType == null) {
            return null;
        }
        if (dataType.isLengthDefinedByUser()) {
            string5 = n2 > 0 ? string5 + "(" + n + ", " + n2 + ")" : string5 + "(" + n + ")";
        }
        if (!bl) {
            string5 = string5 + " NOT NULL ";
            if (string4 != null) {
                string5 = string5 + " DEFAULT ";
                string5 = dataType.isCharData() ? string5 + "'" + CMyString.filterForSQL(string4) + "'" : string5 + string4;
            }
        }
        return string5;
    }

    public String sqlConcatStr(String[] stringArray) {
        String string = "CONCAT(" + stringArray[0] + "," + stringArray[1] + ")";
        for (int i = 2; i < stringArray.length; ++i) {
            string = "CONCAT(" + string + "," + stringArray[i] + ")";
        }
        return string;
    }

    public boolean canWriteTextDirectly() {
        return false;
    }

    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    public String sqlFilterOneDay(String string, String string2, String string3) {
        return "(DATE(" + string + ")-DATE('" + string2 + "'))=0";
    }

    public String sqlDateTime(String string, String string2) {
        if (string2.equalsIgnoreCase("YYYY-MM-DD")) {
            return "TIMESTAMP('" + string + " 00:00:00')";
        }
        return "TIMESTAMP('" + string + "')";
    }

    public String sqlDate(String string) {
        return this.sqlDateTime(string, "yyyy-MM-dd HH:mm:ss");
    }

    public String sqlDateField(String string) {
        return "DATE(" + string + ")";
    }

    public String sqlConcatStr(String string, String string2, String string3) {
        return "CONCAT(CONCAT(" + string + "," + string2 + ")," + string3 + ")";
    }

    public String sqlGetSysDate() {
        return "(CURRENT TIMESTAMP)";
    }

    public String sqlDropField(String string, String string2) throws Exception {
        throw new Exception(I18NMessage.get(DB2UDB.class, "DB2UDB.label1", "DB2 Universal Database 7.2\u7248\u672c\u4e0d\u652f\u6301\u5b57\u6bb5\u5220\u9664\uff01"));
    }

    public String encodeStrToWrite(String string) {
        return string;
    }

    public static void main(String[] stringArray) {
    }

    public String initQuerySQL(String string, int n, int n2) {
        return string;
    }

    public String sqlQueryTableInfos(String string) {
        String string2 = "SELECT c.tbname AS TABLE_NAME,c.colno AS COLUMN_ID,c.name AS COLUMN_NAME,c.typename AS DATA_TYPE,c.longlength AS DATA_LENGTH, c.nulls AS NULLABLE,c.default AS DATA_DEFAULT,c.scale AS DATA_SCALE FROM sysibm.syscolumns c where c.tbcreator='" + string.toUpperCase() + "' ORDER BY TABLE_NAME, COLUMN_ID";
        return string2;
    }

    public String sqlQueryTableInfo(String string, String string2) {
        String string3 = "SELECT c.tbname AS TABLE_NAME,c.colno AS COLUMN_ID,c.name AS COLUMN_NAME,c.typename AS DATA_TYPE,c.longlength AS DATA_LENGTH, c.nulls AS NULLABLE,c.default AS DATA_DEFAULT,c.scale AS DATA_SCALE FROM sysibm.syscolumns c WHERE c.tbcreator='" + string.toUpperCase() + "' AND c.tbname='" + string2.toUpperCase() + "' ORDER BY TABLE_NAME, COLUMN_ID";
        return string3;
    }

    public String getClob(ResultSet resultSet, boolean bl, int n) throws CMyException {
        return CDB2DBCLOB.getClob(resultSet, n);
    }

    public String getClob(ResultSet resultSet, boolean bl, String string) throws CMyException {
        return CDB2DBCLOB.getClob(resultSet, string);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String string4, String string5) throws CMyException {
        return CDB2DBCLOB.setClob(connection, string, string2, string3, string4, string5);
    }

    public boolean setClob(Connection connection, String string, String string2, String string3, String[] stringArray) throws CMyException {
        return CDB2DBCLOB.setClob(connection, string, string2, string3, stringArray);
    }

    public String sqlGetNextId() {
        return null;
    }

    public int getType() {
        return 3;
    }

    public boolean canDropField() {
        return false;
    }
}

