/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DBTypes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;

public class CDBText
implements Serializable {
    public static final boolean JDBC_IS2 = false;
    private String m_sText = null;
    private transient DBType m_oDBType;
    private boolean m_bLoaded = false;

    public CDBText(int n) {
        this.setDBType(DBTypes.getDBType(n));
    }

    public CDBText(int n, String string) {
        this.setDBType(DBTypes.getDBType(n));
        this.setText(string);
    }

    public CDBText(DBType dBType, String string) {
        this.setDBType(dBType);
        this.setText(string);
    }

    public CDBText(DBType dBType) {
        this.setDBType(dBType);
    }

    public DBType getDBType() {
        return this.m_oDBType;
    }

    public boolean isLoaded() {
        return this.m_bLoaded;
    }

    public String getText() {
        return this.m_sText;
    }

    public void setText(String string) {
        this.m_sText = string;
        this.m_bLoaded = true;
    }

    public boolean isNull() {
        return this.m_sText == null;
    }

    public int getLength() {
        return this.m_sText == null ? 0 : this.m_sText.length();
    }

    public String toString() {
        return this.getText() == null ? "" : this.getText();
    }

    public void readFromRs(ResultSet resultSet, String string) throws CMyException {
        this.setText(this.getDBType().getClob(resultSet, false, string));
    }

    public void readFromRs(ResultSet resultSet, int n) throws CMyException {
        this.setText(this.getDBType().getClob(resultSet, false, n));
    }

    public boolean updateToDB(Connection connection, String string, String string2, String string3, String string4) throws CMyException {
        return this.getDBType().setClob(connection, string, string2, string3, string4, this.getText());
    }

    public void setDBType(DBType dBType) {
        this.m_oDBType = dBType;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CDBText)) {
            return false;
        }
        String string = ((CDBText)object).getText();
        if (string == null) {
            return this.m_sText == null;
        }
        return string.equals(this.m_sText);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.m_oDBType.getType());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setDBType(DBTypes.getDBType(objectInputStream.readInt()));
    }
}

