/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.io.UnsupportedEncodingException;

public final class URLCoder {
    private static boolean[] dontNeed;
    private static String encoding;
    private static char[] hexDigit;

    public static final String decode(String string) {
        if (string != null) {
            byte[] byArray = new byte[string.length()];
            int n = URLCoder.decode(string, byArray);
            try {
                return new String(byArray, 0, n, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final int decode(String string, byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        block6: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    byArray[n3++] = 32;
                    continue block6;
                }
                case '%': {
                    try {
                        byArray[n3++] = URLCoder.hex2byte(string.charAt(n + 1), string.charAt(n + 2));
                        n += 2;
                        continue block6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block6;
                    }
                }
                default: {
                    byArray[n3++] = (byte)c;
                }
            }
        }
        return n3;
    }

    public static final String decode(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = new byte[string.length()];
        int n = URLCoder.decode(string, byArray);
        return new String(byArray, 0, n, string2);
    }

    private static final String encode(byte[] byArray) {
        int n = 0;
        char[] cArray = new char[3 * byArray.length + 1];
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i];
            if (dontNeed[n2 &= 0xFF]) {
                if (n2 == 32) {
                    n2 = 43;
                }
                cArray[n++] = (char)n2;
                continue;
            }
            cArray[n++] = 37;
            cArray[n++] = hexDigit[n2 >> 4 & 0xF];
            cArray[n++] = hexDigit[n2 & 0xF];
        }
        return new String(cArray, 0, n);
    }

    public static final String encode(String string) {
        if (string != null) {
            try {
                return URLCoder.encode(string.getBytes(encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final String encode(String string, String string2) throws UnsupportedEncodingException {
        return URLCoder.encode(string.getBytes(string2));
    }

    private static final byte hex2byte(char c, char c2) {
        int n;
        int n2 = c - 48;
        if (n2 >= 10) {
            n2 -= 7;
        }
        if ((n = c2 - 48) >= 10) {
            n -= 7;
        }
        return (byte)(n2 << 4 | n);
    }

    private static final void init() {
        int n;
        hexDigit = new char[16];
        URLCoder.hexDigit[0] = 48;
        URLCoder.hexDigit[1] = 49;
        URLCoder.hexDigit[2] = 50;
        URLCoder.hexDigit[3] = 51;
        URLCoder.hexDigit[4] = 52;
        URLCoder.hexDigit[5] = 53;
        URLCoder.hexDigit[6] = 54;
        URLCoder.hexDigit[7] = 55;
        URLCoder.hexDigit[8] = 56;
        URLCoder.hexDigit[9] = 57;
        URLCoder.hexDigit[10] = 65;
        URLCoder.hexDigit[11] = 66;
        URLCoder.hexDigit[12] = 67;
        URLCoder.hexDigit[13] = 68;
        URLCoder.hexDigit[14] = 69;
        URLCoder.hexDigit[15] = 70;
        encoding = null;
        String string = null;
        string = System.getProperty("trs.url.encoding");
        if (URLCoder.testEncoding(string)) {
            encoding = string;
        }
        if (URLCoder.testEncoding(string = System.getProperty("file.encoding"))) {
            encoding = string;
        }
        if (URLCoder.testEncoding(string = "GBK")) {
            encoding = string;
        }
        if (encoding == null) {
            encoding = "ASCII";
        }
        dontNeed = new boolean[256];
        for (n = 0; n < 256; ++n) {
            URLCoder.dontNeed[n] = false;
        }
        for (n = 97; n <= 122; ++n) {
            URLCoder.dontNeed[n] = true;
        }
        for (n = 65; n <= 90; ++n) {
            URLCoder.dontNeed[n] = true;
        }
        for (n = 48; n <= 57; ++n) {
            URLCoder.dontNeed[n] = true;
        }
        URLCoder.dontNeed[32] = true;
        URLCoder.dontNeed[45] = true;
        URLCoder.dontNeed[95] = true;
        URLCoder.dontNeed[46] = true;
        URLCoder.dontNeed[42] = true;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-e")) {
                encoding = stringArray[++i];
                continue;
            }
            if (string.equals("-d")) {
                System.out.println(URLCoder.decode(stringArray[++i]));
                continue;
            }
            System.out.println(URLCoder.encode(string));
        }
    }

    private static final boolean testEncoding(String string) {
        if (string != null) {
            try {
                "test".getBytes(string);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private URLCoder() {
    }

    static {
        URLCoder.init();
    }
}

