/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Logger;

public class ResponseBuddy {
    private static final String DEFAULT_CHARSET_XML = "UTF-8";
    private static final String DEFAULT_CHARSET_HTML = "GBK";
    static final transient Logger mLogger = Logger.getLogger(ResponseBuddy.class);
    static final transient Pattern PATTERM_CONTENT_TYPE = Pattern.compile("(?i).*charset\\s*=\\s*([^\\s]+)");
    static final transient Pattern PATTHERN_HTML_CONTENT_TYPE = Pattern.compile("(?i)<\\s*meta\\s*http-equiv=\\s*[\"]?\\s*content-type\\s*[\"]?\\s*content=\\s*[\"]?\\s*text/html;\\s*charset\\s*=\\s*([^\"\\s]+)[\"]?\\s*>");
    static final transient Pattern PATTHERN_XML_CONTENT_TYPE = Pattern.compile("(?i)<\\?xml.*encoding\\s*=\\s*\"\\s*([^\\\"\\\\s]+)\\s*\"\\s*\\?>");
    int m_nStatusCode = 0;
    byte[] m_barrBody = null;
    String m_sContentType = null;
    String m_sCharset = null;
    Map m_mpHeaders = null;

    public ResponseBuddy(HttpMethod httpMethod) throws IOException {
        this.setHeaders(httpMethod.getResponseHeaders());
        this.setStatusCode(httpMethod.getStatusCode());
        this.setBody(httpMethod.getResponseBody());
        this.m_sContentType = this.getHeader("Content-Type");
    }

    public void init() {
    }

    public InputStream getBodyAsStream() {
        if (this.getStatusCode() > 400 || this.m_barrBody == null) {
            return null;
        }
        return new ByteArrayInputStream(this.m_barrBody);
    }

    public String getBodyAsString() {
        if (this.getStatusCode() > 400) {
            return null;
        }
        this.guessCharset();
        try {
            return new String(this.m_barrBody, this.m_sCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    private void guessCharset() {
        Matcher matcher;
        if (this.m_sCharset != null) {
            return;
        }
        if (this.getStatusCode() > 400) {
            this.m_sCharset = DEFAULT_CHARSET_HTML;
            return;
        }
        if (this.m_sContentType == null) {
            this.setContentType("text/HTML");
        }
        if ((matcher = PATTERM_CONTENT_TYPE.matcher(this.m_sContentType)).find()) {
            this.m_sCharset = matcher.group(1);
            mLogger.debug((Object)("charset in Content-Type:" + this.m_sCharset));
        }
        if (this.m_sCharset != null) {
            this.m_sCharset = this.m_sCharset.toUpperCase();
        } else if (this.m_sContentType.trim().startsWith("text") || this.m_sContentType.trim().startsWith("application/xml")) {
            String string = new String(this.m_barrBody);
            if (this.m_sContentType.trim().startsWith("text/html")) {
                matcher = PATTHERN_HTML_CONTENT_TYPE.matcher(string);
                if (matcher.find()) {
                    this.m_sCharset = matcher.group(1);
                    mLogger.debug((Object)("charset in HTML META Content-Type:" + this.m_sCharset));
                }
                if (this.m_sCharset == null) {
                    this.m_sCharset = DEFAULT_CHARSET_HTML;
                }
                this.m_sCharset = this.m_sCharset.toUpperCase();
            } else if (this.m_sContentType.trim().startsWith("application/xml") || this.m_sContentType.trim().startsWith("text/xml")) {
                matcher = PATTHERN_XML_CONTENT_TYPE.matcher(string);
                if (matcher.find()) {
                    this.m_sCharset = matcher.group(1);
                    mLogger.debug((Object)("charset in XML encoding:" + this.m_sCharset));
                }
                if (this.m_sCharset == null) {
                    this.m_sCharset = DEFAULT_CHARSET_XML;
                }
                this.m_sCharset = this.m_sCharset.toUpperCase();
            } else {
                this.m_sCharset = DEFAULT_CHARSET_HTML;
            }
            if (this.m_sCharset.equalsIgnoreCase("GB2312")) {
                this.m_sCharset = DEFAULT_CHARSET_HTML;
            }
        } else {
            this.m_sCharset = "";
        }
    }

    public void setBody(byte[] byArray) {
        this.m_barrBody = byArray;
    }

    public int getContentLength() {
        return Integer.parseInt(this.getHeader("Content-Length"));
    }

    public String getContentType() {
        return this.m_sContentType;
    }

    public void setContentType(String string) {
        this.m_sContentType = string;
    }

    public int getStatusCode() {
        return this.m_nStatusCode;
    }

    public void setStatusCode(int n) {
        this.m_nStatusCode = n;
    }

    public String getCharset() {
        this.guessCharset();
        return this.m_sCharset;
    }

    public Map getHeaders() {
        return this.m_mpHeaders;
    }

    public void setHeaders(Header[] headerArray) {
        this.m_mpHeaders = new HashMap();
        for (int i = 0; i < headerArray.length; ++i) {
            Header header = headerArray[i];
            String string = header.getName();
            String string2 = header.getValue();
            ArrayList<String> arrayList = (ArrayList<String>)this.m_mpHeaders.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                this.m_mpHeaders.put(string, arrayList);
            }
            arrayList.add(string2);
        }
    }

    public String getHeader(String string) {
        List list = (List)this.m_mpHeaders.get(string);
        if (list != null && !list.isEmpty()) {
            return (String)list.get(0);
        }
        return null;
    }
}

