/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.common.WCMException;
import java.util.Map;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static String getProperty(Map map, String string) {
        if (string == null) {
            return null;
        }
        return (String)map.get(string.toUpperCase());
    }

    public static String getPropertyTrim(Map map, String string) {
        String string2 = PropertiesUtil.getProperty(map, string);
        return string2 == null ? null : string2.trim();
    }

    public static String getRequiredProperty(Map map, String string) throws WCMException {
        String string2 = PropertiesUtil.getProperty(map, string);
        if (string2 == null || string2.length() == 0) {
            throw new WCMException(1106, "Property [" + string + "] required!");
        }
        return string2;
    }

    public static String getRequiredPropertyTrim(Map map, String string) throws WCMException {
        String string2 = PropertiesUtil.getPropertyTrim(map, string);
        if (string2 == null || string2.length() == 0) {
            throw new WCMException(1106, "Property [" + string + "] required!");
        }
        return string2;
    }

    public static int getIntProperty(Map map, String string, int n) throws WCMException {
        String string2 = PropertiesUtil.getPropertyTrim(map, string);
        if (string2 == null || string2.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new WCMException(2, "Value [" + string2 + "] of property [" + n + "] is not integer!", exception);
        }
    }

    public static boolean getBooleanProperty(Map map, String string, boolean bl) {
        String string2 = PropertiesUtil.getPropertyTrim(map, string);
        if (string2 == null || string2.length() == 0) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }
}

