/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class MySSLSocketFactory
implements ProtocolSocketFactory {
    private SSLContext sslcontext = null;

    private static SSLContext createEasySSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
            return sSLContext;
        }
        catch (Exception exception) {
            throw new HttpClientError(exception.toString());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = MySSLSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException {
        return this.createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(MySSLSocketFactory.class);
    }

    public int hashCode() {
        return MySSLSocketFactory.class.hashCode();
    }

    public static class MyX509TrustManager
    implements X509TrustManager {
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }
}

