/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.MySSLSocketFactory;
import com.trs.infra.util.ResponseBuddy;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;

public class HttpClientBuddy {
    public static final String DEFAULT_CONTENT_ENCODING = "UTF-8";
    public static final String SERVICE_REQEUST_ENCODING = "ISO-8859-1";
    protected static Logger logger = Logger.getLogger(HttpClientBuddy.class);
    private HttpClient m_oHttpClient = null;
    private String m_sEncoding = "";
    private String[][] m_arrRequestHeaders = null;

    public HttpClientBuddy() {
        this(DEFAULT_CONTENT_ENCODING);
    }

    public HttpClientBuddy(String string) {
        this.m_sEncoding = string;
        this.m_oHttpClient = new HttpClient();
    }

    public HttpClientBuddy(String string, String[][] stringArray) {
        this.m_sEncoding = string;
        this.m_oHttpClient = new HttpClient();
        this.m_arrRequestHeaders = stringArray;
    }

    public ResponseBuddy doPost(String string, String string2) throws CMyException {
        try {
            return this.doPost(string, string2.getBytes(this.m_sEncoding));
        }
        catch (Exception exception) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label1", "\u53d1\u9001\u8bf7\u6c42\u65f6\u51fa\u73b0\u5f02\u5e38"), exception);
        }
    }

    public ResponseBuddy updateFile(String string, byte[] byArray) throws CMyException {
        this.validUrl(string);
        PostMethod postMethod = new PostMethod(string);
        this.prepare((HttpMethod)postMethod);
        postMethod.setRequestHeader("Content-Type", "multipart/form-data");
        if (byArray != null) {
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(byArray);
            postMethod.setContentChunked(true);
            postMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
        }
        return this.renderResponse((HttpMethod)postMethod);
    }

    public ResponseBuddy updateFile(String string, File file) throws CMyException {
        this.validUrl(string);
        PostMethod postMethod = new PostMethod(string);
        this.prepare((HttpMethod)postMethod);
        postMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        try {
            Part[] partArray = new Part[]{new FilePart(file.getName(), file)};
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, postMethod.getParams()));
            this.m_oHttpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        }
        catch (Exception exception) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label2", "\u4e0a\u4f20\u6587\u4ef6\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38"), exception);
        }
        return this.renderResponse((HttpMethod)postMethod);
    }

    public ResponseBuddy doPost(String string, byte[] byArray) throws CMyException {
        this.validUrl(string);
        PostMethod postMethod = new PostMethod(string);
        this.prepare((HttpMethod)postMethod);
        if (byArray != null) {
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(byArray);
            postMethod.setContentChunked(true);
            postMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
        }
        return this.renderResponse((HttpMethod)postMethod);
    }

    public ResponseBuddy doPost(String string, String string2, boolean bl) throws CMyException {
        try {
            return this.doPost(string, string2.getBytes(this.m_sEncoding), bl);
        }
        catch (Exception exception) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label1", "\u53d1\u9001\u8bf7\u6c42\u65f6\u51fa\u73b0\u5f02\u5e38"), exception);
        }
    }

    public ResponseBuddy doPost(String string, Map map, boolean bl) throws CMyException {
        return this.doPost(string, this.getContent(map), bl);
    }

    private String getContent(Map map) throws CMyException {
        if (map == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(map.size() * 20);
        try {
            for (Map.Entry entry : map.entrySet()) {
                stringBuffer.append(entry.getKey());
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode((String)entry.getValue(), DEFAULT_CONTENT_ENCODING));
                stringBuffer.append("&");
            }
        }
        catch (Exception exception) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label3", "\u6784\u9020\u53d1\u9001\u5185\u5bb9\u65f6\u51fa\u73b0\u5f02\u5e38"), exception);
        }
        return stringBuffer.toString();
    }

    public ResponseBuddy doPost(String string, byte[] byArray, boolean bl) throws CMyException {
        this.validUrl(string);
        PostMethod postMethod = new PostMethod(string);
        this.prepare((HttpMethod)postMethod);
        if (byArray != null) {
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(byArray);
            postMethod.setContentChunked(bl);
            postMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
        }
        return this.renderResponse((HttpMethod)postMethod);
    }

    private void prepare(HttpMethod httpMethod) {
        httpMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + this.m_sEncoding);
        if (this.m_arrRequestHeaders != null) {
            for (int i = 0; i < this.m_arrRequestHeaders.length; ++i) {
                httpMethod.setRequestHeader(this.m_arrRequestHeaders[i][0], this.m_arrRequestHeaders[i][1]);
            }
        }
    }

    private ResponseBuddy renderResponse(HttpMethod httpMethod) throws CMyException {
        ResponseBuddy responseBuddy;
        String string = null;
        int n = 0;
        try {
            string = httpMethod.getURI().getURI();
            n = this.m_oHttpClient.executeMethod(httpMethod);
            responseBuddy = new ResponseBuddy(httpMethod);
            Object var6_6 = null;
        }
        catch (Exception exception) {
            try {
                throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label4", "\u5411\u76ee\u6807\u5730\u5740[") + string + I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label5", "]\u63d0\u4ea4\u6570\u636e\u65f6\u5931\u8d25\uff01(response\u7f16\u53f7[") + n + "])", exception);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                httpMethod.releaseConnection();
                throw throwable;
            }
        }
        httpMethod.releaseConnection();
        return responseBuddy;
    }

    public ResponseBuddy doGet(String string, String string2) throws CMyException {
        this.validUrl(string);
        GetMethod getMethod = new GetMethod(string);
        this.prepare((HttpMethod)getMethod);
        if (string2 != null) {
            getMethod.setQueryString(string2);
        }
        return this.renderResponse((HttpMethod)getMethod);
    }

    public ResponseBuddy doGet(String string, Map map) throws CMyException {
        return this.doGet(string, this.getContent(map));
    }

    private void validUrl(String string) throws CMyException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CMyException(I18NMessage.get(HttpClientBuddy.class, "HttpClientBuddy.label6", "\u4e0d\u662f\u5408\u6cd5\u7684HTTP\u8bf7\u6c42\u7684\u76ee\u6807\u5730\u5740[") + string + "]", malformedURLException);
        }
        if (uRL.getProtocol().equalsIgnoreCase("https")) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new MySSLSocketFactory(), 443));
        }
    }
}

