/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CPager {
    public static final int DEFAULT_PAGE_SIZE = 20;
    private int m_nPageSize = 20;
    private int m_nItemCount = 0;
    private int PageCount = 0;
    private int CurrentPageIndex = 1;
    private int CurrentPageSize = 0;
    private boolean m_blNeedRefresh = false;
    private String m_sPageHrefPre = "";

    public CPager() {
    }

    public CPager(int n) {
        this.m_nPageSize = n;
        if (this.m_nPageSize == 0) {
            this.m_nPageSize = 20;
        }
    }

    private void mp_refreshData() {
        if (!this.m_blNeedRefresh) {
            return;
        }
        if (this.m_nPageSize == 0) {
            return;
        }
        if (this.m_nItemCount == 0) {
            this.PageCount = 0;
            this.CurrentPageSize = 0;
        } else {
            this.PageCount = this.m_nItemCount / this.m_nPageSize;
            if (this.m_nItemCount > this.PageCount * this.m_nPageSize) {
                ++this.PageCount;
            }
            if (this.CurrentPageIndex > this.PageCount) {
                this.CurrentPageIndex = this.PageCount;
            }
            this.CurrentPageSize = this.CurrentPageIndex < this.PageCount ? this.m_nPageSize : this.m_nItemCount - (this.CurrentPageIndex - 1) * this.m_nPageSize;
        }
        this.m_blNeedRefresh = false;
    }

    public void setItemCount(int n) {
        this.m_nItemCount = n < 0 ? 0 : n;
        if (!this.m_blNeedRefresh) {
            this.m_blNeedRefresh = true;
        }
    }

    public void setItemCount(Statement statement, String string) throws CMyException {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(string);
            this.m_nItemCount = resultSet.next() ? resultSet.getInt(1) : 0;
            resultSet.close();
            if (!this.m_blNeedRefresh) {
                this.m_blNeedRefresh = true;
            }
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(CPager.class, "CPager.label2", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u8bb0\u5f55\u603b\u6570\u65f6\u51fa\u73b0\u5f02\u5e38\uff08CPager.setItemCount\uff09"), sQLException);
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(CPager.class, "CPager.label2", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u8bb0\u5f55\u603b\u6570\u65f6\u51fa\u73b0\u5f02\u5e38\uff08CPager.setItemCount\uff09"), exception);
        }
    }

    public void moveToCurrentPageInRs(ResultSet resultSet) throws CMyException {
        try {
            if (this.m_blNeedRefresh) {
                this.mp_refreshData();
            }
            for (int i = 1; i <= (this.CurrentPageIndex - 1) * this.m_nPageSize; ++i) {
                resultSet.next();
            }
        }
        catch (SQLException sQLException) {
            throw new CMyException(40, I18NMessage.get(CPager.class, "CPager.label3", "\u5728\u8bb0\u5f55\u96c6\u4e2d\u5b9a\u4f4d\u5230\u6307\u5b9a\u9875\u9762\u65f6\u51fa\u73b0\u5f02\u5e38\uff08CPager.moveToCurrentPageInRs\uff09"), sQLException);
        }
        catch (Exception exception) {
            throw new CMyException(0, I18NMessage.get(CPager.class, "CPager.label3", "\u5728\u8bb0\u5f55\u96c6\u4e2d\u5b9a\u4f4d\u5230\u6307\u5b9a\u9875\u9762\u65f6\u51fa\u73b0\u5f02\u5e38\uff08CPager.moveToCurrentPageInRs\uff09"), exception);
        }
    }

    public boolean atFirstPage() {
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        return this.CurrentPageIndex == 1;
    }

    public boolean atLastPage() {
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        return this.CurrentPageIndex == this.PageCount;
    }

    public int getFirstItemIndex() {
        if (this.m_nPageSize < 0) {
            return 1;
        }
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        return (this.CurrentPageIndex - 1) * this.m_nPageSize + 1;
    }

    public int getLastItemIndex() {
        int n;
        if (this.m_nPageSize < 0) {
            return this.m_nItemCount;
        }
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        if ((n = (this.CurrentPageIndex - 1) * this.m_nPageSize + this.CurrentPageSize) > this.m_nItemCount) {
            return this.m_nItemCount;
        }
        return n;
    }

    public int getPrePageIndex() {
        int n;
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        if ((n = this.CurrentPageIndex - 1) < 1) {
            n = 1;
        }
        return n;
    }

    public int getNextPageIndex() {
        int n;
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        if ((n = this.CurrentPageIndex + 1) > this.PageCount) {
            n = this.PageCount;
        }
        return n;
    }

    public void setPageHrefPre(String string) {
        this.m_sPageHrefPre = string;
    }

    public String getPageHref(int n) {
        return this.m_sPageHrefPre + n;
    }

    public int getPageSize() {
        return this.m_nPageSize;
    }

    public void setPageSize(int n) {
        this.m_nPageSize = n;
        if (!this.m_blNeedRefresh) {
            this.m_blNeedRefresh = true;
        }
    }

    public int getItemCount() {
        return this.m_nItemCount;
    }

    public int getPageCount() {
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        return this.PageCount;
    }

    public void setCurrentPageIndex(int n) {
        int n2 = this.CurrentPageIndex = n <= 0 ? 1 : n;
        if (!this.m_blNeedRefresh) {
            this.m_blNeedRefresh = true;
        }
    }

    public int getCurrentPageIndex() {
        return this.CurrentPageIndex;
    }

    public int getCurrentPageSize() {
        if (this.m_blNeedRefresh) {
            this.mp_refreshData();
        }
        return this.CurrentPageSize;
    }

    public static void main(String[] stringArray) {
        CPager cPager = new CPager(3);
        cPager.setItemCount(10);
        cPager.setCurrentPageIndex(1);
        System.out.println(cPager.getFirstItemIndex() + ":" + cPager.getLastItemIndex());
    }
}

