/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyXMLElement;
import com.trs.infra.util.CMyXMLHandler;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMyXMLParser {
    private static final String SYSTEM_ID = "http://www.trs.com.cn";

    private static InputSource getInputSource(InputStream inputStream, String string) {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(SYSTEM_ID);
        String string2 = "";
        string2 = string == null || string.trim().length() <= 0 ? "UTF-8" : string;
        inputSource.setEncoding(string2);
        return inputSource;
    }

    private static void parseXMLFile(InputSource inputSource, DefaultHandler defaultHandler, boolean bl) throws Exception {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.newSAXParser().parse(inputSource, defaultHandler);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new SAXException("test", sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("ParserConfigurationException:" + parserConfigurationException.getMessage());
            throw new Exception(parserConfigurationException);
        }
        catch (IOException iOException) {
            System.out.println("IOException:" + iOException.getMessage());
            throw new Exception(iOException);
        }
    }

    private static InputStream getInputStream(String string, String string2) throws Exception {
        String string3 = "";
        string3 = string2 == null || string2.trim().length() <= 0 ? "UTF-8" : string2;
        try {
            byte[] byArray = string.getBytes(string3);
            return new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            throw new Exception("Failed to convert string into UTF-8 stream.", exception);
        }
    }

    public static CMyXMLElement strToElement(String string) throws Exception {
        return CMyXMLParser.strToElement(string, null);
    }

    public static CMyXMLElement strToElement(String string, Class clazz) throws Exception {
        return CMyXMLParser.strToElement(string, clazz, "");
    }

    public static CMyXMLElement strToElement(String string, Class clazz, String string2) throws Exception {
        if (string == null || string.trim().length() <= 0) {
            return null;
        }
        InputStream inputStream = CMyXMLParser.getInputStream(string, string2);
        return CMyXMLParser.streamToElement(inputStream, clazz, string2);
    }

    public static CMyXMLElement fileToElement(String string) throws WCMException {
        return CMyXMLParser.fileToElement(string, null);
    }

    public static CMyXMLElement fileToElement(String string, Class clazz) throws WCMException {
        return CMyXMLParser.filtToElement(string, clazz, "");
    }

    public static CMyXMLElement filtToElement(String string, Class clazz, String string2) throws WCMException {
        if (string == null || string.trim().length() <= 0) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(CMyFile.mapResouceFullPath(string));
        }
        catch (Exception exception) {
            throw new WCMException(53, I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label1", "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6[") + string + I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label2", "]\u5931\u8d25\uff01"), exception);
        }
        try {
            return CMyXMLParser.streamToElement(fileInputStream, clazz, string2);
        }
        catch (Exception exception) {
            throw new WCMException(150, I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label3", "\u89e3\u6790\u914d\u7f6e\u6587\u4ef6[") + string + I18NMessage.get(CMyXMLParser.class, "CMyXMLParser.label2", "]\u5931\u8d25\uff01"), exception);
        }
    }

    public static CMyXMLElement streamToElement(InputStream inputStream, Class clazz, String string) throws Exception {
        if (inputStream == null) {
            return null;
        }
        CMyXMLHandler cMyXMLHandler = null;
        cMyXMLHandler = clazz == null ? new CMyXMLHandler() : new CMyXMLHandler(clazz);
        InputSource inputSource = CMyXMLParser.getInputSource(inputStream, string);
        CMyXMLParser.parseXMLFile(inputSource, cMyXMLHandler, false);
        return cMyXMLHandler.getRootConfig();
    }
}

