/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyXMLElement;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMyXMLHandler
extends DefaultHandler {
    private LinkedList m_lStack;
    private CMyXMLElement m_oRootConfig;
    private boolean m_bParsingProperty;
    private boolean m_bIsProperty;
    private StringBuffer m_sbValue;
    private String m_sPropertiesTag = "PROPERTIES";
    private Class m_oConfigClass = CMyXMLElement.class;

    public CMyXMLHandler() {
        this.init();
    }

    public CMyXMLHandler(Class clazz) throws Exception {
        this.setConfigClass(clazz);
        this.init();
    }

    private void init() {
        this.m_lStack = new LinkedList();
        this.m_bParsingProperty = false;
        this.m_bIsProperty = false;
        this.m_sbValue = new StringBuffer();
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.m_bParsingProperty && this.m_bIsProperty && this.m_sbValue != null) {
            this.m_sbValue.append(cArray, n, n2);
        }
    }

    public void endElement(String string, String string2, String string3) {
        String string4 = string3.toUpperCase();
        if (string4.equals(this.m_sPropertiesTag)) {
            this.m_bParsingProperty = false;
            return;
        }
        if (this.m_bParsingProperty) {
            this.m_bIsProperty = false;
            String string5 = this.m_sbValue.toString();
            this.getFirstFromStatck().setProperty(string4, string5);
            this.m_sbValue.delete(0, this.m_sbValue.length());
            return;
        }
        this.pop();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_bParsingProperty) {
            this.m_bIsProperty = true;
            return;
        }
        String string4 = string3.toUpperCase();
        if (string4.equals(this.m_sPropertiesTag)) {
            if (this.m_oRootConfig == null) {
                throw new SAXException(I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label2", "\u683c\u5f0f\u4e0d\u5bf9\uff01"));
            }
            this.m_bParsingProperty = true;
            return;
        }
        CMyXMLElement cMyXMLElement = this.createNewConfig();
        cMyXMLElement.setName(string4);
        if (this.getRootConfig() == null) {
            this.setRootConfig(cMyXMLElement);
        } else {
            this.getFirstFromStatck().addChild(cMyXMLElement);
        }
        this.push(cMyXMLElement);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string5 = attributes.getQName(i).toUpperCase();
            String string6 = attributes.getValue(i);
            try {
                cMyXMLElement.setProperty(string5, string6);
                continue;
            }
            catch (Exception exception) {
                throw new SAXException(I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label3", "\u8bbe\u7f6e[") + string4 + I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label1", "]\u7684[") + string5.toUpperCase() + I18NMessage.get(CMyXMLHandler.class, "CMyXMLHandler.label4", "]\u5c5e\u6027\u5931\u8d25\uff01"), exception);
            }
        }
    }

    public CMyXMLElement getRootConfig() {
        return this.m_oRootConfig;
    }

    private CMyXMLElement createNewConfig() {
        try {
            return (CMyXMLElement)this.getConfigClass().newInstance();
        }
        catch (Exception exception) {
            return new CMyXMLElement();
        }
    }

    public Class getConfigClass() {
        return this.m_oConfigClass;
    }

    public void setConfigClass(Class clazz) {
        this.m_oConfigClass = clazz;
    }

    public void setRootConfig(CMyXMLElement cMyXMLElement) {
        this.m_oRootConfig = cMyXMLElement;
    }

    private void push(CMyXMLElement cMyXMLElement) {
        this.m_lStack.addFirst(cMyXMLElement);
    }

    private CMyXMLElement pop() {
        return (CMyXMLElement)this.m_lStack.removeFirst();
    }

    private CMyXMLElement getFirstFromStatck() {
        return (CMyXMLElement)this.m_lStack.getFirst();
    }
}

