/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.jazzlib.ZipEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class CMyUnZipFile {
    private static Logger m_oLogger = Logger.getLogger(CMyUnZipFile.class);
    private Hashtable m_hAllFileNameIndex = null;
    private ArrayList m_listFilteredFiles = null;
    private ArrayList m_listFileExtFilters = null;
    private String m_sUnZipPath = null;
    private String m_sZipFile = null;
    private String m_sFileNameEncoding = null;

    public CMyUnZipFile(String string, String string2) {
        this.setZipFile(string);
        this.setUnZipPath(string2);
    }

    public void doUnZipAnd() throws CMyException {
        if (!CMyFile.fileExists(this.getZipFile())) {
            throw new CMyException(55, I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u538b\u7f29\u6587\u4ef6[") + this.getZipFile() + "]");
        }
        String string = "";
        String string2 = "";
        try {
            CMyUnzip cMyUnzip = new CMyUnzip();
            cMyUnzip.setEncoding(this.m_sFileNameEncoding);
            cMyUnzip.setZipFile(this.getZipFile());
            cMyUnzip.unzip(this.getUnZipPath(), true);
            Enumeration enumeration = cMyUnzip.getItems();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                string = this.getUnZipPath() + zipEntry.getName().replace('/', File.separatorChar);
                string2 = CMyFile.extractFileName(string);
                this.putFileNameIndex(string2, string);
                if (!this.isFilterFile(string2)) continue;
                this.addFilteredFile(string);
            }
        }
        catch (Exception exception) {
            m_oLogger.error((Object)(I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label2", "\u89e3\u538b\u6587\u4ef6\u3010") + this.getZipFile() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label3", "\u3011\u5230\u76ee\u5f55\u3010") + this.getUnZipPath() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label4", "\u3011\u5931\u8d25\uff01")), (Throwable)exception);
            throw new CMyException(200, I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label2", "\u89e3\u538b\u6587\u4ef6\u3010") + this.getZipFile() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label3", "\u3011\u5230\u76ee\u5f55\u3010") + this.getUnZipPath() + I18NMessage.get(CMyUnZipFile.class, "CMyUnZipFile.label4", "\u3011\u5931\u8d25\uff01"), exception);
        }
    }

    public String getZipFile() {
        return this.m_sZipFile;
    }

    public void setZipFile(String string) {
        this.m_sZipFile = string;
    }

    public Hashtable getAllFileNameIndex() {
        return this.m_hAllFileNameIndex;
    }

    protected void putFileNameIndex(String string, String string2) {
        if (string == null) {
            return;
        }
        if (this.m_hAllFileNameIndex == null) {
            this.m_hAllFileNameIndex = new Hashtable();
        }
        this.m_hAllFileNameIndex.put(string.toUpperCase(), string2);
    }

    public ArrayList getFileExtFilters() {
        return this.m_listFileExtFilters;
    }

    public void addFileExtFilters(String string) {
        if (string == null) {
            return;
        }
        if (this.m_listFileExtFilters == null) {
            this.m_listFileExtFilters = new ArrayList();
        }
        this.m_listFileExtFilters.add(string.toUpperCase());
    }

    public String getFileNameEncoding() {
        return this.m_sFileNameEncoding;
    }

    public void setFileNameEncoding(String string) {
        this.m_sFileNameEncoding = string;
    }

    public String getUnZipPath() {
        return this.m_sUnZipPath;
    }

    public void setUnZipPath(String string) {
        this.m_sUnZipPath = string;
    }

    public ArrayList getFilteredFiles() {
        return this.m_listFilteredFiles;
    }

    private boolean addFilteredFile(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_listFilteredFiles == null) {
            this.m_listFilteredFiles = new ArrayList(1);
        }
        if (this.m_listFilteredFiles.indexOf(string) <= 0) {
            return this.m_listFilteredFiles.add(string);
        }
        return true;
    }

    private boolean isFilterFile(String string) {
        if (string == null) {
            return false;
        }
        if (this.getFileExtFilters() == null) {
            return false;
        }
        String string2 = CMyFile.extractFileExt(string);
        if (string2 == null) {
            return false;
        }
        return this.getFileExtFilters().indexOf(string2.toUpperCase()) >= 0;
    }

    public static void main(String[] stringArray) {
    }
}

