/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.security;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.security.SecureKey;
import com.trs.infra.support.security.SecureKeys;
import com.trs.infra.util.BASE64DecoderStream;
import com.trs.infra.util.CMyFile;
import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SecureKeyMgr {
    public byte[] encrypt(String string, byte[] byArray) throws WCMException {
        SecureKey secureKey = SecureKey.findByName(string);
        this.assertNotNull(secureKey, string);
        String string2 = secureKey.getAlgorithm();
        if (!"DES".equals(string2)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label1", "\u52a0\u5bc6\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u52a0\u5bc6\u5bc6\u94a5[") + secureKey + "]!");
        }
        try {
            Cipher cipher = Cipher.getInstance(string2);
            cipher.init(1, secureKey.getPublicKey());
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label2", "\u52a0\u5bc6\u5931\u8d25!"), exception);
        }
    }

    public byte[] decrypt(String string, byte[] byArray) throws WCMException {
        SecureKey secureKey = SecureKey.findByName(string);
        this.assertNotNull(secureKey, string);
        String string2 = secureKey.getAlgorithm();
        if (!"DES".equals(string2)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label3", "\u89e3\u5bc6\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u89e3\u5bc6\u5bc6\u94a5[") + secureKey + "]!");
        }
        try {
            Cipher cipher = Cipher.getInstance(string2);
            cipher.init(2, secureKey.getPrivateKey());
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label4", "\u89e3\u5bc6\u5931\u8d25!"), exception);
        }
    }

    public byte[] sign(String string, byte[] byArray) throws WCMException {
        SecureKey secureKey = SecureKey.findByName(string);
        this.assertNotNull(secureKey, string);
        String string2 = secureKey.getAlgorithm();
        if (!"DSA".equals(string2)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label5", "\u7b7e\u540d\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u7b7e\u540d\u5bc6\u94a5[") + secureKey + "]!");
        }
        try {
            Signature signature = Signature.getInstance(string2);
            signature.initSign((PrivateKey)secureKey.getPrivateKey());
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label6", "\u7b7e\u540d\u5931\u8d25!"), exception);
        }
    }

    public boolean verify(String string, byte[] byArray, byte[] byArray2) throws WCMException {
        SecureKey secureKey = SecureKey.findByName(string);
        this.assertNotNull(secureKey, string);
        Key key = secureKey.getPublicKey();
        String string2 = key.getAlgorithm();
        if (!"DSA".equals(string2)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label7", "\u6821\u9a8c\u7b7e\u540d\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u7b7e\u540d\u5bc6\u94a5[") + secureKey + "]!");
        }
        try {
            Signature signature = Signature.getInstance(string2);
            signature.initVerify((PublicKey)key);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label8", "\u6821\u9a8c\u7b7e\u540d\u5931\u8d25!"), exception);
        }
    }

    public SecureKey save(SecureKey secureKey) throws WCMException {
        if (!secureKey.isAddMode()) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label9", "\u4e0d\u80fd\u4fee\u6539SecureKey\u5bf9\u8c61!"));
        }
        String string = secureKey.getAlgorithm();
        if ("DES".equals(string)) {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
                keyGenerator.init(secureKey.getKeySize());
                SecretKey secretKey = keyGenerator.generateKey();
                secureKey.setPrivateKey(secretKey);
                secureKey.setPublicKey(secretKey);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        } else if ("DSA".equals(string)) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
                keyPairGenerator.initialize(secureKey.getKeySize());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                secureKey.setPrivateKey(keyPair.getPrivate());
                secureKey.setPublicKey(keyPair.getPublic());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        } else {
            throw new WCMException(1104, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label10", "\u4e0d\u88ab\u652f\u6301\u7684\u7b97\u6cd5[") + string + "]!");
        }
        secureKey.insert();
        return secureKey;
    }

    public SecureKeys getKeys(WCMFilter wCMFilter) throws WCMException {
        return SecureKeys.openWCMObjs(wCMFilter);
    }

    private void assertNotNull(SecureKey secureKey, String string) throws WCMException {
        if (secureKey == null) {
            throw new WCMException(200006, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label11", "\u6ca1\u6709\u627e\u5230[KeyName=") + string + I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label12", "]\u7684SecureKey\u5bf9\u8c61!"));
        }
    }

    public String exportKey(String string, boolean bl) throws WCMException {
        SecureKey secureKey = SecureKey.findByName(string);
        this.assertNotNull(secureKey, string);
        return this.exportKey(secureKey, bl);
    }

    public String exportKey(int n, boolean bl) throws WCMException {
        SecureKey secureKey = SecureKey.findById(n);
        if (secureKey == null) {
            throw new WCMException(200006, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label13", "\u6ca1\u6709\u627e\u5230[id=") + n + I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label14", "]\u7684\u5bc6\u94a5!"));
        }
        return this.exportKey(secureKey, bl);
    }

    private String exportKey(SecureKey secureKey, boolean bl) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFilePathName("ST", "dat");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(string));
            String string2 = null;
            string2 = bl ? secureKey.getPropertyAsString("PRIVATEKEY") : secureKey.getPropertyAsString("PUBLICKEY");
            fileOutputStream.write(BASE64DecoderStream.decode(string2));
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new WCMException(50, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label15", "\u751f\u6210\u5bc6\u94a5\u6587\u4ef6\u5931\u8d25\uff01"), exception);
        }
        return CMyFile.extractFileName(string);
    }
}

