/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogType;
import com.trs.infra.support.log.Logs;
import com.trs.infra.support.log.OperType;
import org.dom4j.Element;

public final class LogXmlConverter
extends BaseObjToXmlConverter {
    private static final String UNKOWN_DESC = I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label15", "\u672a\u77e5");
    private static final String TAG_PROPERTIES = "PROPERTIES";
    private static final String VALUEABLE_FIELDS = "LOGTYPE,LOGOBJNAME,LOGOPTYPE,LOGUSER,LOGUSERIP,LOGOPTIME,EXECTIME,LOGRESULT,LOGDESC";

    protected Element[] getChildElement(BaseObj baseObj) throws WCMException {
        this.assertIsLogInstance(baseObj);
        Log log = (Log)baseObj;
        WCMFilter wCMFilter = new WCMFilter("", "TopId=" + log.getId(), "");
        Logs logs = Logs.openWCMObjs(wCMFilter);
        if (logs.isEmpty()) {
            return null;
        }
        Element[] elementArray = new Element[]{this.toXmlElement(logs, null)};
        elementArray[0].setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label1", "\u89e6\u53d1\u7684\u64cd\u4f5c"));
        return elementArray;
    }

    protected Element toXmlElement(BaseObj baseObj, String string) throws WCMException {
        this.assertIsLogInstance(baseObj);
        Element element = super.toXmlElement(baseObj, VALUEABLE_FIELDS);
        element.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label2", "\u64cd\u4f5c\u65e5\u5fd7"));
        Element element2 = element.element(TAG_PROPERTIES);
        element2.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label3", "\u65e5\u5fd7\u4fe1\u606f"));
        Element element3 = element2.element("LOGTYPE");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label4", "\u65e5\u5fd7\u7c7b\u578b"));
        element3.setText(this.getOperDesc(element3.getText()));
        element3 = element2.element("LOGOBJNAME");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label5", "\u64cd\u4f5c\u5bf9\u8c61"));
        element3 = element2.element("LOGOPTYPE");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label6", "\u64cd\u4f5c\u7c7b\u578b"));
        element3.setText(this.getOperTypeDesc(element3.getText()));
        element3 = element2.element("LOGUSER");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label7", "\u64cd\u4f5c\u7528\u6237"));
        element3 = element2.element("LOGUSERIP");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label8", "\u64cd\u4f5c\u7528\u6237IP"));
        element3 = element2.element("LOGOPTIME");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label9", "\u64cd\u4f5c\u65f6\u95f4"));
        element3 = element2.element("EXECTIME");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label10", "\u64cd\u4f5c\u8017\u65f6"));
        element3.setText(element3.getText() + "ms");
        element3 = element2.element("LOGRESULT");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label11", "\u64cd\u4f5c\u7ed3\u679c"));
        element3.setText(this.getOperResultDesc(element3.getText()));
        element3 = element2.element("LOGDESC");
        element3.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label12", "\u64cd\u4f5c\u8be6\u7ec6\u63cf\u8ff0"));
        return element;
    }

    private void assertIsLogInstance(BaseObj baseObj) throws WCMException {
        if (baseObj == null || !(baseObj instanceof Log)) {
            throw new WCMException(10, "isn't a log instance!");
        }
    }

    private String getOperDesc(String string) throws WCMException {
        if (this.emptyString(string)) {
            return UNKOWN_DESC;
        }
        LogType logType = LogType.findById(Integer.parseInt(string));
        return logType != null ? logType.getDesc() : UNKOWN_DESC;
    }

    private String getOperTypeDesc(String string) throws WCMException {
        OperType operType = OperType.findById(Integer.parseInt(string));
        return operType != null ? operType.getDesc() : UNKOWN_DESC;
    }

    private String getOperResultDesc(String string) {
        if (this.emptyString(string)) {
            return UNKOWN_DESC;
        }
        int n = Integer.parseInt(string);
        return n == 1 ? I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label13", "\u6210\u529f") : I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label14", "\u5931\u8d25");
    }

    private boolean emptyString(String string) {
        return string == null || string.trim().length() == 0;
    }
}

