/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.BaseDBLog;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyKeyGenerator;
import com.trs.infra.util.CMySign;
import com.trs.infra.util.CMyString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import org.apache.log4j.Logger;

public class Log
extends BaseDBLog {
    private static Logger logger = Logger.getLogger(Log.class);
    public static final int OBJ_TYPE = 702;
    public static final String DB_TABLE_NAME = "WCMLOG";
    public static final String DB_ID_NAME = "LOGID";
    private static final String KEY_PRIVATE_LOGIN = ConfigConstants.DIR_APPROOT + "private_log.key";
    private static final String KEY_PUBLIC_LOGIN = ConfigConstants.DIR_APPROOT + "public_log.key";
    private String m_sValidateResult = null;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 702;
    }

    public void insert() throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getProperty("LOGOPTIME") == null) {
                this.setOpTime();
            }
            this.setProperty("SIGNINFO", this.createEncodeLogInfo());
            super.insert();
        }
    }

    public static final Log findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Log)BaseObj.findById(Log.class, n);
    }

    public static final Log createNewInstance() throws WCMException {
        return (Log)BaseObj.createNewInstance(Log.class);
    }

    public static final Log findByKey(Object object) throws WCMException {
        return (Log)BaseObj.findByKey(Log.class, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String createEncodeLogInfo() {
        Exception exception222;
        String string;
        FilterOutputStream filterOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block16: {
            byteArrayOutputStream = null;
            filterOutputStream = null;
            CMySign cMySign = CMySign.getSign(KEY_PRIVATE_LOGIN);
            byteArrayOutputStream = new ByteArrayOutputStream(512);
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(this.getObjId());
            ((DataOutputStream)filterOutputStream).writeInt(this.getObjType());
            ((DataOutputStream)filterOutputStream).writeInt(this.getOpType());
            ((DataOutputStream)filterOutputStream).writeUTF(this.getObjName());
            ((DataOutputStream)filterOutputStream).writeUTF(CMyString.showNull(this.getLogUserIP(), "127.0.0.1"));
            ((DataOutputStream)filterOutputStream).writeUTF(this.getUserName());
            ((DataOutputStream)filterOutputStream).writeUTF(this.getOpTime().toString("yyyy-MM-dd HH:mm:ss"));
            ((DataOutputStream)filterOutputStream).flush();
            byte[] byArray = cMySign.sign(byteArrayOutputStream.toByteArray());
            ((DataOutputStream)filterOutputStream).writeInt(byArray.length);
            filterOutputStream.write(byArray);
            ((DataOutputStream)filterOutputStream).flush();
            string = cMySign.encodeRadix64(byteArrayOutputStream.toByteArray());
            Object var7_7 = null;
            if (filterOutputStream == null) break block16;
            try {
                filterOutputStream.close();
            }
            catch (Exception exception222) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception222) {
                // empty catch block
            }
        }
        return string;
        catch (Exception exception3) {
            Exception exception4222;
            block18: {
                try {
                    exception3.printStackTrace();
                    Object var7_8 = null;
                    if (filterOutputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    Exception exception5222;
                    Object var7_9 = null;
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception4222) {
                    // empty catch block
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception4222) {}
            }
        }
        return "";
    }

    public boolean isValidSignLog() {
        return this.validateSignInfo();
    }

    public String getValidSignResult() {
        return this.m_sValidateResult;
    }

    private boolean validateSignInfo() {
        String string = this.getPropertyAsString("SIGNINFO");
        if (string == null || string.length() <= 0) {
            this.m_sValidateResult = I18NMessage.get(Log.class, "Log.label1", "\u65e5\u5fd7\u6ca1\u6709\u7ecf\u8fc7\u7b7e\u540d");
            return false;
        }
        this.m_sValidateResult = "";
        try {
            boolean bl;
            byte[] byArray = string.getBytes();
            CMySign cMySign = CMySign.getVerify(KEY_PUBLIC_LOGIN);
            byArray = cMySign.decodeRadix64(byArray);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            boolean bl2 = bl = n == 0;
            if (!bl && this.getObjId() != n) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label2", "LOGOBJID\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684ID=[") + n + "] ";
            }
            n = dataInputStream.readInt();
            if (this.getObjType() != n) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label3", "LOGOBJTYPE\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOBJTYPE=[") + n + "] ";
            }
            n = dataInputStream.readInt();
            if (this.getOpType() != n) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label4", "LOGOPTYPE\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOPTYPE=[") + n + "] ";
            }
            String string2 = dataInputStream.readUTF();
            if (!bl && !string2.equals(this.getObjName())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label5", "LOGOBJNAME\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOBJNAME=[") + string2 + "] ";
            }
            if (!(string2 = dataInputStream.readUTF()).equals(this.getLogUserIP())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label6", "LOGUSERI\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGUSERIP=[") + string2 + "] ";
            }
            if (!(string2 = dataInputStream.readUTF()).equals(this.getUserName())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label7", "LOGUSER\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGUSER=[") + string2 + "] ";
            }
            if (!(string2 = dataInputStream.readUTF()).equals(this.getOpTime().toString("yyyy-MM-dd HH:mm:ss"))) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label8", "LOGOPTIM\u88ab\u7be1\u6539\u4e86\uff0c\u539f\u6709\u7684LOGOPTIME=[") + string2 + "] ";
            }
            if (!cMySign.verify(byArray, n = dataInputStream.readInt())) {
                this.m_sValidateResult = this.m_sValidateResult + I18NMessage.get(Log.class, "Log.label9", "\u6570\u636e\u957f\u5ea6[") + n + I18NMessage.get(Log.class, "Log.label10", "]\u4e0d\u4e00\u81f4");
            }
            return this.m_sValidateResult.length() <= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        try {
            if (!CMyFile.fileExists(KEY_PRIVATE_LOGIN)) {
                logger.info((Object)("create " + KEY_PRIVATE_LOGIN + " file.."));
                CMyKeyGenerator.generatorKey(KEY_PRIVATE_LOGIN, KEY_PUBLIC_LOGIN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

