/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.file;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.file.FilesMan;

public class PathConfigLCListener
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private FilesMan m_filesMan = FilesMan.getFilesMan();

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        Config config = (Config)baseObj;
        this.refreshPathConfig(config);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) {
        Config config = (Config)baseObj;
        if (10 == config.getType()) {
            this.m_filesMan.removePathConfig(config.getConfigKey());
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        Config config = (Config)baseObj;
        this.refreshPathConfig(config);
    }

    private void refreshPathConfig(Config config) throws WCMException {
        if (10 == config.getType()) {
            try {
                this.m_filesMan.refreshPathConfig(config);
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(PathConfigLCListener.class, "PathConfigLCListener.label1", "\u5237\u65b0\u76ee\u5f55\u914d\u7f6e\u7f13\u51b2\u5931\u8d25!"), exception);
            }
        }
    }
}

