/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyEncrypt;
import com.trs.infra.util.CMyString;

public class Config
extends BaseObj {
    public static final int OBJ_TYPE = 701;
    public static final String DB_TABLE_NAME = "WCMCONFIG";
    public static final String DB_ID_NAME = "CONFIGID";
    public static final int TYPE_NORM = 0;
    public static final int TYPE_FILE_PATH = 10;
    public static final int TYPE_JOB_SERVER = 15;
    public static final int TYPE_SCHEDULE_SERVER = 16;
    public static final int TYPE_CLUSTER_META = 13;
    public static final int TYPE_CUSTOM_ADD = 20;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 701;
    }

    public int getType() {
        return this.getPropertyAsInt("CTYPE", 0);
    }

    public String getTypeName() {
        return ConfigServer.getServer().getTypeName(this.getType());
    }

    public boolean setType(int n) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(Config.class, "Config.label1", "\u5c5e\u6027Type\u4e0d\u5141\u8bb8\u4fee\u6539\uff08Config.setType\uff09"));
        }
        return this.setProperty("CTYPE", n);
    }

    public String getConfigKey() {
        return (String)this.getProperty("CKEY");
    }

    public boolean setConfigKey(String string) throws WCMException {
        return this.setProperty("CKEY", string);
    }

    public boolean isEncrypted() {
        return this.getPropertyAsBoolean("ENCRYPTED", false);
    }

    public String getDesc() {
        return (String)this.getProperty("CDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("CDESC", string);
    }

    public String getValue() {
        String string = (String)this.getProperty("CVALUE");
        if (string == null) {
            return null;
        }
        if (this.isEncrypted()) {
            string = CMyEncrypt.setAnotherChar(string);
        }
        return string;
    }

    public boolean setValue(String string) throws WCMException {
        boolean bl = this.isAddMode() ? false : this.isEncrypted();
        return this.setValue(string, bl);
    }

    public boolean setValue(String string, boolean bl) throws WCMException {
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(Config.class, "Config.label2", "\u914d\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff08Config.setValue\uff09"));
        }
        if (!this.setProperty("ENCRYPTED", bl)) {
            return false;
        }
        if (bl) {
            string = CMyEncrypt.setAnotherChar(string);
        }
        return this.setProperty("CVALUE", string);
    }

    public boolean isValid() throws WCMException {
        String string;
        int n = 0;
        String string2 = null;
        String string3 = null;
        if (this.isAddMode()) {
            if (this.getAllProperty().get("SITEID") != null) {
                n = ((Number)this.getAllProperty().get("SITEID")).intValue();
            }
            if ((string = this.getPropertyAsString("CTYPE")) == null) {
                throw new WCMException(1106, I18NMessage.get(Config.class, "Config.label3", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(Config.isValid)"));
            }
            string2 = (String)this.getAllProperty().get("CKEY");
            if (string2 == null) {
                throw new WCMException(1106, I18NMessage.get(Config.class, "Config.label4", "\u5c5e\u6027ConfigKey\u6ca1\u6709\u8bbe\u7f6e(Config.isValid)"));
            }
            if (10 == Integer.parseInt(string) && string2.length() != 2) {
                throw new WCMException(1104, I18NMessage.get(Config.class, "Config.label5", "\u76ee\u5f55\u914d\u7f6e\u4e2d\u5173\u952e\u5b57\u5fc5\u987b\u4e3a2\u4f4d!\u60a8\u8bbe\u7f6e\u7684\u5173\u952e\u5b57\u662f[") + string2 + "]");
            }
            this.getAllProperty().put("CKEY", string2.toUpperCase());
            string3 = (String)this.getAllProperty().get("CVALUE");
            if (this.getAllProperty().get("CVALUE") == null) {
                throw new WCMException(1106, I18NMessage.get(Config.class, "Config.label6", "\u5c5e\u6027Value\u6ca1\u6709\u8bbe\u7f6e(Config.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Config.class, "Config.label7", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Config.isValid)"));
            }
            string3 = this.getNewPropertyAsString("CVALUE");
        }
        if (string3 != null) {
            boolean bl = this.isEncrypted();
            if (this.isChangeProperty("ENCRYPTED")) {
                bl = this.getNewPropertyAsInt("ENCRYPTED", 0) == 1;
            }
            this.setValue(string3, bl);
        }
        if (string2 != null) {
            string = " (CKey='" + CMyString.filterForSQL(string2) + "') and (CType=" + this.getType() + ") and SiteId=" + n;
            if (!this.isAddMode()) {
                string = string + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(string)) {
                throw new WCMException(1108, I18NMessage.get(Config.class, "Config.label8", "\u76f8\u540c\u7c7b\u522b\u7684\u914d\u7f6e\u4fe1\u606f\u4e2d\u5173\u952e\u5b57\u5df2\u7ecf\u5b58\u5728\uff08Config.isValid\uff09"));
            }
        }
        return true;
    }

    public static final Config findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Config)BaseObj.findById(Config.class, n);
    }

    public static final Config createNewInstance() throws WCMException {
        return (Config)BaseObj.createNewInstance(Config.class);
    }

    public static final Config findByKey(Object object) throws WCMException {
        return (Config)BaseObj.findByKey(Config.class, object);
    }

    public void insert() throws WCMException {
        super.insert();
    }

    public synchronized void update() throws WCMException {
        super.update();
    }

    public int delete() throws WCMException {
        return super.delete();
    }
}

