/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.infra.util.key.MacAddressHelper;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class MyDate
implements License {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private static int m_nMaxSiteNum = -1;

    public int getMaxSiteNum() {
        if (m_nMaxSiteNum < 0) {
            this.validate();
        }
        return m_nMaxSiteNum;
    }

    public int getMaxUserNum() {
        return 0;
    }

    public int getPluginCode() {
        return 0;
    }

    public String validate() {
        try {
            String string = MyDate.getProductKey();
            if (!MyDate.validateHostMachine(string)) {
                return I18NMessage.get(MyDate.class, "MyDate.label1", "\u673a\u5668\u7801\u4e0d\u4e00\u81f4\uff01\u5f53\u524d\u6ce8\u518c\u7801\u53ea\u80fd\u5728[") + string.substring(0, 12) + I18NMessage.get(MyDate.class, "MyDate.label2", "]\u4e0b\u4f7f\u7528\uff0c\u60a8\u7684\u673a\u5668\u7801\u662f\u3010") + MacAddressHelper.getMyMacAsLong() + "\u3011";
            }
            String string2 = MyDate.validateExpiration(string);
            if (string2 != null) {
                return string2;
            }
            String string3 = string.substring(12, 14);
            int n = CKeyUtil.getKeyNum(string3);
            if (n == 99) {
                return I18NMessage.get(MyDate.class, "MyDate.label3", "Platform\u7684License");
            }
            m_nMaxSiteNum = n;
            return null;
        }
        catch (Throwable throwable) {
            return "Validate Exception\uff01Date";
        }
    }

    private static String getProductKey() {
        String string = MyDate.loadLicenseFile();
        string = LicenseUtil.decodeRadix64(string);
        return CKeyUtil.DecodeKey(string);
    }

    private static String validateExpiration(String string) {
        String string2 = string.substring(16, string.length());
        string2 = string2.substring(0, 4) + '-' + string2.substring(4, 6) + '-' + string2.substring(6, string2.length());
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            cMyDateTime.setDateWithString(string2, 0);
            if (cMyDateTime.dateDiff(3, CMyDateTime.now()) < 0L) {
                String string3 = I18NMessage.get(MyDate.class, "MyDate.label5", "\u7cfb\u7edf\u542f\u52a8\u9519\u8bef\uff0c\u7f16\u53f7\u4e3a21039\uff0c\u8bf7\u5c06\u9519\u8bef\u7f16\u53f7\u544a\u8bc9TRS\u76f8\u5173\u9500\u552e\uff0c\u4ed6\u4eec\u5c06\u4e3a\u60a8\u8054\u7cfb\u4eba\u5458\u8fdb\u884c\u670d\u52a1\uff0c\u611f\u8c22\u60a8\u4f7f\u7528TRSWCM!");
                return string3;
            }
        }
        catch (CMyException cMyException) {
            return I18NMessage.get(MyDate.class, "MyDate.label6", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!");
        }
        return null;
    }

    private static boolean validateHostMachine(String string) {
        String string2 = string.substring(0, 12);
        while (string2.charAt(0) == '0' && string2.length() > 0) {
            string2 = string2.substring(1);
        }
        long l = Long.parseLong(string2);
        return MacAddressHelper.isValidMac(l);
    }

    private static String loadLicenseFile() {
        String string = "";
        Class<MyDate> clazz = MyDate.class;
        String string2 = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            string = CMyFile.readFile(string2).trim();
        }
        catch (CMyException cMyException) {
            int n = cMyException.getErrNo();
            if (55 == n) {
                throw new LicenseException(I18NMessage.get(MyDate.class, "MyDate.label7", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(MyDate.class, "MyDate.label8", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String string3 = LicenseUtil.decodeRadix64(string);
        return string3;
    }
}

