/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.infra.util.key.MacAddressHelper;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class LicenseMgr {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private static License s_oLicense = null;
    private static LicenseMgr s_oMgr = new LicenseMgr();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LicenseMgr getInstance() {
        if (s_oLicense == null) {
            LicenseMgr licenseMgr = s_oMgr;
            synchronized (licenseMgr) {
                License license;
                if (s_oLicense != null) {
                    return s_oMgr;
                }
                String string = LicenseMgr.getProductKey();
                LicenseMgr.validateHostMachine(string);
                LicenseMgr.validateExpiration(string);
                String string2 = string.substring(12, 14);
                final int n = CKeyUtil.getKeyNum(string2);
                if (n == 99) {
                    throw new LicenseException(I18NMessage.get(LicenseMgr.class, "LicenseMgr.label1", "Platform\u7684License"));
                }
                string2 = string.substring(14, 16);
                final int n2 = CKeyUtil.getKeyNum(string2);
                s_oLicense = license = new License(){

                    public int getMaxSiteNum() {
                        return n - 1;
                    }

                    public int getMaxUserNum() {
                        return n2 - 1;
                    }

                    public int getPluginCode() {
                        return 0;
                    }

                    public String validate() {
                        return null;
                    }
                };
            }
        }
        return s_oMgr;
    }

    private static String getProductKey() {
        String string = LicenseMgr.loadLicenseFile();
        string = LicenseUtil.decodeRadix64(string);
        return CKeyUtil.DecodeKey(string);
    }

    private static void validateExpiration(String string) {
        String string2 = string.substring(16, string.length());
        string2 = string2.substring(0, 4) + '-' + string2.substring(4, 6) + '-' + string2.substring(6, string2.length());
        CMyDateTime cMyDateTime = new CMyDateTime();
        try {
            cMyDateTime.setDateWithString(string2, 0);
            if (cMyDateTime.dateDiff(3, CMyDateTime.now()) < 0L) {
                String string3 = I18NMessage.get(LicenseMgr.class, "LicenseMgr.label2", "\u4ea7\u54c1\u5df2\u8fc7\u671f(\u6709\u6548\u671f\u622a\u6b62\u5230[") + cMyDateTime.toString(I18NMessage.get(LicenseMgr.class, "LicenseMgr.label3", "yyyy\u5e74MM\u6708dd\u65e5")) + I18NMessage.get(LicenseMgr.class, "LicenseMgr.label4", "]),\u60a8\u9700\u8981\u8d2d\u4e70\u53e6\u4e00\u4e2a\u4f7f\u7528\u8bb8\u53ef\u624d\u80fd\u7ee7\u7eed\u4f7f\u7528!\n") + I18NMessage.get(LicenseMgr.class, "LicenseMgr.label5", "\u611f\u8c22\u60a8\u4f7f\u7528TRSWCM!\n") + I18NMessage.get(LicenseMgr.class, "LicenseMgr.label6", "TRS\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1.");
                throw new LicenseException(string3);
            }
        }
        catch (CMyException cMyException) {
            throw new LicenseException(I18NMessage.get(LicenseMgr.class, "LicenseMgr.label7", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!"), cMyException);
        }
    }

    private static void validateHostMachine(String string) {
        String string2 = string.substring(0, 12);
        while (string2.charAt(0) == '0' && string2.length() > 0) {
            string2 = string2.substring(1);
        }
        long l = Long.parseLong(string2);
        if (!MacAddressHelper.isValidMac(l)) {
            throw new LicenseException(I18NMessage.get(LicenseMgr.class, "LicenseMgr.label8", "\u65e0\u6548\u7684\u4f7f\u7528\u8bb8\u53ef(Host)!"));
        }
    }

    private static String loadLicenseFile() {
        String string = "";
        Class<LicenseMgr> clazz = LicenseMgr.class;
        String string2 = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            string = CMyFile.readFile(string2).trim();
        }
        catch (CMyException cMyException) {
            int n = cMyException.getErrNo();
            if (55 == n) {
                throw new LicenseException(I18NMessage.get(LicenseMgr.class, "LicenseMgr.label9", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(LicenseMgr.class, "LicenseMgr.label10", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String string3 = LicenseUtil.decodeRadix64(string);
        return string3;
    }
}

