/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBConnectionConfig;
import com.trs.infra.persistent.db.DBConnectionMapper;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.ConnectionPool;
import com.trs.infra.util.database.DBIdManager;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.database.TableInfo;
import com.trs.infra.util.database.TableInfos;
import com.trs.key.wcm.BaseWCMKeyUtil;
import com.trs.util.dbcp.ConnectionCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class DBManager
extends BaseServer {
    private static final Logger logger = Logger.getLogger((String)DBManager.class.getName());
    protected ConnectionPool m_oDBPool = null;
    private TableInfos m_oTableInfos;
    private DBIdManager m_oDbIdManager = null;
    private DBConnectionConfig m_oDBConnConfig;
    private static DBManager m_oDBManager = new DBManager();
    private Set m_oDBKeywords = null;

    public boolean isKeywords(String string) {
        if (CMyString.isEmpty(string)) {
            return true;
        }
        String string2 = string.trim().toUpperCase();
        return this.m_oDBKeywords.contains(string2);
    }

    public static DBManager getDBManager() {
        if (!m_oDBManager.isStarted()) {
            m_oDBManager.startup();
            if (!m_oDBManager.isStarted()) {
                System.err.println(I18NMessage.get(DBManager.class, "DBManager.label1", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38,\u6570\u636e\u5e93\u542f\u52a8\u5931\u8d25!"));
                return null;
            }
        }
        return m_oDBManager;
    }

    private void loadConfig() {
        this.setDBConfig(DBConnectionMapper.getInstance().getDefaultDBConnectionConfig());
    }

    private void clearConfig() {
        DBConnectionMapper.getInstance().clear();
        this.setDBConfig(null);
    }

    private boolean init() throws WCMException {
        if (!this.initConfig()) {
            return false;
        }
        this.loadConfig();
        this.initDBPool();
        if (!this.loadSystemInfo()) {
            return false;
        }
        this.initTableInfos();
        this.initDBIdManager();
        this.initDBKeywords();
        return true;
    }

    private boolean initConfig() {
        try {
            BaseWCMKeyUtil.getInstance();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return false;
        }
        return true;
    }

    private boolean loadSystemInfo() {
        BaseWCMKeyUtil baseWCMKeyUtil = null;
        try {
            baseWCMKeyUtil = BaseWCMKeyUtil.getInstance();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return false;
        }
        int n = baseWCMKeyUtil.func2();
        if (n < 0) {
            System.out.println(I18NMessage.get(DBManager.class, "DBManager.label2", "\u6ce8\u518c\u7801\u6709\u95ee\u9898\uff0c\u975e\u6cd5\u4f7f\u7528\uff01\n"));
            return false;
        }
        if (n == 0) {
            return true;
        }
        try {
            String string = "select count(*) num from WCMWebSite";
            int n2 = this.sqlExecuteIntQuery(string);
            if (n2 <= 0) {
                return true;
            }
            if (n2 > n) {
                System.out.println(I18NMessage.get(DBManager.class, "DBManager.label3", "\u7ad9\u70b9\u6570\u8d85\u51fa\u5f53\u524d\u6ce8\u518c\u7801\u9650\u5236\uff0c\u5982\u9700\u589e\u52a0\uff0c\u8bf7\u4e0eTRS\u516c\u53f8\u8054\u7cfb\uff0c\u611f\u8c22\u60a8\u4f7f\u7528TRS\u4ea7\u54c1\uff01\n"));
                return false;
            }
        }
        catch (Throwable throwable) {
            System.out.println(I18NMessage.get(DBManager.class, "DBManager.label4", "\u6ce8\u518c\u7801\u6709\u95ee\u9898\uff0c\u83b7\u53d6\u7ad9\u70b9\u6570\u4e0d\u901a\u8fc7\uff01\n"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDBKeywords() {
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.m_oDBKeywords = new HashSet(100);
                String[] stringArray = connection.getMetaData().getSQLKeywords().split(",");
                String string = null;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    string = stringArray[i].trim().toUpperCase();
                    this.m_oDBKeywords.add(string);
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle("WCMDBKeyWords");
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    this.m_oDBKeywords.add(enumeration.nextElement());
                }
                Object var7_9 = null;
                this.freeConnection(connection);
            }
            catch (Exception exception) {
                logger.error((Object)"init DB keywords fail!", (Throwable)exception);
                Object var7_10 = null;
                this.freeConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.freeConnection(connection);
            throw throwable;
        }
    }

    public Set getDBKeywords() {
        HashSet hashSet = new HashSet(this.m_oDBKeywords.size());
        hashSet.addAll(this.m_oDBKeywords);
        return hashSet;
    }

    public Iterator iteratorKeywords() {
        return this.m_oDBKeywords.iterator();
    }

    private void release() {
        this.clearDBIdManager();
        this.clearTableInfos();
        this.closeDBPool();
        this.clearConfig();
        this.clearDBKeywords();
    }

    private void clearDBKeywords() {
        if (this.m_oDBKeywords != null) {
            this.m_oDBKeywords.clear();
        }
    }

    private synchronized void initDBPool() throws WCMException {
        if (this.m_oDBPool != null) {
            return;
        }
        DBType dBType = this.getDBConnConfig().getDBType();
        String string = dBType.getDriverClass();
        if (string == null) {
            throw new WCMException(10, I18NMessage.get(DBManager.class, "DBManager.label5", "\u521d\u59cb\u5316\u4fe1\u606f\u914d\u7f6e\uff1aDBTYPE\u6307\u5b9a\u7684\u6570\u636e\u5e93\u7c7b\u578b\u65e0\u6548\uff08\u503c=") + this.getDBConnConfig() + "\uff09");
        }
        try {
            this.m_oDBPool = new ConnectionPool(this.getDBConnConfig());
        }
        catch (SQLException sQLException) {
            logger.error((Object)(I18NMessage.get(DBManager.class, "DBManager.label6", "\u8fde\u63a5\u7f13\u51b2\u6c60\u521d\u59cb\u5316\u5931\u8d25: \nDB:") + this.getDBConnConfig().getConnectionURL()), (Throwable)sQLException);
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label7", "\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\uff1a") + this.getDBConnConfig(), sQLException);
        }
        logger.info((Object)(I18NMessage.get(DBManager.class, "DBManager.label8", "\u8fde\u63a5\u7f13\u51b2\u6c60\u521d\u59cb\u5316\u6210\u529f: DBURL=") + this.getDBConnConfig().getConnectionURL()));
    }

    private void closeDBPool() {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.close();
        this.m_oDBPool = null;
    }

    public DBConnectionConfig getDBConnConfig() {
        return this.m_oDBConnConfig;
    }

    public void setDBConfig(DBConnectionConfig dBConnectionConfig) {
        this.m_oDBConnConfig = dBConnectionConfig;
    }

    public Connection getConnection() throws WCMException {
        Connection connection = null;
        try {
            connection = this.getDBPool().getConnection();
        }
        catch (Exception exception) {
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label9", "\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u5931\u8d25(Application.getConnection)"), exception);
        }
        if (connection == null) {
            throw new WCMException(41, I18NMessage.get(DBManager.class, "DBManager.label10", "\u6ca1\u6709\u627e\u5230\u6709\u6548\u53ef\u7528\u7684\u6570\u636e\u5e93\u8fde\u63a5(Application.getConnection)"));
        }
        return connection;
    }

    public FieldInfo getFieldInfo(String string, String string2) throws WCMException {
        return this.getTableInfos().getFieldInfo(string, string2);
    }

    public TableInfo getTableInfo(String string) throws WCMException {
        return this.getTableInfos().getTableInfo(string);
    }

    public DBType getDBType() {
        return this.getDBConnConfig().getDBType();
    }

    public int getDBTypeAsInt() {
        return this.getDBType().getType();
    }

    private synchronized void initTableInfos() throws WCMException {
        if (this.m_oTableInfos == null) {
            this.m_oTableInfos = new TableInfos();
        } else {
            this.m_oTableInfos.clear();
        }
        Connection connection = null;
        try {
            try {
                connection = this.getDBPool().getConnection();
                this.m_oTableInfos.load(connection, this.getDBConnConfig().getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase());
                logger.info((Object)I18NMessage.get(DBManager.class, "DBManager.label11", "\u88c5\u8f7d\u6570\u636e\u5e93\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u6210\u529f\uff01"));
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label12", "\u88c5\u8f7d\u6570\u636e\u5e93\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25(Application.start)"), exception);
            }
            Object var4_2 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddTable(String string) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(10, I18NMessage.get(DBManager.class, "DBManager.label13", "\u65e0\u6548\u7684\u6570\u636e\u5e93\u540d\u79f0!"));
        }
        Connection connection = this.getConnection();
        try {
            try {
                this.getTableInfos().notifyAddTable(connection, this.getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase(), string);
            }
            catch (CMyException cMyException) {
                cMyException.printStackTrace();
                Object var5_4 = null;
                if (connection == null) {
                    this.freeConnection(connection);
                }
            }
            Object var5_3 = null;
            if (connection == null) {
                this.freeConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) {
                this.freeConnection(connection);
            }
            throw throwable;
        }
    }

    public void notifyRemoveTable(String string) throws WCMException {
        this.getTableInfos().notifyRemoveTable(string);
    }

    private synchronized void clearTableInfos() {
        if (this.m_oTableInfos == null) {
            return;
        }
        this.m_oTableInfos.clear();
    }

    private synchronized void initDBIdManager() throws WCMException {
        if (this.m_oDbIdManager == null) {
            this.m_oDbIdManager = new DBIdManager();
        }
        Connection connection = null;
        try {
            try {
                connection = this.getDBPool().getConnection();
                this.m_oDbIdManager.load(connection, this.getDBType().sqlGetNextId());
                logger.info((Object)I18NMessage.get(DBManager.class, "DBManager.label14", "\u88c5\u8f7d\u6570\u636e\u5e93ID\u5b57\u6bb5\u4fe1\u606f\u6210\u529f\uff01"));
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label15", "\u88c5\u8f7d\u6570\u636e\u5e93ID\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25(Application.start)"), exception);
            }
            Object var4_2 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
            throw throwable;
        }
    }

    private synchronized void clearDBIdManager() {
        if (this.m_oDbIdManager == null) {
            return;
        }
        this.m_oDbIdManager = null;
    }

    public void freeConnection(Connection connection) {
        if (this.m_oDBPool == null) {
            return;
        }
        this.m_oDBPool.free(connection);
    }

    public String toDBInfo() throws WCMException {
        String string = I18NMessage.get(DBManager.class, "DBManager.label16", "\u5f53\u524d\u6570\u636e\u5e93\u4fe1\u606f\u4e3a\uff1a\nDBConfig:") + this.getDBConnConfig() + "\n" + "DBPool:" + this.getDBPool() + "\n" + "TableInfos:" + this.m_oTableInfos + "\n";
        return string;
    }

    public ConnectionCache getConnectionCache() throws WCMException {
        return this.getDBPool().getConnectionCache();
    }

    private ConnectionPool getDBPool() throws WCMException {
        if (this.m_oDBPool == null) {
            this.initDBPool();
        }
        return this.m_oDBPool;
    }

    public DBIdManager getDBIdManager() throws WCMException {
        if (this.m_oDbIdManager == null) {
            this.initDBIdManager();
        }
        return this.m_oDbIdManager;
    }

    public TableInfos getTableInfos() throws WCMException {
        if (this.m_oTableInfos == null) {
            this.initTableInfos();
        }
        return this.m_oTableInfos;
    }

    protected void doShutdown() {
        this.release();
    }

    protected boolean doStart() throws WCMException {
        return this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sqlExecUpdateProcedure(String string) throws WCMException {
        boolean bl;
        if (string == null) {
            return false;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.prepareCall("{ call " + string + "  }");
                bl = statement.execute();
                Object var6_6 = null;
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (statement == null) return bl;
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label17", "\u6267\u884c\u6307\u5b9a\u7684\u5b58\u50a8\u8fc7\u7a0b\u5931\u8d25") + string + "\uff08Application._sqlExecUpdateProcedure\uff09", exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        statement.close();
        return bl;
    }

    public ResultSet sqlExecuteQuery(String string) throws WCMException {
        return this.sqlExecuteQuery(string, 0);
    }

    public ResultSet sqlExecuteQuery(String string, int n) throws WCMException {
        if (string.length() < 5) {
            return null;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                if (n > 0) {
                    statement.setMaxRows(n);
                }
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + string, sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + string, exception);
            }
            Object var8_6 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
            throw throwable;
        }
        return resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sqlExecuteIntQuery(String string) throws WCMException {
        if (string.length() < 5) {
            return -999;
        }
        int n = -999;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                statement.setMaxRows(1);
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + string, sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label18", "\u67e5\u8be2\u6570\u636e\u5931\u8d25app._sqlExecuteQuery\uff1aSQL=") + string, exception);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (statement != null) {
                    statement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            this.freeConnection(connection);
        }
        if (statement != null) {
            statement.close();
        }
        if (resultSet == null) return n;
        resultSet.close();
        return n;
    }

    public int sqlExecuteIntQuery(WCMFilter wCMFilter) throws WCMException {
        if (wCMFilter == null) {
            return -999;
        }
        String string = wCMFilter.toSQL();
        List list = wCMFilter.getSearchValues();
        return this.sqlExecuteIntQuery(string, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sqlExecuteIntQuery(String string, List list) throws WCMException {
        int n = -999;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setMaxRows(1);
                DBManager.setParameters(preparedStatement, list);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, exception);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            this.freeConnection(connection);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return n;
        resultSet.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long sqlExecuteQuery(String string, List list, long l) throws WCMException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block17: {
            long l2;
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setMaxRows(1);
                    DBManager.setParameters(preparedStatement, list);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block17;
                    l2 = resultSet.getLong(1);
                    Object var11_10 = null;
                }
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, exception);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (connection != null) {
                        this.freeConnection(connection);
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSet == null) throw throwable;
                    resultSet.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return l2;
            }
            if (connection != null) {
                this.freeConnection(connection);
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet == null) return l2;
            resultSet.close();
            return l2;
        }
        Object var11_11 = null;
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            this.freeConnection(connection);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return l;
        resultSet.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sqlExecuteQuery(String string, List list, int n) throws WCMException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block17: {
            int n2;
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    connection = this.getConnection();
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setMaxRows(1);
                    DBManager.setParameters(preparedStatement, list);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block17;
                    n2 = resultSet.getInt(1);
                    Object var9_10 = null;
                }
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + string, exception);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (connection != null) {
                        this.freeConnection(connection);
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSet == null) throw throwable;
                    resultSet.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return n2;
            }
            if (connection != null) {
                this.freeConnection(connection);
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet == null) return n2;
            resultSet.close();
            return n2;
        }
        Object var9_11 = null;
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            this.freeConnection(connection);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return n;
        resultSet.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] sqlExecuteIntsQuery(WCMFilter wCMFilter) throws WCMException {
        if (wCMFilter == null) {
            return new int[0];
        }
        WCMFilter wCMFilter2 = new WCMFilter(wCMFilter);
        wCMFilter2.setSelect("count(" + wCMFilter2.getSelect() + ")");
        int n = this.sqlExecuteIntQuery(wCMFilter2);
        if (n <= 0) {
            return new int[0];
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int[] nArray = new int[n];
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(wCMFilter.toSQL());
                DBManager.setParameters(preparedStatement, wCMFilter.getSearchValues());
                int n2 = 0;
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    if (n2 >= nArray.length) {
                        int[] nArray2 = new int[nArray.length + 1];
                        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                        nArray = nArray2;
                    }
                    nArray[n2++] = resultSet.getInt(1);
                }
                Object var11_12 = null;
            }
            catch (SQLException sQLException) {
                throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + wCMFilter.toSQL(), sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + wCMFilter.toSQL(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            this.freeConnection(connection);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return nArray;
        resultSet.close();
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] sqlExecuteStringsQuery(WCMFilter wCMFilter) throws WCMException {
        if (wCMFilter == null) {
            return new String[0];
        }
        WCMFilter wCMFilter2 = new WCMFilter(wCMFilter);
        wCMFilter2.setSelect("count(" + wCMFilter2.getSelect() + ")");
        int n = this.sqlExecuteIntQuery(wCMFilter2);
        if (n <= 0) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(wCMFilter.toSQL());
                DBManager.setParameters(preparedStatement, wCMFilter.getSearchValues());
                int n2 = 0;
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    if (n2 >= stringArray.length) {
                        String[] stringArray2 = new String[stringArray.length + 1];
                        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                        stringArray = stringArray2;
                    }
                    stringArray[n2++] = resultSet.getString(1);
                }
                Object var11_12 = null;
            }
            catch (SQLException sQLException) {
                throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + wCMFilter.toSQL(), sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + wCMFilter.toSQL(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            this.freeConnection(connection);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return stringArray;
        resultSet.close();
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sqlExecuteCountQuery(WCMFilter wCMFilter) throws WCMException {
        if (wCMFilter == null) {
            return -999;
        }
        int n = -999;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement(wCMFilter.toCountSQL());
                preparedStatement.setMaxRows(1);
                DBManager.setParameters(preparedStatement, wCMFilter.getSearchValues());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + wCMFilter.toSQL(), sQLException);
            }
            catch (Exception exception) {
                throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label19", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + wCMFilter.toSQL(), exception);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (connection != null) {
            this.freeConnection(connection);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return n;
        resultSet.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sqlExecuteUpdate(String[] stringArray) throws WCMException {
        int n;
        if (stringArray.length < 1) {
            return 0;
        }
        Connection connection = null;
        Statement statement = null;
        int n2 = -1;
        int n3 = 0;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (stringArray[n2] == null) continue;
                    n3 = statement.executeUpdate(stringArray[n2]);
                }
                n = n3;
                Object var8_8 = null;
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (statement == null) return n;
            }
            catch (Exception exception) {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append(I18NMessage.get(DBManager.class, "DBManager.label20", "\u6267\u884cSQL\u8bed\u53e5\u5931\u8d25"));
                if (n2 >= 0) {
                    string = ":" + stringArray[0];
                    throw new WCMException(1100, stringBuilder.append(string).append("\uff08Application._sqlExecuteUpdate\uff09").toString(), exception);
                }
                string = "";
                throw new WCMException(1100, stringBuilder.append(string).append("\uff08Application._sqlExecuteUpdate\uff09").toString(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return n;
        }
        statement.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sqlExecuteUpdate(String string) throws WCMException {
        int n;
        if (string == null) {
            return 0;
        }
        Connection connection = null;
        Statement statement = null;
        int n2 = 0;
        try {
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                n = n2 = statement.executeUpdate(string);
                Object var7_7 = null;
                if (connection != null) {
                    this.freeConnection(connection);
                }
                if (statement == null) return n;
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label20", "\u6267\u884cSQL\u8bed\u53e5\u5931\u8d25") + string + "\uff08Application._sqlExecuteUpdate\uff09", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return n;
        }
        statement.close();
        return n;
    }

    /*
     * Loose catch block
     */
    public void sqlExecuteUpdate(String[] stringArray, int[] nArray) throws WCMException {
        Connection connection;
        block11: {
            connection = this.getConnection();
            Statement statement = null;
            int n = -1;
            if (!connection.getAutoCommit()) {
                logger.error((Object)"sqlExecuteUpdate not  autocommit");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                statement = connection.prepareStatement(stringArray[n]);
                for (int i = 0; i < nArray.length; ++i) {
                    statement.setInt(i + 1, nArray[i]);
                }
                statement.executeUpdate();
                statement.close();
                statement = null;
            }
            Object var8_8 = null;
            if (statement == null) break block11;
            try {
                statement.close();
                break block11;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block11;
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label21", "\u6267\u884c") + stringArray[n] + I18NMessage.get(DBManager.class, "DBManager.label22", "\u5931\u8d25\uff01"), exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.freeConnection(connection);
                throw throwable;
            }
        }
        this.freeConnection(connection);
    }

    /*
     * Loose catch block
     */
    public void sqlExecuteUpdate(String[] stringArray, Object[] objectArray) throws WCMException {
        Connection connection;
        block11: {
            int n;
            connection = this.getConnection();
            Statement statement = null;
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                statement = connection.prepareStatement(stringArray[n]);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (objectArray[n2] instanceof CMyDateTime) {
                        statement.setTimestamp(n2 + 1, ((CMyDateTime)objectArray[n2]).toTimestamp());
                        continue;
                    }
                    statement.setObject(n2 + 1, objectArray[n2]);
                }
                statement.executeUpdate();
                statement.close();
                statement = null;
            }
            Object var9_7 = null;
            if (statement == null) break block11;
            try {
                statement.close();
                break block11;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block11;
                catch (Exception exception) {
                    throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label23", "\u8bbe\u7f6eParamer#") + (n2 + 1) + I18NMessage.get(DBManager.class, "DBManager.label24", "\u5931\u8d25\uff01\nSQL=") + stringArray[n], exception);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.freeConnection(connection);
                throw throwable;
            }
        }
        this.freeConnection(connection);
    }

    public static void setParameters(PreparedStatement preparedStatement, List list) throws WCMException {
        if (preparedStatement == null || list == null || list.size() <= 0) {
            return;
        }
        Object var2_2 = null;
        int n = 0;
        try {
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                var2_2 = list.get(n);
                if (var2_2 == null) continue;
                if (var2_2 instanceof Long) {
                    preparedStatement.setLong(n + 1, (Long)var2_2);
                    continue;
                }
                if (var2_2 instanceof Float) {
                    preparedStatement.setFloat(n + 1, ((Float)var2_2).floatValue());
                    continue;
                }
                if (var2_2 instanceof Double) {
                    preparedStatement.setDouble(n + 1, (Double)var2_2);
                    continue;
                }
                if (var2_2 instanceof Integer) {
                    preparedStatement.setInt(n + 1, (Integer)var2_2);
                    continue;
                }
                if (var2_2 instanceof String) {
                    preparedStatement.setString(n + 1, var2_2);
                    continue;
                }
                if (var2_2 instanceof CMyDateTime) {
                    preparedStatement.setTimestamp(n + 1, ((CMyDateTime)var2_2).toTimestamp());
                    continue;
                }
                if (var2_2 instanceof CDBText) {
                    preparedStatement.setString(n + 1, ((CDBText)var2_2).getText());
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(DBManager.class, "DBManager.label25", "\u672a\u77e5\u7684\u5bf9\u8c61") + (n + 1) + I18NMessage.get(DBManager.class, "DBManager.label26", "\u5c5e\u6027\u7c7b\u578b"));
            }
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label27", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570[Index=") + (n + 1) + ", value=" + var2_2 + I18NMessage.get(DBManager.class, "DBManager.label28", "]\u65f6\u51fa\u9519"), sQLException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label27", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570[Index=") + (n + 1) + ", value=" + var2_2 + I18NMessage.get(DBManager.class, "DBManager.label28", "]\u65f6\u51fa\u9519"), exception);
        }
    }

    /*
     * Loose catch block
     */
    public int sqlExecuteIntQuery(String string, int[] nArray) throws WCMException {
        Connection connection;
        int n;
        block16: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block15: {
                n = -999;
                connection = this.getConnection();
                preparedStatement = null;
                resultSet = null;
                preparedStatement = connection.prepareStatement(string);
                for (int i = 0; i < nArray.length; ++i) {
                    preparedStatement.setInt(i + 1, nArray[i]);
                }
                preparedStatement.setMaxRows(1);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                resultSet.close();
                resultSet = null;
                preparedStatement.close();
                preparedStatement = null;
                Object var9_9 = null;
                if (resultSet == null) break block15;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                    break block16;
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
                {
                }
            }
            break block16;
            {
                catch (Exception exception3) {
                    throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label29", "\u6267\u884cSQL\u5931\u8d25\uff01"), exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var9_10 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                this.freeConnection(connection);
                throw throwable;
            }
        }
        this.freeConnection(connection);
        return n;
    }

    /*
     * Loose catch block
     */
    public String sqlExecuteStringQuery(String string, int[] nArray) throws WCMException {
        Connection connection;
        String string2;
        block16: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block15: {
                string2 = null;
                connection = this.getConnection();
                preparedStatement = null;
                resultSet = null;
                preparedStatement = connection.prepareStatement(string);
                for (int i = 0; i < nArray.length; ++i) {
                    preparedStatement.setInt(i + 1, nArray[i]);
                }
                preparedStatement.setMaxRows(1);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                resultSet.close();
                resultSet = null;
                preparedStatement.close();
                preparedStatement = null;
                Object var9_9 = null;
                if (resultSet == null) break block15;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                    break block16;
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
                {
                }
            }
            break block16;
            {
                catch (Exception exception3) {
                    throw new WCMException(I18NMessage.get(DBManager.class, "DBManager.label29", "\u6267\u884cSQL\u5931\u8d25\uff01"), exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var9_10 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                this.freeConnection(connection);
                throw throwable;
            }
        }
        this.freeConnection(connection);
        return string2;
    }

    public static void setParameters(PreparedStatement preparedStatement, WCMFilter wCMFilter) throws WCMException {
        if (preparedStatement == null || wCMFilter == null) {
            return;
        }
        List list = wCMFilter.getSearchValues();
        if (list == null) {
            return;
        }
        try {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (e == null) continue;
                if (e instanceof Long) {
                    preparedStatement.setLong(i + 1, (Long)e);
                    continue;
                }
                if (e instanceof Float) {
                    preparedStatement.setFloat(i + 1, ((Float)e).floatValue());
                    continue;
                }
                if (e instanceof Double) {
                    preparedStatement.setDouble(i + 1, (Double)e);
                    continue;
                }
                if (e instanceof Integer) {
                    preparedStatement.setInt(i + 1, (Integer)e);
                    continue;
                }
                if (e instanceof String) {
                    preparedStatement.setString(i + 1, (String)e);
                    continue;
                }
                if (e instanceof CMyDateTime) {
                    preparedStatement.setTimestamp(i + 1, ((CMyDateTime)e).toTimestamp());
                    continue;
                }
                if (e instanceof CDBText) {
                    preparedStatement.setString(i + 1, ((CDBText)e).getText());
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(DBManager.class, "DBManager.label25", "\u672a\u77e5\u7684\u5bf9\u8c61") + (i + 1) + I18NMessage.get(DBManager.class, "DBManager.label30", "\u5c5e\u6027\u7c7b\u578b\uff1a"));
            }
        }
        catch (SQLException sQLException) {
            throw new WCMException(40, I18NMessage.get(DBManager.class, "DBManager.label31", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u51fa\u9519"), sQLException);
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(DBManager.class, "DBManager.label31", "\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u586b\u5199PreparedStatement\u53c2\u6570\u65f6\u51fa\u9519"), exception);
        }
    }

    public void reloadTableInfo(String string) throws WCMException {
        this.reloadTableInfo(string, true);
    }

    public void reloadTableInfo(String string, boolean bl) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        Connection connection = this.getConnection();
        try {
            try {
                this.getTableInfos().load(connection, this.getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase(), string);
            }
            catch (Exception exception) {
                if (!bl) {
                    logger.warn((Object)"Reload failed, sleep 300ms & take a second shot.", (Throwable)exception);
                    try {
                        Thread.sleep(300L);
                        this.getTableInfos().load(connection, this.getDBType(), this.getDBConnConfig().getConnectionUser().toUpperCase(), string);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    Object var7_5 = null;
                    if (connection != null) {
                        this.freeConnection(connection);
                    }
                    return;
                }
                throw new WCMException(1100, I18NMessage.get(DBManager.class, "DBManager.label32", "\u88c5\u8f7d\u6307\u5b9a\u8868[") + string + I18NMessage.get(DBManager.class, "DBManager.label33", "]\u5931\u8d25\uff01"), exception);
            }
            Object var7_4 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (connection != null) {
                this.freeConnection(connection);
            }
            throw throwable;
        }
        if (!bl) {
            return;
        }
        try {
            IClusterMsgCenter iClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            iClusterMsgCenter.send("RELOAD.TABLE", new String[]{string});
        }
        catch (Exception exception) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", exception);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(DBManager.getDBManager().isKeywords("WHILE"));
        try {
            DBManager.getDBManager().setServerName(I18NMessage.get(DBManager.class, "DBManager.label34", "\u6570\u636e\u5e93\u7ba1\u7406\u5668\uff01"));
            DBManager.getDBManager().startup();
            logger.info((Object)DBManager.getDBManager().toDBInfo());
            DBManager.getDBManager().shutdown();
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(DBManager.class, "DBManager.label35", "\u6d4b\u8bd5\u5931\u8d25\uff01"), (Throwable)exception);
        }
    }
}

