/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.db;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.persistent.IConfigElement;
import com.trs.infra.util.database.DBType;

public class DBConnectionConfig
implements IConfigElement {
    private String m_sName;
    private String m_sClassName;
    private String m_sConnectionURL;
    private String m_sConnectionUser;
    private String m_sConnectionPassword;
    private String m_sCacheScheme;
    private int m_nInitConnects;
    private int m_nMaxConnects;
    private int m_iTimeToLiveOverUse = -1;
    private boolean m_bWaitIfBusy;
    private boolean m_bDowithClob;
    private boolean m_zTraceAssign;
    private String m_sTestSQL;
    private boolean m_zTestOnAssign;
    private boolean m_zTestOnIdle;
    private int m_iMaxIdleTime;
    private int m_iMonitorInterval;
    private int m_iMaxOrphanTime;
    private DBType m_oDbType = null;

    public void setName(String string) {
        this.m_sName = string;
    }

    public String getName() {
        return this.m_sName;
    }

    public boolean isWaitIfBusy() {
        return this.m_bWaitIfBusy;
    }

    public void setWaitIfBusy(boolean bl) {
        this.m_bWaitIfBusy = bl;
    }

    public int getInitConnects() {
        return this.m_nInitConnects;
    }

    public void setInitConnects(int n) {
        this.m_nInitConnects = n;
    }

    public int getMaxConnects() {
        return this.m_nMaxConnects;
    }

    public void setMaxConnects(int n) {
        this.m_nMaxConnects = n;
    }

    public String getClassName() {
        return this.m_sClassName;
    }

    public void setClassName(String string) {
        this.m_sClassName = string;
    }

    public String getConnectionPassword() {
        return this.m_sConnectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.m_sConnectionPassword = string;
    }

    public String getConnectionURL() {
        return this.m_sConnectionURL;
    }

    public void setConnectionURL(String string) {
        this.m_sConnectionURL = string;
    }

    public String getConnectionUser() {
        return this.m_sConnectionUser;
    }

    public void setConnectionUser(String string) {
        this.m_sConnectionUser = string;
    }

    public boolean isDowithClob() {
        return this.m_bDowithClob;
    }

    public void setDowithClob(boolean bl) {
        this.m_bDowithClob = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBType getDBType() {
        try {
            if (this.m_oDbType == null) {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName(this.getClassName());
                synchronized (clazz2) {
                    this.m_oDbType = (DBType)clazz.newInstance();
                }
            }
            return this.m_oDbType;
        }
        catch (Exception exception) {
            throw new RuntimeException(I18NMessage.get(DBConnectionConfig.class, "DBConnectionConfig.label1", "\u65e0\u6cd5\u5c06[") + this.getClassName() + I18NMessage.get(DBConnectionConfig.class, "DBConnectionConfig.label2", "]\u6784\u9020\u6210\u76f8\u5e94\u6570\u636e\u7c7b\u578b\u7684\u5b9e\u4f8b"), exception);
        }
    }

    public boolean isTraceAssign() {
        return this.m_zTraceAssign;
    }

    public void setTraceAssign(boolean bl) {
        this.m_zTraceAssign = bl;
    }

    public int getTimeToLiveOverUse() {
        return this.m_iTimeToLiveOverUse;
    }

    public void setTimeToLiveOverUse(int n) {
        this.m_iTimeToLiveOverUse = n;
    }

    public String getCacheScheme() {
        return this.m_sCacheScheme;
    }

    public void setCacheScheme(String string) {
        this.m_sCacheScheme = string;
    }

    public String getTestSQL() {
        return this.m_sTestSQL;
    }

    public void setTestSQL(String string) {
        this.m_sTestSQL = string;
    }

    public boolean isTestOnAssign() {
        return this.m_zTestOnAssign;
    }

    public void setTestOnAssign(boolean bl) {
        this.m_zTestOnAssign = bl;
    }

    public int getMaxIdleTime() {
        return this.m_iMaxIdleTime;
    }

    public void setMaxIdleTime(int n) {
        this.m_iMaxIdleTime = n;
    }

    public int getMonitorInterval() {
        return this.m_iMonitorInterval;
    }

    public void setMonitorInterval(int n) {
        this.m_iMonitorInterval = n;
    }

    public boolean isTestOnIdle() {
        return this.m_zTestOnIdle;
    }

    public void setTestOnIdle(boolean bl) {
        this.m_zTestOnIdle = bl;
    }

    public int getMaxOrphanTime() {
        return this.m_iMaxOrphanTime;
    }

    public void setMaxOrphanTime(int n) {
        this.m_iMaxOrphanTime = n;
    }
}

