/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.cache;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.cache.CachedObjectConfig;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyMemory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class CachedPOMgr
implements ICachedPOMgr {
    private static final Logger s_logger = Logger.getLogger((String)CachedPOMgr.class.getName());
    protected Hashtable[] m_hBuffers = null;
    private CachedObjectConfig[] m_arConfigs = null;
    private ArrayList m_lCachedIndex = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean init() throws WCMException {
        if (this.m_hBuffers != null) {
            return true;
        }
        s_logger.info((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label1", "\u542f\u52a8[\u5bf9\u8c61\u7f13\u51b2]\u524d\u7cfb\u7edf\u5185\u5b58:") + CMyMemory.toMemoryInfo()));
        int n = this.getConfigs().length;
        Hashtable[] hashtableArray = new Hashtable[n];
        for (int i = 0; i < n; ++i) {
            hashtableArray[i] = new Hashtable();
        }
        Connection connection = null;
        try {
            connection = this.getDBManager().getConnection();
            for (int i = 0; i < n; ++i) {
                try {
                    this.initBuffer(hashtableArray[i], connection, (BaseObj)this.getPojo(this.getConfigs()[i].getCachedObjectClass()));
                    s_logger.info((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label2", "\u7f13\u51b2\u5bf9\u8c61[") + i + "][" + this.getConfigs()[i].getName() + I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label3", "]\u521d\u59cb\u5316\u5b8c\u6210\uff01")));
                    continue;
                }
                catch (Exception exception) {
                    s_logger.error((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label2", "\u7f13\u51b2\u5bf9\u8c61[") + i + "][" + this.getConfigs()[i].getName() + I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label4", "]\u521d\u59cb\u5316\u5931\u8d25\uff01")), (Throwable)exception);
                }
            }
            this.m_hBuffers = hashtableArray;
            Object var7_7 = null;
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (connection != null) {
                this.getDBManager().freeConnection(connection);
            }
            throw throwable;
        }
        s_logger.info((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label5", "\u542f\u52a8[\u5bf9\u8c61\u7f13\u51b2]\u540e\u7cfb\u7edf\u5185\u5b58:") + CMyMemory.toMemoryInfo()));
        return true;
    }

    private Object getPojo(Class clazz) throws WCMException {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new WCMException(10, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label6", "\u5b9e\u4f8b\u5316\u7c7b[") + clazz.getName() + I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label7", "]\u51fa\u73b0\u5f02\u5e38\uff01\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u6587\u4ef6"));
        }
    }

    private BaseObj getObjFromBuffer(int n, int n2) throws WCMException {
        return this.getObjFromBuffer(n, (Object)new Integer(n2));
    }

    private BaseObj getObjFromBuffer(int n, Object object) throws WCMException {
        if (n < 0 || n >= this.getBufferSize()) {
            return null;
        }
        return (BaseObj)this.getBuffer(n).get(object);
    }

    public Hashtable getBuffer(int n) throws WCMException {
        if (n < 0 || n >= this.getBufferSize()) {
            return null;
        }
        return this.getBuffers()[n];
    }

    /*
     * Loose catch block
     */
    private void initBuffer(Hashtable hashtable, Connection connection, BaseObj baseObj) throws WCMException {
        block18: {
            Statement statement = null;
            ResultSet resultSet = null;
            ResultSetMetaData resultSetMetaData = null;
            BaseObj baseObj2 = null;
            Class<?> clazz = baseObj.getClass();
            String string = "SELECT * FROM " + baseObj.getDbTableName() + " ORDER BY " + baseObj.getIdFieldName();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            resultSetMetaData = null;
            int n = 0;
            while (resultSet.next()) {
                if (resultSetMetaData == null) {
                    resultSetMetaData = resultSet.getMetaData();
                }
                baseObj2 = (BaseObj)clazz.newInstance();
                baseObj2.readFromRs(resultSet, resultSetMetaData);
                hashtable.put(baseObj2.getKey(), baseObj2);
                ++n;
            }
            Object var12_13 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                break block18;
            }
            catch (Exception exception) {}
            break block18;
            {
                catch (SQLException sQLException) {
                    throw new WCMException(40, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label8", "CachedPOMgr\u521d\u59cb\u5316\u7f13\u51b2\u533a\u51fa\u9519[") + baseObj.getDbTableName() + "." + baseObj.getIdFieldName() + "]", sQLException);
                }
                catch (Exception exception) {
                    throw new WCMException(0, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label8", "CachedPOMgr\u521d\u59cb\u5316\u7f13\u51b2\u533a\u51fa\u9519[") + baseObj.getDbTableName() + "." + baseObj.getIdFieldName() + "]", exception);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private boolean removeCachedPO(BaseObj baseObj) {
        try {
            int n = this.getCacheIndex(baseObj.getClass());
            if (n < 0) {
                return false;
            }
            this.getBuffer(n).remove(baseObj.getKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean addCachedPO(BaseObj baseObj) {
        try {
            int n = this.getCacheIndex(baseObj.getClass());
            if (n < 0) {
                return false;
            }
            if (this.getBuffer(n).get(baseObj.getKey()) == null) {
                this.getBuffer(n).put(baseObj.getKey(), baseObj);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void clear() {
        this.clearCacheIndex();
        this.clearConfig();
        this.clearBuffer();
    }

    private void clearCacheIndex() {
        if (this.m_lCachedIndex == null) {
            return;
        }
        this.m_lCachedIndex.clear();
        this.m_lCachedIndex = null;
    }

    private void clearConfig() {
        if (this.m_arConfigs == null) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label9", "\u6b63\u5728\u6e05\u7a7a\u7f13\u51b2\u5bf9\u8c61\u7684\u914d\u7f6e\u4fe1\u606f..."));
        for (int i = 0; i < this.m_arConfigs.length; ++i) {
            if (this.m_arConfigs[i] != null) continue;
        }
        this.m_arConfigs = null;
        s_logger.info((Object)I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label10", "\u6e05\u7a7a\u7f13\u51b2\u5bf9\u8c61\u7684\u914d\u7f6e\u4fe1\u606f\u5b8c\u6210\uff01"));
    }

    private void clearBuffer() {
        if (this.m_hBuffers == null) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label11", "\u6b63\u5728\u6e05\u7a7a\u5bf9\u8c61\u7684\u7f13\u51b2..."));
        for (int i = 0; i < this.m_hBuffers.length; ++i) {
            if (this.m_hBuffers[i] == null) continue;
            this.m_hBuffers[i].clear();
            this.m_hBuffers[i] = null;
        }
        this.m_hBuffers = null;
        s_logger.info((Object)I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label12", "\u6e05\u7a7a\u5bf9\u8c61\u7684\u7f13\u51b2\u5b8c\u6210!"));
    }

    public void notifyOnAddObj(BaseObj baseObj) {
        this.addCachedPO(baseObj);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) {
        this.removeCachedPO(baseObj);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) {
    }

    public boolean isCached(Class clazz) {
        return this.isCached(clazz.getName());
    }

    public boolean isCached(String string) {
        return this.getCachedIndex().contains(string);
    }

    public int getCacheIndex(Class clazz) {
        return this.getCacheIndex(clazz.getName());
    }

    public int getCacheIndex(String string) {
        return this.getCachedIndex().indexOf(string);
    }

    public BaseObj getObjFromBuffer(String string, int n) throws WCMException {
        return this.getObjFromBuffer(this.getCacheIndex(string), n);
    }

    public BaseObj getObjFromBuffer(Class clazz, int n) throws WCMException {
        return this.getObjFromBuffer(this.getCacheIndex(clazz), n);
    }

    public BaseObj getObjFromBuffer(Class clazz, Object object) throws WCMException {
        return this.getObjFromBuffer(this.getCacheIndex(clazz), object);
    }

    private void loadConfigs() {
        if (this.m_arConfigs != null) {
            return;
        }
        List list = XMLConfigServer.getInstance().getConfigObjects(CachedObjectConfig.class);
        this.m_arConfigs = list == null || list.size() == 0 ? new CachedObjectConfig[0] : CachedPOMgr.toCachedObjectConfigArray(list);
    }

    public CachedObjectConfig[] getConfigs() {
        if (this.m_arConfigs == null) {
            this.loadConfigs();
        }
        return this.m_arConfigs;
    }

    private void loadCachedIndex() {
        if (this.m_lCachedIndex != null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.getConfigs().length);
        for (int i = 0; i < this.getConfigs().length; ++i) {
            arrayList.add(this.getConfigs()[i].getClassName());
        }
        this.m_lCachedIndex = arrayList;
    }

    protected ArrayList getCachedIndex() {
        if (this.m_lCachedIndex == null) {
            this.loadCachedIndex();
        }
        return this.m_lCachedIndex;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager dBManager = DBManager.getDBManager();
        if (dBManager == null || !dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label13", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!dBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label14", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return dBManager;
    }

    public Hashtable getBuffer(Class clazz) throws WCMException {
        return this.getBuffer(this.getCacheIndex(clazz));
    }

    protected int getBufferSize() throws WCMException {
        return this.getBuffers().length;
    }

    protected Hashtable[] getBuffers() throws WCMException {
        if (this.m_hBuffers == null) {
            this.init();
        }
        return this.m_hBuffers;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        this.init();
        return true;
    }

    private static CachedObjectConfig[] toCachedObjectConfigArray(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        CachedObjectConfig[] cachedObjectConfigArray = new CachedObjectConfig[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            cachedObjectConfigArray[i] = (CachedObjectConfig)list.get(i);
        }
        return cachedObjectConfigArray;
    }
}

